/***************************************************************************
                          kpgitemsfolder.cpp  -  description
                             -------------------
    begin                : � led 6 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpgitemsfolder.h"

// include files for KDE
#include <klistbox.h>
#include <kcombobox.h>
#include <klistview.h>

#include "kpgconnection.h"
#include "kpgobject.h"

KPGItemsFolder::KPGItemsFolder(KPGTreeItem *parent, const QString name)
  : KPGTreeItem(parent, name)
{
    setPixmap(0, *m_pIconFolderBlue);
}

KPGItemsFolder::~KPGItemsFolder()
{
}

/*
// if parent item is KPGSchema that is not public, reurn its name
const QString KPGItemsFolder::getParentNameIfNamespace() const
{
  KPGTreeItem *pParentItem = static_cast <KPGTreeItem *> (parent()); 
  if(pParentItem && pParentItem->type() == KPGTreeItem::nodeSchema)
  {
    QString strNamespace(pParentItem->text(0));
    if(strNamespace == "public") strNamespace.truncate(0);
    return strNamespace;
  }
  return ""; 
}
*/

void KPGItemsFolder::fillListBoxWithChildItems(QListBox *pListBox)
{
    QListViewItem * pItem = firstChild();
    while(pItem)
    {
        KPGTreeItem *pTreeItem = static_cast <KPGTreeItem *> (pItem); 
        
        pListBox->insertItem(new KPGListBoxItem(* pTreeItem->pixmap(0), pTreeItem->text(0), pTreeItem->type()));    
        
        pItem = pItem->nextSibling();
    }
}

void KPGItemsFolder::fillListBoxWithChildItems(KListBox *pListBox)
{
	QListViewItem * pItem = firstChild();
	while(pItem)
	{
		KPGTreeItem *pTreeItem = static_cast <KPGTreeItem *> (pItem); 
    
    pListBox->insertItem(new KPGListBoxItem(* pTreeItem->pixmap(0), pTreeItem->text(0), pTreeItem->type()));		
	  
		pItem = pItem->nextSibling();
	}
}

void KPGItemsFolder::fillComboBoxWithChildItems(KComboBox *pComboBox)
{
    QListViewItem * pItem = firstChild();
    while(pItem)
    {
        pComboBox->insertItem(* pItem->pixmap(0), pItem->text(0));   
        
        pItem = pItem->nextSibling();
  }
}

void KPGItemsFolder::fillListOfObjectOidsWithChildItems(KPGOidNameList & listOfObjectOids)
{
    QListViewItem * pItem = firstChild();
    while(pItem)
    {
        KPGTreeItem *pTreeItem = static_cast <KPGTreeItem *> (pItem);
        
        if(pTreeItem->hasOid()) 
        {
        	KPGObject *pPGObject = static_cast <KPGObject *> (pItem);
        	 
            listOfObjectOids.append(KPGOidName(pPGObject->oid(), pPGObject->text(0), pPGObject->type(), pPGObject->pixmap(0), pPGObject->description()));
        }
        
        pItem = pItem->nextSibling();
    }
}

// Try find child object by given OID
KPGObject * KPGItemsFolder::getChildItemByOid(pqxx::oid _oid)
{
    QListViewItem * pItem = firstChild();
    while(pItem)
    {
        KPGTreeItem *pTreeItem = static_cast <KPGTreeItem *> (pItem);
        
        if(pTreeItem->hasOid()) 
        { 
            KPGObject *pObject = static_cast <KPGObject *> (pTreeItem);
            if(pObject->oid() == _oid)
            	return pObject;
        }
        
        pItem = pItem->nextSibling();
    }
    
    return 0;
}
