//
// C++ Interface: kpguniqueconstrproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGUNIQUECONSTRPROPPAGE_H
#define KPGUNIQUECONSTRPROPPAGE_H

#include "kpguniqueconstrproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGUniqueConstr;

/**
  * Unique Constraint properties
  *
  * @author Lumir Vanek
  */
class KPGUniqueConstrPropPage : public KPGUniqueConstrPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGUniqueConstrPropPage(QWidget *parent, KPGUniqueConstr *);
    ~KPGUniqueConstrPropPage();
	
	// Display properties of underlying database object
	virtual void displayProperties();
	
	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
protected:

	KPGUniqueConstr * m_pUniqueConstr;
	
protected slots:
  
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
	
signals:
	void sigSearchObject(const pqxx::oid);
	            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
