//
// C++ Interface: kpgutil
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGUTIL_H
#define KPGUTIL_H

// include files for Qt
#include <qstring.h>
#include <qpixmap.h>

// include files for libpgxx 
#include <pqxx/result> 

// Forward references
class QTable;
class KComboBox;
class KPGDatabase;

/**
  * Utility class with some helpful static functions
  *
  * @author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGUtil
{
private:
    KPGUtil(); // Don't instantiate me
    ~KPGUtil();

public:
	static const QString quotedName(const QString &);
	static const QString unquotedName(const QString &);
	static const QString unspacedName(const QString &);
	static const QString fullyQualifiedName(const QString &, const QString &);
	static const bool containsUpperCase(const QString &);
	
	static int fillPropertiesTable(const pqxx::result &, QTable *, bool = true, int = -1);
	static void fillComboBoxWithDatabaseSchemas(KPGDatabase *, KComboBox *, bool = false);

	//--- Common clibpoard action handling
    static void copyCell(QTable *);
    static void copyRow(QTable *);
    static void copyTableCsv(QTable *);
    static void copyTableXml(QTable *);

public:
    static QPixmap *m_pIconTrue;
	static QPixmap *m_pIconFalse;
};

#endif
