/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <KApplication>
#include <KAboutData>
#include <KCmdLineArgs>

#include "mainwindow.h"
#include "version.h"

/** The main function of KRadioRipper. */
int main (int argc, char * argv[])
{
  KAboutData aboutData("kradioripper", // internal program name
                       0, // name of the message catalog. 0: same as internal program name
                       ki18nc("@title KAboutData: displayed program name", "KRadioRipper"),
                       VERSION,
                       ki18nc("@title KAboutData: short program description",
                              "A program for recording audio streams."),
                       KAboutData::License_Unknown,  // will be overwritten later
                       ki18nc("@info:credit KAboutData: copyright hint",
                              "(c) 2007-2009 Tim Fechtner"),
                       ki18nc("@info KAboutData: further hints", "Based on Streamripper."),
                       "http://kradioripper.sourceforge.net/",
                       // bug email address:
                       QString("urwald%1users.sourceforge.net").arg("@").toLatin1());
  aboutData.addAuthor(ki18nc("@info:credit KAboutData/Author: name (do not translate this!)",
                             "Tim Fechtner"),
                      ki18nc("@info:credit KAboutData/Author: function", "Main author"),
                      QString("urwald%1users.sourceforge.net").arg("@").toLatin1());
  aboutData.addCredit(ki18nc("@info:credit KAboutData/Credit: name",
                             "Greg Sharp and the Streamripper team"),
                      ki18nc("@info:credit KAboutData/Credit: function",
                             "Authers of Streamripper, which is the base for KRadioRipper"),
                      QString("gregsharp%1users.sourceforge.net").arg("@").toLatin1(),
                      "http://streamripper.sourceforge.net/");
  aboutData.addCredit(ki18nc("@info:credit KAboutData/Credit: name", "Detlef Reichelt"),
                      ki18nc("@info:credit KAboutData/Credit: function", "Packages for Packman"),
                      QString("detlef%1links2linux.de").arg("@").toLatin1(),
                      "http://packman.links2linux.org/package/kradioripper");
  aboutData.addCredit(ki18nc("@info:credit KAboutData/Credit: name", "Rajko Bock"),
                      ki18nc("@info:credit KAboutData/Credit: function",
                             "Packages for Mandriva"),
                      QString("info%1randosweb.de").arg("@").toLatin1(),
                      "http://www.randosweb.de");
  // TODO aboutData.addCredit(ki18nc("@info:credit KAboutData/Credit: name", "Alessandro Ghersi"),
  //                    ki18nc("@info:credit KAboutData/Credit: function", "Packages for Ubuntu"),
  //                    QString("alessandro.ghersi%1fastwebnet.it").arg('@').toLatin1());
  // Set credits to translators manually to allow semantic markup.
  // (No fallback available in our .po! So don't change this.)
  aboutData.setTranslator(ki18nc("@info:credit NAME OF TRANSLATORS "
                                   "Dear translator. Enter your name here. This special "
                                   "string is used to display a credit to you at "
                                   "Help->About KRadioRipper->Translation",
                                 "Your names"),
                          ki18nc("@info:credit EMAIL OF TRANSLATORS "
                                   "Dear translator. Enter your email address here. This special "
                                   "string is used to display a credit to you at "
                                   "Help->About KRadioRipper->Translation "
                                   "Or leave it blank when you do not want to publish your email "
                                   "address. If you want, you can use %1 instead of the 'at' "
                                   "sign (for anti-spam reasons).",
                                 "Your emails").subs("@"));
#if KDE_IS_VERSION(4,1,0)
  // Overrides License_Unknown, which was specified in the constructor:
  aboutData.addLicenseText(ki18nc(
    "@info (%1 will be replaced by the 'at' sign - doing it this way for anti-spam reasons. "
      "Please use this also in the translation file.) The text is a modified version of the "
      "text that is proposed in the GPL. See http://www.gnu.org/licenses/translations.html for "
      "possibly yet available translations.",
    "Copyright (C) 2008-2009  Tim Fechtner &lt;urwald%1users.sourceforge.net&gt;<nl/>"
      "<nl/>"
      "This program is free software; you can redistribute it and/or<nl/>"
      "modify it under the terms of the GNU General Public License as<nl/>"
      "published by the Free Software Foundation; either version 2 of<nl/>"
      "the License or (at your option) version 3 or any later version<nl/>"
      "accepted by the membership of KDE e.V. (or its successor approved<nl/>"
      "by the membership of KDE e.V.), which shall act as a proxy<nl/>"
      "defined in Section 14 of version 3 of the license.<nl/>"
      "<nl/>"
      "This program is distributed in the hope that it will be useful,<nl/>"
      "but WITHOUT ANY WARRANTY; without even the implied warranty of<nl/>"
      "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the<nl/>"
      "GNU General Public License for more details.<nl/>"
      "<nl/>"
      "You should have received a copy of the GNU General Public License<nl/>"
      "along with this program.  If not, see &lt;http://www.gnu.org/licenses/&gt;.").subs("@"));
#endif
  KCmdLineArgs::init(argc, argv, &aboutData);
  KApplication app;
  if (app.isSessionRestored()) {
    kRestoreMainWindows< MainWindow >();
  } else {
    MainWindow * window = new MainWindow();
    window->setObjectName("KRadioRipperMainWindow#");  // '#' will be replaced with unique numbers
    window->show();
  };
  return app.exec();
}
