/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SETTINGS_STREAM_WIDGET_SPLITTING_H
#define SETTINGS_STREAM_WIDGET_SPLITTING_H

#include "ui_settings_stream_widget_splitting.h"

/** \brief Widget for the "splitting" options in the stream configuration
*          (for use with a KConfigDialog).
*
* It uses the UI that is generated with Qt-Designer.
*
* \sa settings_stream */
class settings_stream_widget_splitting
  : public QWidget, private Ui::settings_stream_widget_splitting
{
  Q_OBJECT

  public:
    settings_stream_widget_splitting(QWidget * parent=0);
    virtual ~settings_stream_widget_splitting();

  protected slots:
    /** This method corrects (if necessary) the search window,
    *   if the silence window has changed.
    *   (The search window must be \e always bigger
    *   than the silence window.)
    *
    *   @param silence_window the new value of the silence window
    *
    *   Normally this slot in connected to the signal
    *   <tt>valueChanged</tt> of the silence window. */
    void correct_search_window(int silence_window);
    /** This method corrects (if necessary) the silence window,
    *   if the search window has changed.
    *   (The search window must be \e always bigger
    *   than the silence window.)
    *
    *   @param search_window the new value of the search window
    *
    *   Normally this slot in connected to the signal
    *   <tt>valueChanged</tt> of the search window. */
    void correct_silence_window(int search_window);
};

#endif
