/*
    Copyright (C) 2008-2009  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "icecast.h"

icecast::icecast(QObject *parent, const QString & genreIconFileName)
  : streamDirectoryModel(parent, genreIconFileName)
{
  qRegisterMetaType<icecast_internalThread::streamEntryList>();
  connect(&m_thread,
          SIGNAL(streamlist_ready(icecast_internalThread::streamEntryList)),
          this,
          SLOT(use_data(icecast_internalThread::streamEntryList)));
  m_thread.start();
};

icecast::~icecast()
{
}

void icecast::use_data(icecast_internalThread::streamEntryList list)
{
  beginInsertRows(QModelIndex(), 0, list.count()-1);
  foreach (streamDirectoryEntry_stream *entry, list) {
    rootEntry->appendChild(entry);
  };
  endInsertRows();
  disconnect(this, SLOT(use_data(icecast_internalThread::streamEntryList)));
}
