/***************************************************************************
 *   Copyright (C) 2006 by Dusan Zatkovsky   *
 *   msk.conf@seznam.cz   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KRECORDMYDESKTOP_H_
#define _KRECORDMYDESKTOP_H_



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>
#include <ksystemtray.h>
#include <kprocess.h>
#include <qtimer.h>


#include <iostream>

#include "configDialog.h"
#include "configParameters.h"
#include "defines.h"






/*!
    Derived class from KSystemTray, maybe for later overloading of some functions ( mouse clicks etc... )
*/
/// System tray
class KRecordMyDesktopSystemTray : public KSystemTray {

};







/*!
    @short Application Main Window
    @author Dusan Zatkovsky <msk.conf@seznam.cz>
    @version 0.1
*/
class krecordmydesktop : public KMainWindow
{
    Q_OBJECT
public:

    /// Default Constructor
    krecordmydesktop();

    /// Default Destructor
    virtual ~krecordmydesktop();
    
    /// State typedef is used to tell, in what state application is.
    /*!
        Known states are defined in StateEnum.
    */
    typedef int State;
    
    /// State enum
    enum {
        undefined = -1,
        stopped,
        recording,
        countdown,
        encoding
        } StateEnum;
    
public slots:

    /// start recording slot
    void slotStartRecording ( void );
    
    /// start delayed recording
    void slotStartDelayedRecording ( void );
    
    /// stop recording slot
    void slotStopRecording ( void );
    
    /// quit app slot
    void slotQuitApp ( void );
    
    /// set preferences slot
    void slotSetPreferences ( void );
    
    /// end of encoding process slot
    void slotEncodingDone ( KProcess* p );
    
    /// recordmydesktop stdout output
    void slotRecordmydesktopStdout ( KProcess*, char*, int );
    
    /// delay timer slot
    void slotDelayTimer ( void );

private:

    /// cleanup method
    void cleanup ( void );

    /// temp output file name for recordmydesktop
    QString tempFileName;

    /// output file name selected by user
    QString outputFileName;

    /// configuration parameters
    configParameters cfg;

    /// system tray
    KRecordMyDesktopSystemTray* p_tray;

    /// recording process
    /*!
        This process will call a "real" recordmydesktop binary. If this pointer is not NULL, we are recording.
    */
    KProcess recordProcess;
    
    /// timer for delay start
    QTimer delayTimer;
    
    /// user selected delay
    /*!
        -1 = disabled
    */
    int delay;
    
    /// state flag
    /*!
        This flag is used to tell, in what state application is ( recording, encoding, etc... ).
    */
    State state;

};


/// invalid charracters removal function
inline QString replaceInvalidChars ( QString in ) {

    size_t is = in.length();
    for ( uint i = 0; i < is; i++ ) {
        if ( !in [ i ].isPrint() ) in [ i ] = '?';
    }
    return in;

}

#endif // _KRECORDMYDESKTOP_H_
