/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKAOFFICEADDRESS_H_
#define _KKAOFFICEADDRESS_H_

#include "kkaaddressdata.h"

namespace KKAddressBook
{
	/**
	 * @english
	 * AddressData for Office
	 *
	 * @author SUZUKI Tasuku
	 * @english
	 *
	 * @japanese
	 * 勤務先宛て住所クラス
	 * 会社名、所属部署、役職を含む
	 *
	 * @author 鈴木 佑
	 * @endjapanese
	 */
	class KKAOfficeAddress : public KKAAddressData
	{
		Q_OBJECT
	public:
		KKAOfficeAddress( QObject* parent );
		KKAOfficeAddress( QObject* parent
						, const QString& co
						, const QString& se
						, const QString& po
						, const QString& c
						, const QString& z
						, const QString& a
						);
		KKAOfficeAddress( QObject* parent, QDomElement& e );

		virtual ~KKAOfficeAddress();

		QDomElement toElement( QDomDocument& doc );

		const QString& corporation() const { return m_corporation; }
		const QString& section() const { return m_section; }
		const QString& post() const { return m_post; }

	public slots:
		void setCorporation( const QString& c );
		void setSection( const QString& s );
		void setPost( const QString& p );

	private:
		QString m_corporation;
		QString m_section;
		QString m_post;
	};
}

#endif /* _KKAOFFICEADDRESS_H_ */
