/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KKAWIDGET_H_
#define _KKAWIDGET_H_

#include "../kkwidgetbase.h"

class QListViewItem;
class KListView;
class QScrollView;

namespace KKDesigner
{
	class KKDDoc;
	class KKDView;
}

namespace KKAddressBook
{
	class KKAContactData;
	class KKATreeView;
	class KKAListView;
	class KKADetailView;

	class KKAWidget : public KKWidgetBase
	{
		Q_OBJECT
	public:
		KKAWidget( KKDesigner::KKDDoc* doc, KCommandHistory* cmdHistory, QWidget* parent = 0, const char* name = 0 );
		virtual ~KKAWidget();
		const char* xmlFile(){ return "kkaddressbookui.rc"; }
		bool closable();
		void readConfig( KConfig* conf );
		void saveConfig( KConfig* conf );

		QPtrList<KKAContactData> printData();
		
	public slots:
		void tabChanged( QWidget* wgt );

	private slots:
		void groupChanged( QListViewItem* g );
		void setContactData( QListViewItem* d );
		
		void importContactXML();
		void exportContactXML();
		
		void togglePreview();

	private:
		QSplitter* m_spl;
		QSplitter* m_hbox;
		KKATreeView* m_tvwGroup;
		KKAListView* m_lvwPerson;
		KKADetailView* m_dvwPerson;
		KKDesigner::KKDView* m_preview;
		KKDesigner::KKDDoc* m_doc;
		QListViewItem* m_data;
		QStringList m_strlActions;
	};
}

#endif /* _KKAWIDGET_H_ */
