/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDTEXTITEM_H_
#define _KKDTEXTITEM_H_

#include "kkdtextbase.h"

namespace KKAddressBook
{
	class KKAContactData;
}

namespace KKDesigner
{
	class KKDTextItem : public KKDTextBase
	{
		Q_OBJECT
		Q_PROPERTY( QString text READ text WRITE setText )
		Q_PROPERTY( AlignmentFlags align READ align WRITE setAlign )
	public:
		KKDTextItem( const QPoint& l
				   , const QSize& s
				   , const QFont& f
				   , const QColor& c
				   , Orientation o
				   , const QString& t
				   , AlignmentFlags a
				   , QObject* parent = 0
				   );
		KKDTextItem( QDomElement e, QObject* parent = 0 );
		KKDTextItem( const KKDTextItem* item, QObject* parent = 0 );
		~KKDTextItem();

		static const QString tagName(){ return QString( "Text" ); }
		QDomElement toElement( QDomDocument& doc, const QString& t = QString::null );

		//BEGIN Properties
		virtual ItemType type() const { return TextItem; }

		const QString& text() const { return m_text; }
		AlignmentFlags align() const { return m_align; }
		//END   Properties

	public slots:
		//BEGIN Properties
		void setText( const QString& t );
		void setAlign( AlignmentFlags a );
		//END   Properties

	signals:
		//BEGIN Properties
		void textChanged();
		void alignChanged();
		//END   Properties

	protected:
		virtual void drawItemBefore( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d );
		virtual void drawItemAfter( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d );

		virtual void refontsize();
		virtual void resize();

	private:
		QString m_text;
		AlignmentFlags m_align;
	};
}

#endif /* _KKDTEXTITEM_H_ */
