/***************************************************************************
                          batchrenamer.h  -  description
                             -------------------
    begin                : Sat Aug 18 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BATCHRENAMER_H
#define BATCHRENAMER_H

#include <qdatetime.h>
#include <qvaluelist.h>
#include <kurl.h>

class QFile;
class QProgressDialog;
class QString;

/* How many diferrent users and groups
 * KRename supports. Values over 1000
 * make KRename slow, but it may be
 * necessary on bigger systems to
 * increase this value.
 * MAXENTRIES must be < sizeof(int)
 */
#define MAXENTRIES 1000

/* May Value for SpinBoxes
 *
 */
#define SPINMAX 100000

enum {
    COPY, MOVE, RENAME, PREVIEW, LINK
};

typedef struct fileentry {
    QString name;       // filename
    QString directory;  // directory
    QString extension;  // extension

    KURL url;
};

typedef struct data {
    fileentry src;
    fileentry dst;

    bool dir;
};

/*
 * Changes made by hand by the user
 * in the preview list view are
 * stored here.
 */
typedef struct manualchanges {
    KURL url;  // input filename
    QString user;      // name the user wants
};

typedef struct replacestrings {
    QString find;      // Text to replace
    QString replace;   // Replace with
    bool reg;          // is it a reg expression ?
};

/**
  *@author Dominik Seichter
  */

class QObject;
class QListView;
class ProgressDialog;
class PluginLoader;
class BatchRenamer {
    public:
        BatchRenamer();
        ~BatchRenamer();
        void processFiles( ProgressDialog* p, QObject* object );
        void createPreview( QListView* list );

        void setText( const QString & t ) { text = doEscape( t, false ); }
        void setExText( const QString & t ) { extext = t; }
        void setDirname( const KURL & url ) { dirname = url; }
        void setUndoScript( const QString & t ) { m_undoScript = t; }
        void setUndo( bool b ) { undo = b; }
        void setOverwrite( bool b ) { overwrite = b; }
        void setIndex( int i ) { m_index = i; }
        void setStep( int s ) { m_step = s; }
        void setSkipList( const QValueList<int> s ) { m_skip = s; }
        void setReplaceList( const QValueList<replacestrings> r ) { m_replace = r; }
        
        void setFiles( const QValueList<data> f ) { m_files = f; } //TODO: use a pointer for more speed
        QValueList<data> files() const { return m_files; }
        void setChanges( const QValueList<manualchanges> m ) { m_changes = m; }

        void setMode( int m) { m_mode = m; }
        int mode() const { return m_mode; }

        // Since 2.1 public, because plugins may want to access them to:
        QString findAndProcess( QString token, QString text, QString replace );

        QString findNumbers( QString text, int count, int i );
        QString findParagraph( QString oldname, QString text );
        QString findStar( QString oldname, QString text );
        QString findBrackets( QString oldname, QString text, int i );
        QString findToken( QString oldname, QString token, int i );
        QString processToken( QString token, QString oldname, int i );
        QString findPartStrings( QString oldname, QString token );
        static QString findDirName( QString token, QString path );
        QString findLength( const QString & token, const QString & name );
        QString findReplace( QString text );  // text is here already the new filename !
        QString doReplace( QString text, QString find, QString replace, bool reg ); // text is here already the new filename !

        QString processString( QString text, QString oldname, int i );
        
        static QString doEscape( QString text, bool filename = true );
        static QString unEscape( QString text );
        static QString escape( QString text, QString token, QString sequence );

        static QString buildFilename( fileentry* entry, bool dir = true );

    private:
        int getCharacters( int n ) ;
        void work( ProgressDialog* p );
        void writeUndoScript( QTextStream* t );
        void parseSubdirs( data* f );
        void findNumberAppendix( QString & text, int pos, int* start, int* step );
        void findCounterReset( int i );
        QString parsePlugins( int i, QString text, int type );
        bool applyManualChanges( int i );

        QString text;           // template
        KURL dirname;           // destination dir
        QString extext;         // Extension template
        QString m_undoScript;     // Filename of undoscript
        bool undo;              // create an undo script
        int m_index;              // index for numbers
        int m_step;               // step for numbers
        bool overwrite;         // overwrite existing files
        int m_mode;             // renaming mode
        QValueList<int> m_skip; // Numbers to skip
        QValueList<replacestrings> m_replace; // Replace strings
        QValueList<data> m_files;
        QValueList<manualchanges> m_changes;  // User made changes
        PluginLoader* plug;

        // a is used in find number and
        // required for skipping.
        int m_counter_index;
        QValueList<int> m_skip_add;
        
    protected:
        QFile* f;
        QTime t;
        QProgressDialog* progress;
};

#endif
