/***************************************************************************
                     dsdirselectdialog.h  -  description
                             -------------------
    begin                : Sat Jan 03 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DSDIRSELECTDIALOG_H
#define DSDIRSELECTDIALOG_H

#include <kfiledialog.h>

class QCheckBox;
class QLabel;
class KComboBox;

/* A small helper class to allow layout changes in KDirSelectDialog */
class DSDirSelectDialog : public KFileDialog {
    Q_OBJECT

    public:
        DSDirSelectDialog( QWidget* parent );

        bool recursively() const;
        bool hidden() const;
        bool dirs() const;
        bool onlyDirs() const;
        void setRecursively( bool b );
        
        KURL::List selectedURLs();

    private slots:
        void enableControls();
        void slotOk();
        
    private:
        QCheckBox* check;
        QCheckBox* checkHidden;
        QCheckBox* checkDir;
        QCheckBox* checkOnlyDir;
        QLabel* label;
};

#endif
