<?php
$delurl = Kronolith::addParameter('delevent.php', 'eventID', $event->getID());
$delurl = Kronolith::addParameter($delurl,  'timestamp', $timestamp);
$delurl = Horde::applicationUrl($delurl);

$editurl = Kronolith::addParameter('editevent.php', 'eventID', $event->getID());
$editurl = Kronolith::addParameter($editurl, 'timestamp', $timestamp);
$editurl = Kronolith::addParameter($editurl, 'url', Horde::selfURL(true));
$editurl = Horde::applicationUrl($editurl);
?>
<table border="0" cellspacing="2" cellpadding="2" align="center">

<!-- header -->
<tr class="header">
 <td colspan="4"><table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
   <td align="left" colspan="2" class="header" nowrap="nowrap"><b><?php echo htmlspecialchars($event->getTitle()) ?></b>&nbsp;</td>
   <td align="right" colspan="2" class="smallheader">
    <?php echo Horde::link($delurl, sprintf(_("Delete '%s'"), $event->getTitle()), 'menuitem') . _("Delete") ?></a>
    | <?php echo Horde::link($editurl, sprintf(_("Edit '%s'"), $event->getTitle()), 'menuitem') . _("Edit") ?></a>
   </td>
  </tr>
 </table></td>
</tr>

<?php if (!empty($category)): ?>
<!-- category -->
<tr>
 <td align="right" class="light"><b><?php echo _("Category") ?>&nbsp;&nbsp;</b></td>
 <td align="left" class="text" colspan="3">
  <?php echo htmlspecialchars(Kronolith::formatCategory($event->getCategory())) ?>
 </td>
</tr>
<?php endif; ?>

<!-- location -->
<tr>
 <td align="right" class="light"><b><?php echo _("Location") ?>&nbsp;&nbsp;</b></td>
 <td align="left" class="text" colspan="3"><?php echo empty($location) ? '&nbsp;' : htmlspecialchars($location) ?> </td>
</tr>

<!-- start date -->
<tr>
 <td align="right" class="light"><b><?php echo _("Start On") ?>&nbsp;&nbsp;</b></td>
 <td align="left" class="text" colspan="3"><?php echo strftime($prefs->getValue('date_format'), $event->getStartTimestamp()) . date($prefs->getValue('twentyFour') ? ' G:i' : ' g:i a', $event->getStartTimestamp()) ?></td>
</tr>

<!-- end date -->
<tr>
 <td align="right" class="light"><b><?php echo _("End On") ?>&nbsp;&nbsp;</b></td>
 <td align="left" class="text" colspan="3"><?php echo strftime($prefs->getValue('date_format'), $event->getEndTimestamp()) . date($prefs->getValue('twentyFour') ? ' G:i' : ' g:i a', $event->getEndTimestamp()) ?></td>
</tr>

<!-- alarm -->
<tr>
 <td align="right" class="light"><b><?php echo _("Alarm") ?>&nbsp;&nbsp;</b></td>
 <td class="text" align="left" valign="top" colspan="3">
<?php
if ($event->isInitialized() && $event->alarm > 0):
    if ($event->alarm % 10080 == 0) {
        $alarm_value = $event->alarm / 10080;
        $alarm_unit = _("Week(s)");
    } elseif ($event->alarm % 1440 == 0) {
        $alarm_value = $event->alarm / 1440;
        $alarm_unit = _("Day(s)");
    } elseif ($event->alarm % 60 == 0) {
        $alarm_value = $event->alarm / 60;
        $alarm_unit = _("Hour(s)");
    } else {
        $alarm_value = $event->alarm;
        $alarm_unit = _("Minute(s)");
    }
?>
  <?php echo $alarm_value . ' ' . $alarm_unit ?>
<?php else: ?>
  <?php echo _("None") ?>
<?php endif; ?>
 </td>
</tr>

<?php if (!empty($description)): ?>
<!-- description -->
<tr>
 <td align="left" colspan="4" class="smallheader"><?php echo _("<b>Description</b>") ?>
</td>
</tr>
<tr>
 <td>&nbsp;</td>
 <td class="text" colspan="3" align="left"><?php echo nl2br(htmlspecialchars($description)) ?></td>
</tr>
<?php endif; ?>

<?php if (!$event->hasRecurType(KRONOLITH_RECUR_NONE)): ?>
<!-- recurrence -->
<tr>
 <td align="left" colspan="4" class="smallheader"><?php echo _("<b>Recurrence</b>") ?></td>
</tr>
<tr>
 <td class="light" align="right" valign="top"><b><?php echo _("Pattern") ?>&nbsp;&nbsp;</b></td>
 <td class="text" align="left" valign="top" colspan="3">
<?php if ($event->hasRecurType(KRONOLITH_RECUR_DAILY)): ?>
   <?php echo _("Daily: Recurs every") . ' ' . $event->getRecurInterval() . ' ' . _("day(s)") ?>
<?php
elseif ($event->hasRecurType(KRONOLITH_RECUR_WEEKLY)):
    $weekdays = array();
    if ($event->recurOnDay(KRONOLITH_MASK_MONDAY))    $weekdays[] = _("Monday");
    if ($event->recurOnDay(KRONOLITH_MASK_TUESDAY))   $weekdays[] = _("Tuesday");
    if ($event->recurOnDay(KRONOLITH_MASK_WEDNESDAY)) $weekdays[] = _("Wednesday");
    if ($event->recurOnDay(KRONOLITH_MASK_THURSDAY))  $weekdays[] = _("Thursday");
    if ($event->recurOnDay(KRONOLITH_MASK_FRIDAY))    $weekdays[] = _("Friday");
    if ($event->recurOnDay(KRONOLITH_MASK_SATURDAY))  $weekdays[] = _("Saturday");
    if ($event->recurOnDay(KRONOLITH_MASK_SUNDAY))    $weekdays[] = _("Sunday");
?>
   <?php echo _("Weekly: Recurs every") . ' ' . $event->getRecurInterval() . ' ' . _("week(s) on:") . ' ' . implode(', ', $weekdays) ?>
<?php elseif ($event->hasRecurType(KRONOLITH_RECUR_DAY_OF_MONTH)): ?>
   <?php echo _("Monthly: Recurs every") . ' ' . $event->getRecurInterval() . ' ' . _("month(s)") . ' ' . _("on the same date") ?>
<?php elseif ($event->hasRecurType(KRONOLITH_RECUR_WEEK_OF_MONTH)): ?>
   <?php echo _("Monthly: Recurs every") . ' ' . $event->getRecurInterval() . ' ' . _("month(s)") . ' ' . _("on the same weekday") ?>
<?php elseif ($event->hasRecurType(KRONOLITH_RECUR_YEARLY)): ?>
   <?php echo _("Yearly: Recurs every") . ' ' . $event->getRecurInterval() . ' ' . _("year(s)") ?>
<?php endif; ?>
 </td>
</tr>

<!-- recur end date -->
<tr>
 <td align="right" class="light"><b><?php echo _("Recur Until") ?>&nbsp;&nbsp;</b></td>
 <td align="left" class="text" colspan="3"><?php echo $event->hasRecurEnd() ? strftime($prefs->getValue('date_format'), $event->getRecurEndTimestamp()) . date($prefs->getValue('twentyFour') ? ' G:i' : ' g:i a', $event->getRecurEndTimestamp()) : _("No end date") ?></td>
</tr>
<?php endif; ?>

<?php if ($conf['metadata']['keywords']): ?>
<!-- keywords -->
<?php if (count($keyword_list)): ?>
<tr>
 <td colspan="4" class="smallheader" align="left"><?php echo _("<b>Keywords</b>") ?></td>
</tr>
<?php foreach ($keyword_list as $cat => $list): ?>
<tr>
 <td align="right" class="light" valign="top"><b><?php echo $cat ?>&nbsp;&nbsp;</b></td>
 <td align="left" class="text" colspan="3">
<?php foreach ($list as $entry): ?>
  <?php echo $entry ?><br />
<?php endforeach; ?>
 </td>
</tr>
<?php endforeach; ?>
<?php endif; ?>
<?php endif; ?>

<!-- buttons -->
<tr>
 <td align="right" colspan="4" class="smallheader">
    <?php echo Horde::link($delurl, sprintf(_("Delete '%s'"), $event->getTitle()), 'menuitem') . _("Delete") ?></a>
    | <?php echo Horde::link($editurl, sprintf(_("Edit '%s'"), $event->getTitle()), 'menuitem') . _("Edit") ?></a>
 </td>
</tr>

</table>
