<?php
/*
 * $Horde: kronolith/deleventaction.php,v 1.1.2.7 2005/01/03 11:25:57 jan Exp $
 *
 * Copyright 1999-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

if ($eventID = Horde::getFormData('eventID')) {
    $event = $calendar->getEventObject($eventID);
    if ($event->hasRecurType(KRONOLITH_RECUR_NONE) || Horde::getFormData('all')) {
        $calendar->deleteEvent($event->getID());
    } elseif (Horde::getFormData('future')) {
        $event->setRecurEndTimestamp(mktime(1, 1, 1,
                                            Horde::getFormData('month', date('n')),
                                            Horde::getFormData('mday', date('j')) - 1,
                                            Horde::getFormData('year', date('Y'))));
        $event->save();
    } elseif (Horde::getFormData('current')) {
        $event->addException(Horde::getFormData('year'),
                             Horde::getFormData('month'),
                             Horde::getFormData('mday'));
        $event->save();
    }
}

if ($timestamp = Horde::getFormData('timestamp')) {
    $month = date('n', $timestamp);
    $day = date('j', $timestamp);
    $year = date('Y', $timestamp);
} else {
    $month = Horde::getFormData('month', date('n'));
    $day = Horde::getFormData('mday', date('j'));
    $year = Horde::getFormData('year', date('Y'));
}

if ($url = Horde::getFormData('url')) {
    $location = $url;
} else {
    $url = Kronolith::addParameter($prefs->getValue('defaultview') . '.php', 'month=' . $month);
    $url = Kronolith::addParameter($url, 'year=' . $year);
    $url = Kronolith::addParameter($url, 'mday=' . $mday);
    $location = Horde::applicationUrl($url, true);
}

$location = Kronolith::addParameter($location, 'unique=' . md5(microtime()));

header('Location: ' . $location);
