<?php
/**
 * $Horde: kronolith/fb.php,v 1.25.10.2 2005/03/22 09:52:02 jan Exp $
 *
 * Copyright 1999-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('AUTH_HANDLER', true);
@define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once 'Horde/Cache.php';

// Determine the username to show free/busy time for.
$cal = Util::getFormData('c');
if (!empty($cal)) {
    if (is_array($cal)) {
        $cal = implode('|', $cal);
    }
} elseif (!empty($_SERVER['PATH_INFO'])) {
    $cal = basename($_SERVER['PATH_INFO']);
}

$cache = &Horde_Cache::singleton($conf['cache']['driver'], Horde::getDriverConfig('cache', $conf['cache']['driver']));
$key = 'kronolith.fb.' . Auth::getAuth() . '.' . $cal;

$fb = $cache->get($key, 360);
if (!$fb) {
    $fb = Kronolith::generateFreeBusy(explode('|', $cal));
    if (is_a($fb, 'PEAR_Error')) {
        Horde::logMessage($fb, __FILE__, __LINE__, PEAR_LOG_ERR);
        exit;
    }
    $cache->set($key, $fb);
}

$browser->downloadHeaders($cal . '.vfb', 'text/calendar', true, strlen($fb));
echo $fb;
