--TEST--
Import of all-day events
--FILE--
<?php

class Driver {
    function getCalendar()
    {
        return 'foo';
    }
}
class Prefs {
    function getValue()
    {
        return 0;
    }
}
$prefs = new Prefs;

require 'Date/Calc.php';
require 'Horde/Date.php';
require 'Horde/Util.php';
require 'Horde/iCalendar.php';

$iCal = new Horde_iCalendar();
$iCal->parsevCalendar(file_get_contents(dirname(__FILE__) . '/allday.ics'));
$components = $iCal->getComponents();

define('KRONOLITH_BASE', dirname(__FILE__) . '/../..');
require KRONOLITH_BASE . '/lib/Kronolith.php';
require KRONOLITH_BASE . '/lib/Driver.php';
foreach ($components as $content) {
    if (is_a($content, 'Horde_iCalendar_vevent')) {
        $event = new Kronolith_Event(new Driver);
        $event->fromiCalendar($content);
        var_dump($event->start, $event->end, $event->isAllDay());
    }
}

?>
--EXPECT--
object(horde_date)(7) {
  ["year"]=>
  int(2006)
  ["month"]=>
  int(10)
  ["mday"]=>
  int(23)
  ["hour"]=>
  int(0)
  ["min"]=>
  int(0)
  ["sec"]=>
  int(0)
  ["_supportedSpecs"]=>
  string(21) "%CdDeHImMnRStTyYbBpxX"
}
object(horde_date)(7) {
  ["year"]=>
  int(2006)
  ["month"]=>
  int(10)
  ["mday"]=>
  int(24)
  ["hour"]=>
  int(0)
  ["min"]=>
  int(0)
  ["sec"]=>
  int(0)
  ["_supportedSpecs"]=>
  string(21) "%CdDeHImMnRStTyYbBpxX"
}
bool(true)
object(horde_date)(7) {
  ["year"]=>
  int(2006)
  ["month"]=>
  int(10)
  ["mday"]=>
  int(23)
  ["hour"]=>
  int(0)
  ["min"]=>
  int(0)
  ["sec"]=>
  int(0)
  ["_supportedSpecs"]=>
  string(21) "%CdDeHImMnRStTyYbBpxX"
}
object(horde_date)(7) {
  ["year"]=>
  int(2006)
  ["month"]=>
  int(10)
  ["mday"]=>
  int(24)
  ["hour"]=>
  int(0)
  ["min"]=>
  int(0)
  ["sec"]=>
  int(0)
  ["_supportedSpecs"]=>
  string(21) "%CdDeHImMnRStTyYbBpxX"
}
bool(true)
object(horde_date)(7) {
  ["year"]=>
  int(2006)
  ["month"]=>
  int(10)
  ["mday"]=>
  int(23)
  ["hour"]=>
  int(12)
  ["min"]=>
  int(0)
  ["sec"]=>
  int(0)
  ["_supportedSpecs"]=>
  string(21) "%CdDeHImMnRStTyYbBpxX"
}
object(horde_date)(7) {
  ["year"]=>
  int(2006)
  ["month"]=>
  int(10)
  ["mday"]=>
  int(23)
  ["hour"]=>
  int(13)
  ["min"]=>
  int(0)
  ["sec"]=>
  int(0)
  ["_supportedSpecs"]=>
  string(21) "%CdDeHImMnRStTyYbBpxX"
}
bool(false)
