/***************************************************************************
                             calltreemanager.h
                             -------------------
    begin                : Mon Jan 17 2005
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CALLTREEMANAGER_H
#define CALLTREEMANAGER_H

#include <qwidget.h>
#include <qlist.h>

class CallTreeDlg;

/**
 * Manages all call tree dialogs within the project.
 * Responsible for saving/loading of the call tree dialogs.
 * @author Albert Yosher
 */
class CallTreeManager : public QObject
{
   Q_OBJECT
   
public: 
	CallTreeManager(QWidget*);
	~CallTreeManager();
	
	void saveOpenDialogs(const QString&, QStringList&);
	void loadOpenDialogs(const QString&, QStringList&);
	CallTreeDlg* addDialog(const QString&);
	void closeAll();
	
signals:
	void lineRequested(const QString&, uint);
	 
private:
	/** The list of call tree dialogs */
	QList<CallTreeDlg> m_pCallTreeList;
	
private slots:
	/** Removes a Call Tree dialogue from the list of open Call Trees */
	void slotRemoveDialog(const CallTreeDlg* pTree) 
		{ m_pCallTreeList.remove(pTree); }
};

#endif
