/***************************************************************************
                          kscopepixmaps.h  -  description
                             -------------------
    begin                : Sat Jul 19 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSCOPEPIXMAPS_H
#define KSCOPEPIXMAPS_H

#include <qpixmap.h>
#include <kiconloader.h>

/**
 * Handles all pixmaps required by KScope.
 * There are two types of pixmaps: embedded, i.e., pixmaps whose pixels are
 * given by static two-dimensional arrays, and loadable, which are retrieved
 * through the KIconLoader mechanism.
 * The application uses a single global instance of this class.
 * @author Elad Lahav
 */

class KScopePixmaps
{
public: 
	KScopePixmaps();
	~KScopePixmaps();

	/** Identifiers for embedded pixmaps. */
	enum PixName { SymFunc, SymVar, SymStruct, SymMacro, SymMember, SymEnum,
		SymEnumerator, SymTypedef, SymUnknown, SortByNameAsc,
		SortByNameDes, SortByLineAsc, SortByLineDes, PIX_ARRAY_SIZE };
		
	/** Identifiers for loadable pixmaps. */
	enum LoadPixName { ToolbarReload, GoBack, GoForward, ButtonNewQuery,
		ButtonLockQuery, ButtonUnlockQuery, ButtonRefreshQuery, 
		ButtonCloseQuery, TabUnlocked, TabLocked, TabRW, TabRO, TabSave,
		TabFileList, TabFileTree, TabList };
	
	void init();
	const QPixmap& getPixmap(PixName name) const;
	QPixmap getPixmap(LoadPixName name);
	
private:
	/** An array of pointers to the embedded pixmaps. */
	QPixmap** m_pPixArray;
	
	/** An icon loader used to retrieve pixmaps through the KDE mechanism. */
	KIconLoader m_loader;
};

extern KScopePixmaps& Pixmaps();

#endif
