/***************************************************************************
                          newprojectdlg.h  -  description
                             -------------------
    begin                : Mon Jun 9 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NEWPROJECTDLG_H
#define NEWPROJECTDLG_H

#include <qlineedit.h>
#include <qcheckbox.h>
#include <newprojectlayout.h>
#include <autocompletionlayout.h>
#include "projectmanager.h"
	
/**
 * A sub-dialogue of the New Project dialogue.
 * Allows the user to configure auto-completion parameters.
 * @author Elad Lahav
 */
class AutoCompletionDlg : public AutoCompletionLayout
{
	Q_OBJECT
	
public:
	AutoCompletionDlg(QWidget* pParent, const char* szName = NULL);
	~AutoCompletionDlg();

public slots:		
	int exec();
	
protected slots:
	virtual void accept();

private:
	uint m_nMinChars;
	uint m_nDelay;
	uint m_nMaxEntries;

	friend class NewProjectDlg;
};

/**
 * A dialog for creating new projects.
 * Prompts the user for the project's name, the directory for Cscope's files,
 * the types of files included in the project and several options.
 * Can also be used to change some of the properties of a project after it
 * has been created.
 * @author Elad Lahav
 */

class NewProjectDlg : public NewProjectLayout
{
	Q_OBJECT
	
public: 
	NewProjectDlg(bool, QWidget* pParent = NULL, const char* szName = NULL);
	~NewProjectDlg();
	
	void setProperties(const QString&, const QString&, 
		const ProjectManager::Options&);

	QString getName();
	QString getPath();
	void getOptions(ProjectManager::Options&);
	
protected slots:
	virtual void accept();

private:
	/** The file MIME-types associated with the new project. */
	QStringList m_slTypes;
	
	AutoCompletionDlg* m_pAutoCompDlg;
	
private slots:
	void slotFindProject();
	void slotAddType();
	void slotRemoveType();
	void slotAutoRebuildChanged(bool);
	void slotAutoCompletionChanged(bool);
};

#endif
