/***************************************************************************
                          preferencesdlg.h  -  description
                             -------------------
    begin                : Fri Jun 13 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PREFERENCESDLG_H
#define PREFERENCESDLG_H

#include <qwidget.h>
#include <kdialogbase.h>

class PrefFrontend;
class PrefColor;
class PrefFont;
class PrefOpt;

/**
 * The main configuration dialog for KScope.
 * This dialog displays a set of configuration pages, each dedicated to a
 * different subject (frontend programme paths, colours, etc.)
 * This code is based on a tutorial by Andreas Nicolai which can be found at
 * http://www.kdevelop.org/doc/tutorial_settings
 * @author Elad Lahav
 */

class PreferencesDlg : public KDialogBase
{
   Q_OBJECT

public: 
	PreferencesDlg(QWidget* pParent = 0, const char* szName = 0,
		WFlags f = 0);
	~PreferencesDlg();

signals:
	/**
	 * Emitted when the global configuration changes as a result of using
	 * this dialogue.
	 */
	void applyPref();

protected slots:
	virtual void accept();
	virtual void slotApply();
	virtual void slotDefault();
	
private:
	/** The front-end programmes page. */
	PrefFrontend* m_pPrefFrontend;
	
	/** The colours preference page. */
	PrefColor* m_pPrefColor;
	
	/** The fonts preference page. */
	PrefFont* m_pPrefFont;
	
	/** The additional options page. */
	PrefOpt* m_pPrefOpt;
	
	void loadConfig();
	bool updateConfig();
	bool verifyPaths();

private slots:
	void slotModified();
};

#endif
