/***************************************************************************
                          preffont.h  -  description
                             -------------------
    begin                : Fri Jul 16 2004
    copyright            : (C) 2004 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kfontrequester.h>
#include "preffont.h"
#include "kscopeconfig.h"

/**
 * Class constructor.
 * @param	pParent	The parent widget
 * @param	szName	The widget's name
 */
PrefFont::PrefFont(QWidget* pParent, const char* szName)
	: PrefFontLayout(pParent, szName)
{
	// Set initial values
	load();
		
	// Emit the "modified" signal whenever any of the font selectors changes
	// its value. This will notify the parent dialogue to enable its "Apply"
	// button
	connect(m_pFontReqFileList, SIGNAL(fontSelected(const QFont&)),
		this, SIGNAL(modified()));
	connect(m_pFontReqTagList, SIGNAL(fontSelected(const QFont&)),
		this, SIGNAL(modified()));
	connect(m_pFontReqQueryList, SIGNAL(fontSelected(const QFont&)),
		this, SIGNAL(modified()));
}

/**
 * Class destructor.
 */
PrefFont::~PrefFont()
{
}

/**
 * Reads the current settings from the configuration object, and applies them
 * the the page's widget.
 */
void PrefFont::load()
{
	m_pFontReqFileList->setFont(Config().getFont(KScopeConfig::FileList));
	m_pFontReqTagList->setFont(Config().getFont(KScopeConfig::TagList));
	m_pFontReqQueryList->setFont(Config().getFont(KScopeConfig::QueryList));
}

/**
 * Commits settings changes to the configuration object.
 */
void PrefFont::apply()
{
	Config().setFont(KScopeConfig::FileList, m_pFontReqFileList->font());
	Config().setFont(KScopeConfig::TagList, m_pFontReqTagList->font());
	Config().setFont(KScopeConfig::QueryList, m_pFontReqQueryList->font());
}
