/***************************************************************************
                          progressdlg.cpp  -  description
                             -------------------
    begin                : Thu Jul 24 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "progressdlg.h"

/**
 * Class constructor.
 * @param	pParent	The parent widget
 * @param	szName	The widget's name
 */
ProgressDlg::ProgressDlg(QWidget* pParent, const char* szName) :
	KProgressDialog(pParent, szName),
	m_nIdleValue(-1)
{
	// Create the idle-progress timer
	m_pIdleTimer = new QTimer(this);

	// Display a busy indicator by increasing the value of the idle counter
	connect (m_pIdleTimer, SIGNAL(timeout()), this, SLOT(slotShowBusy()));
}

/**
 * Class destructor.
 */
ProgressDlg::~ProgressDlg()
{
}

/**
 * Sets a new value to the progress bar.
 * If the new value is non-zero, the progress bar is advanced. Otherwise, the
 * idle timer is initiated to display a busy indicator.
 * @param	nValue	The new value to set.
 */
void ProgressDlg::setValue(int nValue)
{
	KProgress* pProgress;

	pProgress = progressBar();
	
	if (nValue != 0) {
		// Do nothing if the value hasn't changed
		if (nValue == pProgress->progress())
			return;

		// Handle first non-zero value
		if (m_nIdleValue >= 0) {
			m_pIdleTimer->stop();
			m_nIdleValue = -1;
			pProgress->setPercentageVisible(true);
		}

		// Set the new value
		pProgress->setValue(nValue);
	}
	else if (m_nIdleValue == -1) {
		// Handle first 0 value
		pProgress->setValue(0);
		pProgress->setPercentageVisible(false);
		m_nIdleValue = 0;
		m_pIdleTimer->start(200);
	}
}

/**
 * Increaes the value of the dummy counter by 1.
 * This slot is called by the timeout() event of the idle timer.
 */
void ProgressDlg::slotShowBusy()
{
	// Increase the counter
	m_nIdleValue += 5;
	if (m_nIdleValue == 100)
		m_nIdleValue = 0;
		
	// Set the value of the progress-bar
	progressBar()->setValue(m_nIdleValue);
}
