/***************************************************************************
                          searchlist.h  -  description
                             -------------------
    begin                : Mon May 19 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SEARCHLIST_H
#define SEARCHLIST_H

#include <qwidget.h>
#include <qvbox.h>
#include <qlineedit.h>
#include <qlistview.h>

/**
 * Defines a line text edit for searchable list view.
 * The widget is based on QLineEdit with additional key functions
 * Supported key events (up and down) are emitted as signals
 * @author Albert Yosher
 */

class SearchLineEdit : public QLineEdit
{
   Q_OBJECT
public:
	SearchLineEdit(QWidget* pParent) : QLineEdit(pParent) {};
	~SearchLineEdit() {};
signals:
	void keyPressed(QKeyEvent* e);
private:
	virtual void keyPressEvent(QKeyEvent*);
};

/**
 * Defines a searchable list view.
 * The widget is composed of a list view, and an edit box used to enter
 * search data. Whenever the text in the edit box changes, the list view is
 * set to point to the first item that matches the new text.
 * @author Elad Lahav
 */

class SearchList : public QVBox
{
   Q_OBJECT

public: 
	SearchList(int nSearchCol, QWidget* pParent = 0, const char* szName = 0);
	~SearchList();

	/**
	 * @return	A pointer to the list part of the widget.
	 */
	QListView* getList() { return m_pList; }

protected:
	/** The search edit-box. */
	QLineEdit* m_pEdit;
	
	/** The list part of the widget. */
	QListView* m_pList;

	/**
	 * Called whenever the user selects an item in the list by either double-
	 * clicking it, or by highlighting the item and pressing the ENTER key.
	 * @param	pItem	The selected list item
	 */
	virtual void processItemSelected(QListViewItem* pItem) = 0;
	
protected slots:
	void slotFindItem(const QString&);
	void slotItemSelected(QListViewItem*);
	void slotItemSelected();
	void slotKeyPressed(QKeyEvent*);
	
private:
	/** Specifies the search column, i.e., the list column whose strings are
		compared with the text in the search edit-box. */
	int m_nSearchCol;
};

#endif
