/***************************************************************************
                             shellfrontend.h
                             -------------------
    begin                : Wed Feb 2 2005
    copyright            : (C) 2005 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SHELLFRONTEND_H
#define SHELLFRONTEND_H

#include <frontend.h>

/**
 * Provides a front-end to shell commands and scripts.
 * This class assumes that the result of the command or script is a single
 * output line.
 * WARNING! This process is executed in blocking mode, so make sure the
 * commands issued using this class terminate quickly.
 * @author Elad Lahav
 */
class ShellFrontend : public Frontend
{
	Q_OBJECT
	
public:
    ShellFrontend();
    ~ShellFrontend();

	const QString& run(const QString&, const QString& sWorkDir = "");
	
protected:
	virtual ParseResult parseStdout(QString&, ParserDelim);
	
private:
	/** Stores the first line of output generated by the shell command. */
	QString m_sResult;
};

#endif
