/***************************************************************************
                             tabwidget.cpp
                             -------------------
    begin                : Tue Feb 1 2005
    copyright            : (C) 2005 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtooltip.h>
#include <klocale.h>
#include "tabwidget.h"
#include "kscopepixmaps.h"

/**
 * Class constructor.
 * @param	pParent	A pointer to the parent widget
 * @param	szName	Optional widget name
 */
TabWidget::TabWidget(QWidget* pParent, const char* szName) :
	KTabWidget(pParent, szName),
	m_pMenu(NULL)
{
	// Create a button at the top-right corner of the tab widget
	m_pButton = new QToolButton(this);
	m_pButton->setIconSet(Pixmaps().getPixmap(KScopePixmaps::TabList));
	QToolTip::add(m_pButton, i18n("Shows a popup-menu with list of all open"
		" tabs"));
	m_pButton->adjustSize();
	setCornerWidget(m_pButton, TopRight);
	
	// Show the popup-menu when the button is clicked
	connect(m_pButton, SIGNAL(clicked()), this, SLOT(slotShowTabList()));
}

/**
 * Class destructor.
 */
TabWidget::~TabWidget()
{
}

/**
 * Creates and displays a popup-menu containing all tab labels.
 * This slot is connected to the clicked() signal emitted by the list button.
 */
void TabWidget::slotShowTabList()
{
	int i, nId;
	
	// Delete the previous menu
	delete m_pMenu;
	m_mapMenuId.clear();

	// Create and populate the menu	
	m_pMenu = new QPopupMenu(this);
	for (i = 0; i < count(); i++) {
		nId = m_pMenu->insertItem(label(i));
		m_mapMenuId[nId] = i;
	}
	
	// Set the current tab based on the menu selection
	connect(m_pMenu, SIGNAL(activated(int)), this, SLOT(slotShowTab(int)));
		
	// Show the menu
	m_pMenu->popup(mapToGlobal(m_pButton->pos()));
}

/**
 * Sets the current tab based on the user's menu selection.
 * This slot is connected to the activated() signal of the popup-menu.
 */
void TabWidget::slotShowTab(int nMenuId)
{
	setCurrentPage(m_mapMenuId[nMenuId]);
}

#include "tabwidget.moc"
