/***************************************************************************
                          aboutview.h  -  description
                             -------------------
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ABOUTVIEW_H
#define ABOUTVIEW_H

#include <config.h>

#include <qstring.h>

#include <kaboutdata.h>

#include "ksetispyview.h"

static KAboutData aboutData("ksetispy",
                            I18N_NOOP("KSetiSpy"),
                            VERSION,
                            I18N_NOOP("A monitor utility for SETI@home."),
                            KAboutData::License_GPL,
                            "Copyright 2001-2004 Roberto A. Virga",
                            0,
                            "http://ksetispy.sf.net",
                            "rvirga@users.sourceforge.net");

class AboutView : public KSetiSpyView {
  Q_OBJECT
  public:
    AboutView(QWidget *parent=0, const char *name=0);
    ~AboutView();
  private slots:
    virtual void handleURL(const QString& url);
    virtual void handleMailTo(const QString& url);
    virtual void handleHelpButton();
};

#endif
