/***************************************************************************
                          cachesetupdialog.cpp  -  description
                             -------------------
    begin                : Sun Jan 27 2002
    copyright            : (C) 2002 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qgrid.h>
#include <qgroupbox.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qvalidator.h>

#include <kfiledialog.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kurlrequester.h>
#include <kdeversion.h>

#if KDE_IS_VERSION(3,2,0)
#include <kcalendarsystem.h>
#endif

#include "intervalselectorwidget.h"

#include "cachesetupdialog.h"

CacheSetupDialog::CacheSetupDialog(CacheManager *manager, QWidget *parent, const char *name)
                 :KDialog(parent, name, true), manager(manager)
{
  setCaption(i18n("Cache Management Setup"));
  setMaximumSize(0, 0);

  QGridLayout *layout = new QGridLayout(this, 3, 2, 8, 8);
  layout->setColStretch(0, 1);

  QGroupBox *group;

  {
    group = new QGroupBox(1, Horizontal, i18n("Main Settings"), this);
    layout->addWidget(group, 0, 0);

    QHBox *hbox;
    KURLRequester *requester;
    KURL url;

    hbox = new QHBox(group);
    hbox->setSpacing(8);

    new QLabel(i18n("Location:"), hbox);

    requester = new KURLRequester(hbox, "CacheSetupDialog::cache_url");
    requester->fileDialog()->setMode(static_cast<KFile::Mode>(KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly));
    requester->setURL(manager->getBaseURL().prettyURL(+1, KURL::StripFileProtocol));

    hbox = new QHBox(group);
    hbox->setSpacing(8);

    new QLabel(i18n("Client:"), hbox);

    requester = new KURLRequester(hbox, "CacheSetupDialog::client");
    requester->fileDialog()->setMode(static_cast<KFile::Mode>(KFile::File | KFile::ExistingOnly | KFile::LocalOnly));
    requester->setURL(manager->getClientURL().prettyURL(-1, KURL::StripFileProtocol));

    hbox = new QHBox(group);
    hbox->setSpacing(8);

    new QLabel(i18n("User e-mail:"), hbox);
    new QLineEdit(manager->getEMail(), hbox, "CacheSetupDialog::email");

    hbox = new QHBox(group);
    hbox->setSpacing(8);

    new QLabel(i18n("Store a maximum of"), hbox);
    QSpinBox *spin = new QSpinBox(0, 99, 1, hbox, "CacheSetupDialog::capacity");
    spin->setValue(manager->getCapacity());
    hbox->setStretchFactor(new QLabel(i18n("work units"), hbox), 1);
  }

  {
    group = new QGroupBox(1, Horizontal, i18n("Proxy server"), this);
    layout->addWidget(group, 0, 1);

    QButtonGroup *proxyGroup = new QButtonGroup(group);
    proxyGroup->hide();

    QHBox *hbox;
    QRadioButton *radio;
    QLineEdit *edit;

    hbox = new QHBox(group);
    hbox->setSpacing(8);

    radio = new QRadioButton(i18n("&No proxy"), hbox, "CacheSetupDialog::no_proxy");
    proxyGroup->insert(radio, 0);

    radio = new QRadioButton(i18n("&Proxy"), hbox, "CacheSetupDialog::proxy");
    proxyGroup->insert(radio, 1);

    radio = new QRadioButton(i18n("&SOCKS"), hbox, "CacheSetupDialog::SOCKS");
    proxyGroup->insert(radio, 2);
    hbox->setStretchFactor(radio, 1);

    proxyGroup->setButton(int(manager->getProxyType()));
    connect(proxyGroup, SIGNAL(clicked(int)), this, SLOT(handleProxyType(int)));

    hbox = new QHBox(group);
    hbox->setSpacing(8);

    new QLabel(i18n("Host:"), hbox);
    edit = new QLineEdit(hbox, "CacheSetupDialog::proxy_host");
    edit->setEnabled(manager->getProxyType() > CacheManager::None);
    if(manager->getProxyType() > CacheManager::None)
      edit->setText(manager->getProxyHost());

    new QLabel(i18n("Port:"), hbox);
    edit = new QLineEdit(hbox, "CacheSetupDialog::proxy_port");
    edit->setEnabled(manager->getProxyType() > CacheManager::None);
    edit->setMaxLength(5);
    edit->setValidator(new QIntValidator(0, 65535, this));
    edit->setFixedWidth(this->fontMetrics().maxWidth() * 6);
    if(manager->getProxyType() > CacheManager::None)
      edit->setText(QString::number(manager->getProxyPort()));

    QGrid *grid = new QGrid(2, QGrid::Horizontal, group);
    grid->setSpacing(8);

    new QLabel(i18n("Login:"), grid);
    edit = new QLineEdit(grid, "CacheSetupDialog::proxy_login");
    edit->setEnabled(manager->getProxyType() == CacheManager::SOCKS);
    if(manager->getProxyType() == CacheManager::SOCKS)
      edit->setText(manager->getProxyLogin());
    connect(radio, SIGNAL(toggled(bool)), edit, SLOT(setEnabled(bool)));

    new QLabel(i18n("Password:"), grid);
    edit = new QLineEdit(grid, "CacheSetupDialog::proxy_password");
    edit->setEnabled(manager->getProxyType() == CacheManager::SOCKS);
    edit->setEchoMode(QLineEdit::Password);
    if(manager->getProxyType() == CacheManager::SOCKS)
      edit->setText(manager->getProxyPassword());
    connect(radio, SIGNAL(toggled(bool)), edit, SLOT(setEnabled(bool)));
  }

  {
    group = new QGroupBox(1, Horizontal, i18n("Schedule"), this);
    layout->addMultiCellWidget(group, 1, 1, 0, 1);

    const QPixmap cloneDownPixmap = KIconLoader().loadIcon("2downarrow", KIcon::Small);
    const KLocale *locale = KGlobal::locale();
    int day = locale->weekStartDay() ? 1 : 7;

    QButtonGroup *copyGroup = new QButtonGroup(this, "CacheSetupDialog::copy_buttons");
    connect(copyGroup, SIGNAL(clicked(int)), this, SLOT(handleCopyButton(int)));
    copyGroup->hide();

    QGrid *grid = new QGrid(3, group);
    grid->setSpacing(8);

    KPushButton *button;
    IntervalSelectorWidget *selector;
    QString id;

    for(int i = 0; i < 7; i++) {

      #if KDE_IS_VERSION(3,2,0)
      const QString dayName = locale->calendar()->weekDayName(day);
      #else
      const QString dayName = locale->weekDayName(day);
      #endif
      new QLabel(i18n("%1:").arg(dayName), grid);

      id = QString("CacheSetupDialog::schedule_%1").arg(day % 7);
      selector = new IntervalSelectorWidget(grid, id);
      selector->setSchedule(manager->getSchedule(day % 7));

      button = new KPushButton(grid);
      button->setPixmap(cloneDownPixmap);
      copyGroup->insert(button, day % 7);

      day = day % 7 + 1;
    }

    group->addSpace(8);

    QHBox *hbox = new QHBox(group);
    hbox->setSpacing(8);

    const bool threshold = manager->getThreshold() >= 5;

    QCheckBox *check = new QCheckBox(i18n("&Download new work units only when the cache is at least"),
                                       hbox, "CacheSetupDialog::use_threshold");
    check->setChecked(threshold);

    QSpinBox *spin = new QSpinBox(5, 100, 5, hbox, "CacheSetupDialog::threshold");
    if(threshold) spin->setValue((manager->getThreshold() / 5) * 5);
    connect(check, SIGNAL(toggled(bool)), spin, SLOT(setEnabled(bool)));
    spin->setEnabled(threshold);

    hbox->setStretchFactor(new QLabel(i18n("% empty"), hbox), 1);
  }

  {
    QBoxLayout *hbox = new QHBoxLayout();
    layout->addMultiCellLayout(hbox, 2, 2, 0, 1);
    hbox->setSpacing(8);

    hbox->addStretch(1);

    KPushButton *okButton = new KPushButton(i18n("&OK"), this, "CacheSetupDialog::OK");
    hbox->addWidget(okButton);

    okButton->setDefault(true);

    KPushButton *cancelButton = new KPushButton(i18n("&Cancel"), this, "CacheSetupDialog::cancel");
    hbox->addWidget(cancelButton);

    connect(okButton, SIGNAL(clicked()), this, SLOT(accept()));
    connect(cancelButton, SIGNAL(clicked()), this, SLOT(reject()));
  }
}

CacheSetupDialog::~CacheSetupDialog()
{
}

void CacheSetupDialog::accept()
{
  KURLRequester *requester;
  QLineEdit *edit;
  QCheckBox *check;
  QRadioButton *radio;
  QSpinBox *spin;

  requester = (KURLRequester *) child("CacheSetupDialog::cache_url", "KURLRequester");
  manager->setBaseURL(requester->url());

  requester = (KURLRequester *) child("CacheSetupDialog::client", "KURLRequester");
  manager->setClientURL(requester->url());

  edit = (QLineEdit *) child("CacheSetupDialog::email", "QLineEdit");
  manager->setEMail(edit->text().stripWhiteSpace());

  spin = (QSpinBox *) child("CacheSetupDialog::capacity", "QSpinBox");
  manager->setCapacity(spin->value());

  CacheManager::ProxyType type = CacheManager::None;

  radio = (QRadioButton *) child("CacheSetupDialog::SOCKS", "QRadioButton");
  if(radio->isChecked()) {
    type = CacheManager::SOCKS;
    edit = (QLineEdit *) child("CacheSetupDialog::proxy_host", "QLineEdit");
    manager->setProxyHost(edit->text().stripWhiteSpace());
    edit = (QLineEdit *) child("CacheSetupDialog::proxy_port", "QLineEdit");
    manager->setProxyPort(edit->text().toInt());
    edit = (QLineEdit *) child("CacheSetupDialog::proxy_login", "QLineEdit");
    manager->setProxyLogin(edit->text().stripWhiteSpace());
    edit = (QLineEdit *) child("CacheSetupDialog::proxy_password", "QLineEdit");
    manager->setProxyPassword(edit->text());
  };
  radio = (QRadioButton *) child("CacheSetupDialog::proxy", "QRadioButton");
  if(radio->isChecked()) {
    type = CacheManager::Proxy;
    edit = (QLineEdit *) child("CacheSetupDialog::proxy_host", "QLineEdit");
    manager->setProxyHost(edit->text().stripWhiteSpace());
    edit = (QLineEdit *) child("CacheSetupDialog::proxy_port", "QLineEdit");
    manager->setProxyPort(edit->text().toInt());
  }
  manager->setProxyType(type);

  IntervalSelectorWidget *selector;
  QString id;

  for(uint i = 0; i < 7; i++) {
    id = QString("CacheSetupDialog::schedule_%1").arg(i);
    selector = (IntervalSelectorWidget *) child(id, "IntervalSelectorWidget");
    manager->setSchedule(i, selector->getSchedule());
  }

  check = (QCheckBox *) child("CacheSetupDialog::use_threshold", "QCheckBox");
  if(check->isChecked()) {
    spin = (QSpinBox *) child("CacheSetupDialog::threshold", "QSpinBox");
    manager->setThreshold(spin->value());
  } else
    manager->setThreshold(0);

  KDialog::accept();
}

void CacheSetupDialog::handleProxyType(int i)
{
  QLineEdit *edit;

  edit = (QLineEdit *) child("CacheSetupDialog::proxy_host", "QLineEdit");
  edit->setEnabled(i != 0);

  edit = (QLineEdit *) child("CacheSetupDialog::proxy_port", "QLineEdit");
  edit->setEnabled(i != 0);
}
                                                           
void CacheSetupDialog::handleCopyButton(int i)
{
  QString id;

  id = QString("CacheSetupDialog::schedule_%1").arg((i+6) % 7);
  IntervalSelectorWidget *src = (IntervalSelectorWidget *) child(id, "IntervalSelectorWidget");

  id = QString("CacheSetupDialog::schedule_%1").arg(i);
  IntervalSelectorWidget *dest = (IntervalSelectorWidget *) child(id, "IntervalSelectorWidget");

  dest->setSchedule(src->getSchedule());
}

#include "cachesetupdialog.moc"

