/***************************************************************************
                          logdialog.cpp  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qclipboard.h>
#include <qlayout.h>

#include <kapplication.h>
#include <kconfig.h>
#include <klistview.h>
#include <klocale.h>

#include "logitem.h"

#include "logdialog.h"

LogDialog::LogDialog(QWidget *parent, const char *name)
          : KSetiSpyView(Text, parent, name, WStyle_Customize | WStyle_DialogBorder | WStyle_Dialog)
{
  setCaption(i18n("Work Unit Log"));

  QBoxLayout *layout = new QVBoxLayout(this);

  KListView *logItemList = new KListView(this, "LogDialog::list");
  layout->addWidget(logItemList, 1);

  logItemList->addColumn(i18n("Time Done"));
  logItemList->setColumnAlignment(0, AlignLeft);
  logItemList->addColumn(i18n("Work Unit Name"));
  logItemList->setColumnAlignment(1, AlignLeft);
  logItemList->addColumn(i18n("Start RA"));
  logItemList->setColumnAlignment(2, AlignRight);
  logItemList->addColumn(i18n("Start Dec"));
  logItemList->setColumnAlignment(3, AlignRight);
  logItemList->addColumn(i18n("Angle Range"));
  logItemList->setColumnAlignment(4, AlignRight);
  logItemList->addColumn(i18n("TeraFLOPs"));
  logItemList->setColumnAlignment(5, AlignRight);
  logItemList->addColumn(i18n("Process Time"));
  logItemList->setColumnAlignment(6, AlignRight);
  logItemList->addColumn(i18n("% Done"));
  logItemList->setColumnAlignment(7, AlignRight);
  logItemList->addColumn(i18n("Spikes"));
  logItemList->setColumnAlignment(8, AlignCenter);
  logItemList->addColumn(i18n("Best Spike"));
  logItemList->setColumnAlignment(9, AlignRight);
  logItemList->addColumn(i18n("Gaussians"));
  logItemList->setColumnAlignment(10, AlignCenter);
  logItemList->addColumn(i18n("Best Gaussian"));
  logItemList->setColumnAlignment(11, AlignRight);
  logItemList->addColumn(i18n("Pulses"));
  logItemList->setColumnAlignment(12, AlignCenter);
  logItemList->addColumn(i18n("Best Pulse"));
  logItemList->setColumnAlignment(13, AlignRight);
  logItemList->addColumn(i18n("Triplets"));
  logItemList->setColumnAlignment(14, AlignCenter);
  logItemList->addColumn(i18n("Best Triplet"));
  logItemList->setColumnAlignment(15, AlignRight);
  logItemList->setSorting(0, true);
  logItemList->setShowSortIndicator(true);
  logItemList->setSelectionMode(QListView::NoSelection);

  connect(logItemList, SIGNAL(contextMenu(KListView *, QListViewItem *, const QPoint &)),
          this, SLOT(handleContextMenu(KListView*, QListViewItem*, const QPoint &)));
}

LogDialog::~LogDialog()
{
}

void LogDialog::readConfig(bool readGeometry)
{
  KConfig *config = kapp->config();

  config->setGroup("Work Unit Log Dialog");

  if(readGeometry)
  {
    QWidget *dialog = this->topLevelWidget();
    const QRect rect = dialog->geometry();
    dialog->setGeometry(config->readRectEntry("Geometry", &rect));
  }

  KListView *logItemList = (KListView *) child("LogDialog::list", "KListView");
  QValueList<int> l = config->readIntListEntry("Column widths");
  for(uint i = 0; i < l.count(); i++)
    logItemList->setColumnWidth(i, l[i]);
}

void LogDialog::saveConfig(bool saveGeometry)
{
  KConfig *config = kapp->config();

  config->setGroup("Work Unit Log Dialog");

  if(saveGeometry)
    config->writeEntry("Geometry", this->topLevelWidget()->geometry());

  KListView *logItemList = (KListView *) child("LogDialog::list", "KListView");
  QValueList<int> l;
  for(int i = 0; i < logItemList->columns(); i++)
    l.append(logItemList->columnWidth(i));
  config->writeEntry("Column widths", l);
}

void LogDialog::setLogData(const QValueList<log_data>& data)
{
  if(data == cache) return;
  cache = data;

  KListView *logItemList = (KListView *) child("LogDialog::list", "KListView");

  logItemList->clear();
  for(uint i = 0; i < cache.count(); i++)
    new LogItem(logItemList, cache[i]);
  logItemList->sort();
}

void LogDialog::handleContextMenu(KListView *, QListViewItem *, const QPoint& p)
{
  popup->popup(p);
}

void LogDialog::textToClipboard()
{
  QString out;

  KListView *logItemList = (KListView *) child("LogDialog::list", "KListView");

  for(int i = 0; i < logItemList->columns(); i++)
  {
    if(i > 0) out += "\t";
    out += logItemList->columnText(i);
  }
  out+= "\n";

  for(QListViewItem *logItem = logItemList->firstChild();
      logItem != NULL;
      logItem = logItem->nextSibling())
  {
    for(int i = 0; i < logItemList->columns(); i++)
    {
      if(i > 0) out += "\t";
      out += logItem->text(i);
    }
    out+= "\n";
  }

  KApplication::clipboard()->setText(out);
}

#include "logdialog.moc"

