/***************************************************************************
                          logmonitor.cpp  -  description
                             -------------------
    begin                : Mon Jul 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfileinfo.h>
#include <qregexp.h>

#include "logmonitor.h"

bool operator==(const log_data& data1, const log_data& data2)
{
  return(data1.done == data2.done && data1.name == data2.name);
}

LogMonitor::LogMonitor(const KURL& logURL, QObject *parent, const char *name)
           : DataMonitor(logURL, parent, name)
{
}

LogMonitor::~LogMonitor()
{
}

const QValueList<log_data> LogMonitor::logData()
{
  const QValueList<log_data> empty;
  return(empty);
}

void LogMonitor::writeSetiData(const QString&, const seti_data&)
{
}

void LogMonitor::updateData()
{
  emit updated();
}

QString LogMonitor::formatDouble(double n, int precision, char format)
{
  QString out = QString::number(n, format, precision);
  out.replace(QRegExp(","), ".");
  return(out);
}

#include "logmonitor.moc"

