/***************************************************************************
                          performancedialog.h  -  description
                             -------------------
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PERFORMANCEDIALOG_H
#define PERFORMANCEDIALOG_H

#include <klistview.h>

#include "ksetispyview.h"
#include "performanceitem.h"

class PerformanceDialog : public KSetiSpyView {
  Q_OBJECT
  public:
    PerformanceDialog(QWidget *parent=0, const char *name=0);
    ~PerformanceDialog();
    bool isInstant() const;
  public slots:
    void readConfig(bool readGeometry);
    void saveConfig(bool saveGeometry);
    void setInstant(bool set);
  protected:
    virtual void showEvent(QShowEvent *);
  protected slots:
    virtual void updateContent();
    virtual void textToClipboard();
  private:
    bool instant;
    struct {QString wu_name; double cpu, progress;} old, current;
    PerformanceItem *thisItem;
  private slots:
    void handleContextMenu(KListView *, QListViewItem *, const QPoint& p);
    void handleMultiplierMenu(const QString &);
};

#endif
