/***************************************************************************
                          setupview.cpp  -  description
                             -------------------
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qspinbox.h>

#include <kapplication.h>
#include <kcombobox.h>
#include <klocale.h>
#include <kpushbutton.h>
#include <ktabctl.h>

#include "profiledialog.h"
#include "statsserversdialog.h"

#include "setupview.h"

SetupView::SetupView(QWidget *parent, const char *name)
          : KSetiSpyView(Text, parent, name)
{
  QBoxLayout *layout = new QVBoxLayout(this);

  KTabCtl *tabs = new KTabCtl(this);
  layout->addWidget(tabs, 1);

  {
    QWidget *tab = new QWidget(tabs);
    tabs->addTab(tab, i18n("&Profiles"));

    QGridLayout *grid = new QGridLayout(tab, 5, 2, 8, 8);

    list = new KListBox(tab, "SetupView::list");
    list->setSelectionMode(KListBox::Single);
    grid->addMultiCellWidget(list, 0, 4, 0, 0);

    selected = -1;

    KPushButton *button;

    button = new KPushButton(i18n("&Add..."), tab, "SetupView::add_button");
    grid->addWidget(button, 0, 1);
    connect(button, SIGNAL(clicked()), this, SLOT(addProfile()));

    button = new KPushButton(i18n("&Edit..."), tab, "SetupView::change_button");
    grid->addWidget(button, 1, 1);
    connect(button, SIGNAL(clicked()), this, SLOT(changeProfile()));

    button = new KPushButton(i18n("&Remove"), tab, "SetupView::delete_button");
    grid->addWidget(button, 2, 1);
    connect(button, SIGNAL(clicked()), this, SLOT(deleteProfile()));

    button = new KPushButton(i18n("Set as &Current"), tab, "SetupView::current_button");
    grid->addWidget(button, 3, 1);
    connect(button, SIGNAL(clicked()), this, SLOT(setCurrentProfile()));

    grid->setRowStretch(4, 1);
    grid->setColStretch(0, 1);

    connect(kdoc, SIGNAL(updatedProfiles()), this, SLOT(updateList()));

    updateList();
  }

  {
    QWidget *tab = new QWidget(tabs);
    tabs->addTab(tab, i18n("&Display"));

    QGridLayout *grid = new QGridLayout(tab, 3, 2, 8, 8);

    QCheckBox *minimizeChkbox = new QCheckBox(i18n("&Minimize to tray"), tab, "SetupView::minimize_to_tray");
    grid->addWidget(minimizeChkbox, 0, 0);
    connect(minimizeChkbox, SIGNAL(clicked()), this, SLOT(handleTrayCheckboxes()));

    grid->addWidget(new QCheckBox(i18n("Remember &window positions"), tab, "SetupView::remember_geometry"), 0, 1);

    QCheckBox *runChkbox = new QCheckBox(i18n("&Run in tray"), tab, "SetupView::run_in_tray");
    grid->addWidget(runChkbox, 1, 0);
    connect(runChkbox, SIGNAL(clicked()), this, SLOT(handleTrayCheckboxes()));

    QCheckBox *closeChkbox = new QCheckBox(i18n("&Close to tray"), tab, "SetupView::close_to_tray");
    grid->addWidget(closeChkbox, 1, 1);
    connect(closeChkbox, SIGNAL(clicked()), this, SLOT(handleTrayCheckboxes()));

    setTrayFlags(0);

    grid->setColStretch(1, 1);
    grid->setRowStretch(2, 1);
  }

  {
    QWidget *tab = new QWidget(tabs);
    tabs->addTab(tab, i18n("&User Statistics"));

    QBoxLayout *vbox = new QVBoxLayout(tab);
    vbox->setMargin(8);
    vbox->setSpacing(8);

    QBoxLayout *hbox;

    QCheckBox *startupUpdChkbox = new QCheckBox(i18n("Auto-update stats &on startup"),
                                                tab, "SetupView::startup_update");
    vbox->addWidget(startupUpdChkbox);
    kdoc->setStatsAutoStartup(startupUpdChkbox->isChecked());
    connect(startupUpdChkbox, SIGNAL(toggled(bool)), kdoc, SLOT(setStatsAutoStartup(bool)));

    QCheckBox *uploadUpdChkbox = new QCheckBox(i18n("Auto-update stats &after transmitting cached results"),
                                               tab, "SetupView::upload_update");
    vbox->addWidget(uploadUpdChkbox);
    kdoc->setStatsAutoUpload(uploadUpdChkbox->isChecked());
    connect(uploadUpdChkbox, SIGNAL(toggled(bool)), kdoc, SLOT(setStatsAutoUpload(bool)));

    hbox = new QHBoxLayout(vbox);
    hbox->setSpacing(8);

    QCheckBox *autoUpdChkbox = new QCheckBox(i18n("Auto-update stats &every"),
                                             tab, "SetupView::auto_update_check");
    hbox->addWidget(autoUpdChkbox);
    kdoc->setStatsTimerInterval(0);
    connect(autoUpdChkbox, SIGNAL(toggled(bool)), this, SLOT(handleStatsUpdateCheckbox(bool)));

    QSpinBox *autoUpdSpinbox = new QSpinBox(1, 99, 1, tab, "SetupView::auto_update");
    hbox->addWidget(autoUpdSpinbox);

    hbox->addWidget(new QLabel(i18n("hours"), tab), 1);

    vbox->addStretch(1);

    hbox = new QHBoxLayout(vbox);
    hbox->setSpacing(8);

    hbox->addStretch(1);

    KPushButton *button = new KPushButton(i18n("&Servers..."), tab, "SetupView::servers");
    hbox->addWidget(button);
    connect(button, SIGNAL(clicked()), this, SLOT(setStatsServers()));
  }

  setRememberGeometry(true);

  delete popup;
  popup = NULL;
}

SetupView::~SetupView()
{
}

void SetupView::readConfig(bool)
{
  KConfig *config = kapp->config();

  config->setGroup("Setup");

  kdoc->setStatsAutoStartup(config->readBoolEntry("Stats auto startup"));
  if(kdoc->statsAutoStartup()) kdoc->updateStats();
  QCheckBox *startupUpdChkbox = (QCheckBox *) child("SetupView::startup_update", "QCheckBox");
  startupUpdChkbox->setChecked(kdoc->statsAutoStartup());

  kdoc->setStatsAutoUpload(config->readBoolEntry("Update stats on cache upload"));
  QCheckBox *uploadUpdChkbox = (QCheckBox *) child("SetupView::upload_update", "QCheckBox");
  uploadUpdChkbox->setChecked(kdoc->statsAutoUpload());

  const int hours = config->readNumEntry("Stats check interval", 0);
  QCheckBox *autoUpdChkbox = (QCheckBox *) child("SetupView::auto_update_check", "QCheckBox");
  autoUpdChkbox->setChecked(hours > 0);
  if(hours > 0)
  {
    QSpinBox *autoUpdSpinbox = (QSpinBox *) child("SetupView::auto_update", "QSpinBox");
    autoUpdSpinbox->setValue(hours);
  }
  kdoc->setStatsTimerInterval(hours);
}

void SetupView::saveConfig(bool)
{
  KConfig *config = kapp->config();

  config->setGroup("Setup");

  config->writeEntry("Stats auto startup", kdoc->statsAutoStartup());
  config->writeEntry("Update stats on cache upload", kdoc->statsAutoUpload());
  config->writeEntry("Stats check interval", kdoc->statsTimerInterval());
}

int SetupView::trayFlags()
{
  QCheckBox *minimizeChkbox = (QCheckBox *) child("SetupView::minimize_to_tray", "QCheckBox");
  QCheckBox *runChkbox = (QCheckBox *) child("SetupView::run_in_tray", "QCheckBox");
  QCheckBox *closeChkbox = (QCheckBox *) child("SetupView::close_to_tray", "QCheckBox");

  int out = 0;

  if(minimizeChkbox->isChecked()) out +=  MinimizeToTray;
  if(runChkbox->isChecked()) out += RunInTray;
  if(runChkbox->isChecked() & closeChkbox->isChecked()) out += CloseToTray;

  return(out);
}

bool SetupView::rememberGeometry()
{
  QCheckBox *chkbox = (QCheckBox *) child("SetupView::remember_geometry", "QCheckBox");

  return(chkbox->isChecked());
}

void SetupView::setTrayFlags(int flags)
{
  QCheckBox *minimizeChkbox = (QCheckBox *) child("SetupView::minimize_to_tray", "QCheckBox");
  QCheckBox *runChkbox = (QCheckBox *) child("SetupView::run_in_tray", "QCheckBox");
  QCheckBox *closeChkbox = (QCheckBox *) child("SetupView::close_to_tray", "QCheckBox");

  minimizeChkbox->setChecked(flags & MinimizeToTray);
  runChkbox->setChecked(flags & RunInTray);
  closeChkbox->setChecked(flags & CloseToTray);
  closeChkbox->setEnabled(flags & RunInTray);
}

void SetupView::setRememberGeometry(bool on)
{
  QCheckBox *chkbox = (QCheckBox *) child("SetupView::remember_geometry", "QCheckBox");

  chkbox->setChecked(on);
}

void SetupView::handleTrayCheckboxes()
{
  int flags = trayFlags();

  QCheckBox *closeChkbox = (QCheckBox *) child("SetupView::close_to_tray", "QCheckBox");
  if(!(flags & RunInTray))
  {
    closeChkbox->setChecked(false);
    closeChkbox->setEnabled(false);
  }
  else
    closeChkbox->setEnabled(true);

  emit updatedTrayFlags(flags);
}

void SetupView::handleStatsUpdateCheckbox(bool on)
{
  if(on)
  {
    QSpinBox *autoUpdSpinbox = (QSpinBox *) child("SetupView::auto_update", "QSpinBox");
    kdoc->setStatsTimerInterval(autoUpdSpinbox->value());
  }
  else
    kdoc->setStatsTimerInterval(0);
}

void SetupView::addProfile()
{
  const QStringList profiles = kdoc->profiles();
  profileInfoStruct profile = kdoc->getProfile(QString::null);

  ProfileDialog dialog(&profile, this);
  dialog.setForbiddenNames(profiles);
  dialog.setCalibrationPresets(SetiClientMonitor::calibrationPresets());

  if(dialog.exec())
    kdoc->addProfile(profile);
}

void SetupView::changeProfile()
{
  const QStringList profiles = kdoc->profiles();
  const QString name = profiles[selected = list->currentItem()];
  profileInfoStruct profile = kdoc->getProfile(name);

  ProfileDialog dialog(&profile, this);
  dialog.setForbiddenNames(profiles);
  dialog.setCalibrationPresets(SetiClientMonitor::calibrationPresets());

  if(dialog.exec())
    kdoc->changeProfile(name, profile);
}

void SetupView::deleteProfile()
{
  const QStringList profiles = kdoc->profiles();
  const QString name = profiles[list->currentItem()];

  if(QMessageBox::warning(this, i18n("Confirm delete"), i18n("Really delete profile '%1'?").arg(name),
                          QMessageBox::Ok | QMessageBox::Default, QMessageBox::Cancel) == QMessageBox::Ok)
    kdoc->deleteProfile(name);
}

void SetupView::setCurrentProfile()
{
  const QStringList profiles = kdoc->profiles();
  const QString name = profiles[list->currentItem()];

  kdoc->setCurrentProfile(name);
}

void SetupView::updateList()
{
  QStringList profiles = kdoc->profiles();
  QString current = kdoc->currentProfile();

  const bool hasProfiles = profiles.count() > 0;

  list->clear();
  list->insertStringList(profiles);
  if(hasProfiles) list->setCurrentItem(0);

  const int currentPos = profiles.findIndex(current);

  if(currentPos != -1)
    list->changeItem(i18n("%1 (current)").arg(profiles[currentPos]), currentPos);

  if(selected != -1)
  {
    list->setCurrentItem(selected);
    selected = -1;
  }

  KPushButton *changeButton = (KPushButton *) child("SetupView::change_button", "KPushButton");
  changeButton->setEnabled(hasProfiles);

  KPushButton *deleteButton = (KPushButton *) child("SetupView::delete_button", "KPushButton");
  deleteButton->setEnabled(hasProfiles);

  KPushButton *currentButton = (KPushButton *) child("SetupView::current_button", "KPushButton");
  currentButton->setEnabled(hasProfiles);
}

void SetupView::setStatsServers()
{
  StatsServersDialog dialog(this);

  for(int i = 0; i < N_STATS_URLS; i ++) {
    const KSetiSpyDoc::StatsURLType type = KSetiSpyDoc::StatsURLType(i);
    dialog.setStatsURL(type, kdoc->statsURL(type));
  }
    
  if(dialog.exec())
    for(int i = 0; i < N_STATS_URLS; i++) {
      const KSetiSpyDoc::StatsURLType type = KSetiSpyDoc::StatsURLType(i);
      kdoc->setStatsURL(type, dialog.statsURL(type));
    }
}

#include "setupview.moc"

