/***************************************************************************
                          setupview.h  -  description
                             ---------------
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETUPVIEW_H
#define SETUPVIEW_H

#include <klistbox.h>

#include "ksetispyview.h"

class SetupView : public KSetiSpyView {
  Q_OBJECT
  public:
    enum TrayFlags {RunInTray = 1, MinimizeToTray = 2, CloseToTray = 4};
    SetupView(QWidget *parent=0, const char *name=0);
    ~SetupView();
    int trayFlags();
    bool rememberGeometry();
  public slots:
    virtual void readConfig(bool readGeometry);
    virtual void saveConfig(bool saveGeometry);
    void setTrayFlags(int flags);
    void setRememberGeometry(bool on);
  signals:
    void updatedTrayFlags(int flags);
  private:
    KListBox *list;
    int selected;
  private slots:
    void handleTrayCheckboxes();
    void handleStatsUpdateCheckbox(bool on);
    void addProfile();
    void changeProfile();
    void deleteProfile();
    void setCurrentProfile();
    void updateList();
    void setStatsServers();
};

#endif
