/***************************************************************************
                          skymapwindow.h  -  description
                             -------------------
    begin                : Sun Jun 3 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SKYMAPWINDOW_H
#define SKYMAPWINDOW_H

#include <qlabel.h>
#include <qpixmap.h>
#include <qstring.h>

#include <kdialog.h>
#include <klocale.h>

#include "ksetispyview.h"
#include "telescopepathwindow.h"

const int N_CONSTELLATIONS = 88;

const struct {
  const char *abbrev;
  QString name, id;
  double ra, dec;
} Constellations[N_CONSTELLATIONS] =
{
  {"And", I18N_NOOP("Andromeda"), I18N_NOOP("article.php?articleid=1"), 1.0, 40.0},
  {"Ant", I18N_NOOP("Antila"), I18N_NOOP("article.php?articleid=2"), 10.0, -30.0},
  {"Aps", I18N_NOOP("Apus"), I18N_NOOP("article.php?articleid=3"), 16.0, -75.0},
  {"Aql", I18N_NOOP("Aquila"), I18N_NOOP("article.php?articleid=5"), 20.0, 5.0},
  {"Aqr", I18N_NOOP("Aquarius"), I18N_NOOP("article.php?articleid=4"), 22.0, -10.0},
  {"Ara", I18N_NOOP("Ara"), I18N_NOOP("article.php?articleid=6"), 17.0, -55.0},
  {"Ari", I18N_NOOP("Aries"), I18N_NOOP("article.php?articleid=7"), 3.0, 20.0},
  {"Aur", I18N_NOOP("Auriga"), I18N_NOOP("article.php?articleid=8"), 6.0, 40.0},
  {"Boo", I18N_NOOP("Bootes"), I18N_NOOP("article.php?articleid=9"), 15.0, 30.0},
  {"CMa", I18N_NOOP("Canis Major"), I18N_NOOP("article.php?articleid=14"), 7.0, -20.0},
  {"CMi", I18N_NOOP("Canis Minor"), I18N_NOOP("article.php?articleid=15"), 8.0, 5.0},
  {"CVn", I18N_NOOP("Canes Venatici"), I18N_NOOP("article.php?articleid=13"), 13.0, 40.0},
  {"Cae", I18N_NOOP("Caelum"), I18N_NOOP("article.php?articleid=10"), 5.0, -40.0},
  {"Cam", I18N_NOOP("Camelopardus"), I18N_NOOP("article.php?articleid=11"), 9.0, 70.0},
  {"Cap", I18N_NOOP("Capricornus"), I18N_NOOP("article.php?articleid=16"), 21.0, -20.0},
  {"Car", I18N_NOOP("Carina"), I18N_NOOP("article.php?articleid=17"), 9.0, -65.0},
  {"Cas", I18N_NOOP("Cassiopeia"), I18N_NOOP("article.php?articleid=18"), 1.0, 60.0},
  {"Cen", I18N_NOOP("Centaurus"), I18N_NOOP("article.php?articleid=19"), 13.0, -50.0},
  {"Cep", I18N_NOOP("Cepheus"), I18N_NOOP("article.php?articleid=20"), 2.0, 75.0},
  {"Cet", I18N_NOOP("Cetus"), I18N_NOOP("article.php?articleid=21"), 2.0, -10.0},
  {"Cha", I18N_NOOP("Chamaeleon"), I18N_NOOP("article.php?articleid=22"), 11.0, -80.0},
  {"Cir", I18N_NOOP("Circinus"), I18N_NOOP("article.php?articleid=23"), 15.0, -60.0},
  {"Cnc", I18N_NOOP("Cancer"), I18N_NOOP("article.php?articleid=12"), 9.0, 20.0},
  {"Col", I18N_NOOP("Columba"), I18N_NOOP("article.php?articleid=24"), 6.0, -35.0},
  {"Com", I18N_NOOP("Coma Berenices"), I18N_NOOP("article.php?articleid=25"), 13.0, 25.0},
  {"CrA", I18N_NOOP("Corona Australis"), I18N_NOOP("article.php?articleid=26"), 19.0, -40.0},
  {"CrB", I18N_NOOP("Corona Borealis"), I18N_NOOP("article.php?articleid=27"), 16.0, 35.0},
  {"Crt", I18N_NOOP("Crater"), I18N_NOOP("article.php?articleid=29"), 11.0, -15.0},
  {"Cru", I18N_NOOP("Crux"), I18N_NOOP("article.php?articleid=30"), 12.0, -60.0},
  {"Crv", I18N_NOOP("Corvus"), I18N_NOOP("article.php?articleid=28"), 12.0, -20.0},
  {"Cyg", I18N_NOOP("Cygnus"), I18N_NOOP("article.php?articleid=31"), 21.0, 45.0},
  {"Del", I18N_NOOP("Delphinus"), I18N_NOOP("article.php?articleid=32"), 21.0, 10.0},
  {"Dor", I18N_NOOP("Dorado"), I18N_NOOP("article.php?articleid=33"), 5.0, -60.0},
  {"Dra", I18N_NOOP("Draco"), I18N_NOOP("article.php?articleid=34"), 15.0, 65.0},
  {"Equ", I18N_NOOP("Equuleus"), I18N_NOOP("article.php?articleid=35"), 21.0, 10.0},
  {"Eri", I18N_NOOP("Eridanus"), I18N_NOOP("article.php?articleid=36"), 3.0, -20.0},
  {"For", I18N_NOOP("Fornax"), I18N_NOOP("article.php?articleid=37"), 3.0, -30.0},
  {"Gem", I18N_NOOP("Gemini"), I18N_NOOP("article.php?articleid=38"), 7.0, 25.0},
  {"Gru", I18N_NOOP("Grus"), I18N_NOOP("article.php?articleid=39"), 22.0, -45.0},
  {"Her", I18N_NOOP("Hercules"), I18N_NOOP("article.php?articleid=40"), 17.0, 30.0},
  {"Hor", I18N_NOOP("Horologium"), I18N_NOOP("article.php?articleid=41"), 3.0, -55.0},
  {"Hya", I18N_NOOP("Hydra"), I18N_NOOP("article.php?articleid=42"), 11.0, -15.0},
  {"Hyi", I18N_NOOP("Hydrus"), I18N_NOOP("article.php?articleid=43"), 2.0, -70.0},
  {"Ind", I18N_NOOP("Indus"), I18N_NOOP("article.php?articleid=44"), 22.0, -60.0},
  {"LMi", I18N_NOOP("Leo Minor"), I18N_NOOP("article.php?articleid=47"), 10.0, 35.0},
  {"Lac", I18N_NOOP("Lacerta"), I18N_NOOP("article.php?articleid=45"), 22.0, 45.0},
  {"Leo", I18N_NOOP("Leo"), I18N_NOOP("article.php?articleid=46"), 11.0, 15.0},
  {"Lep", I18N_NOOP("Lepus"), I18N_NOOP("article.php?articleid=48"), 6.0, -20.0},
  {"Lib", I18N_NOOP("Libra"), I18N_NOOP("article.php?articleid=49"), 15.0, -15.0},
  {"Lup", I18N_NOOP("Lupus"), I18N_NOOP("article.php?articleid=50"), 15.0, -45.0},
  {"Lyn", I18N_NOOP("Lynx"), I18N_NOOP("article.php?articleid=51"), 8.0, 50.0},
  {"Lyr", I18N_NOOP("Lyra"), I18N_NOOP("article.php?articleid=52"), 19.0, 35.0},
  {"Men", I18N_NOOP("Mensa"), I18N_NOOP("article.php?articleid=53"), 5.0, -80.0},
  {"Mic", I18N_NOOP("Microscopium"), I18N_NOOP("article.php?articleid=54"), 21.0, -35.0},
  {"Mon", I18N_NOOP("Monoceros"), I18N_NOOP("article.php?articleid=55"), 7.0, 0.0},
  {"Mus", I18N_NOOP("Musca"), I18N_NOOP("article.php?articleid=56"), 13.0, -70.0},
  {"Nor", I18N_NOOP("Norma"), I18N_NOOP("article.php?articleid=57"), 16.0, -50.0},
  {"Oct", I18N_NOOP("Octans"), I18N_NOOP("article.php?articleid=58"), 22.0, -85.0},
  {"Oph", I18N_NOOP("Ophiuchus"), I18N_NOOP("article.php?articleid=59"), 17.0, -10.0},
  {"Ori", I18N_NOOP("Orion"), I18N_NOOP("article.php?articleid=60"), 6.0, 5.0},
  {"Pav", I18N_NOOP("Pavo"), I18N_NOOP("article.php?articleid=61"), 20.0, -65.0},
  {"Peg", I18N_NOOP("Pegasus"), I18N_NOOP("article.php?articleid=62"), 23.0, 20.0},
  {"Per", I18N_NOOP("Perseus"), I18N_NOOP("article.php?articleid=63"), 3.0, 45.0},
  {"Phe", I18N_NOOP("Phoenix"), I18N_NOOP("article.php?articleid=64"), 1.0, -50.0},
  {"Pic", I18N_NOOP("Pictor"), I18N_NOOP("article.php?articleid=65"), 6.0, -55.0},
  {"PsA", I18N_NOOP("Pisces Australis"), I18N_NOOP("article.php?articleid=67"), 22.0, -30.0},
  {"Psc", I18N_NOOP("Pisces"), I18N_NOOP("article.php?articleid=66"), 0.0, 15.0},
  {"Pup", I18N_NOOP("Puppis"), I18N_NOOP("article.php?articleid=68"), 7.0, -30.0},
  {"Pyx", I18N_NOOP("Pyxis"), I18N_NOOP("article.php?articleid=69"), 9.0, -30.0},
  {"Ret", I18N_NOOP("Reticulum"), I18N_NOOP("article.php?articleid=70"), 4.0, -60.0},
  {"Sci", I18N_NOOP("Sculptor"), I18N_NOOP("article.php?articleid=74"), 0.0, -35.0},
  {"Sco", I18N_NOOP("Scorpius"), I18N_NOOP("article.php?articleid=73"), 17.0, -25.0},
  {"Sct", I18N_NOOP("Scutum"), I18N_NOOP("article.php?articleid=75"), 19.0, -10.0},
  {"Ser", I18N_NOOP("Serpens"), I18N_NOOP("article.php?articleid=76"), 17.0, 5.0},
  {"Sex", I18N_NOOP("Sextans"), I18N_NOOP("article.php?articleid=77"), 10.0, 0.0},
  {"Sge", I18N_NOOP("Sagitta"), I18N_NOOP("article.php?articleid=71"), 20.0, 20.0},
  {"Sgr", I18N_NOOP("Sagittarius"), I18N_NOOP("article.php?articleid=72"), 19.0, -30.0},
  {"Tau", I18N_NOOP("Taurus"), I18N_NOOP("article.php?articleid=78"), 5.0, 15.0},
  {"Tel", I18N_NOOP("Telescopium"), I18N_NOOP("article.php?articleid=79"), 19.0, -50.0},
  {"TrA", I18N_NOOP("Triangulum Australis"), I18N_NOOP("article.php?articleid=81"), 16.0, -65.0},
  {"Tri", I18N_NOOP("Triangulum"), I18N_NOOP("article.php?articleid=80"), 2.0, 30.0},
  {"Tuc", I18N_NOOP("Tucana"), I18N_NOOP("article.php?articleid=82"), 0.0, -65.0},
  {"UMa", I18N_NOOP("Ursa Major"), I18N_NOOP("article.php?articleid=83"), 11.0, 50.0},
  {"UMi", I18N_NOOP("Ursa Minor"), I18N_NOOP("article.php?articleid=84"), 15.0, 75.0},
  {"Vel", I18N_NOOP("Vela"), I18N_NOOP("article.php?articleid=85"), 10.0, -45.0},
  {"Vir", I18N_NOOP("Virgo"), I18N_NOOP("article.php?articleid=86"), 13.0, -5.0},
  {"Vol", I18N_NOOP("Volans"), I18N_NOOP("article.php?articleid=87"), 8.0, -70.0},
  {"Vul", I18N_NOOP("Vulpecula"), I18N_NOOP("article.php?articleid=88"), 20.0, 25.0}
};

const QString ConstellationsSiteName     = I18N_NOOP("Peoria Astronomical Society");
const QString ConstellationsSiteHomeURL  = I18N_NOOP("http://www.astronomical.org/");
const QString ConstellationsSiteQueryURL = I18N_NOOP("http://www.astronomical.org/portal/modules/wfsection/%1");

class SkyMapWindow : public KSetiSpyView {
  Q_OBJECT
  public:
    SkyMapWindow(const char *name=0);
    ~SkyMapWindow();
    bool isHistoryVisible() const;
  public slots:
    void setHistoryVisible(bool set);
    virtual void readConfig(bool readGeometry);
    virtual void saveConfig(bool saveGeometry);
  protected slots:
    virtual void updateContent();
    virtual void handleURL(const QString& url);
    virtual void pixmapToClipboard();
    virtual void pixmapToFile();
  private:
    void setPixmap();
    void initLegend();
    QLabel *getTarget(uint n);
    static QPoint position(double ra, double dec);
    KDialog *legend;
    TelescopePathWindow *telescopeWindow;
    QValueList<log_data> cache;
    bool history;
    uint targets;
  private slots:
    void toggleHistoryVisible();
};

#endif
