/***********************************************************************
*                                                                      *
*               This software is part of the ast package               *
*                  Copyright (c) 1985-2006 AT&T Corp.                  *
*                      and is licensed under the                       *
*                  Common Public License, Version 1.0                  *
*                            by AT&T Corp.                             *
*                                                                      *
*                A copy of the License is available at                 *
*            http://www.opensource.org/licenses/cpl1.0.txt             *
*         (with md5 checksum 059e8cd6165cb4c31e351f2b69388fd9)         *
*                                                                      *
*              Information and Software Systems Research               *
*                            AT&T Research                             *
*                           Florham Park NJ                            *
*                                                                      *
*                 Glenn Fowler <gsf@research.att.com>                  *
*                  David Korn <dgk@research.att.com>                   *
*                   Phong Vo <kpv@research.att.com>                    *
*                                                                      *
***********************************************************************/
#pragma prototyped

#include <ast.h>

#if _lib_memchr

NoN(memchr)

#else

/*
 * Return the ptr in sp at which the character c appears;
 * 0 if not found in n chars; don't stop at \0.
 */

void*
memchr(const void* asp, register int c, size_t n)
{
	register const char*	sp = (char*)asp;
	register const char*	ep = sp + n;

	while (sp < ep)
		if (*sp++ == c)
			return(--sp);
	return(0);
}

#endif
