/***********************************************************************
*                                                                      *
*               This software is part of the ast package               *
*           Copyright (c) 1990-2007 AT&T Knowledge Ventures            *
*                      and is licensed under the                       *
*                  Common Public License, Version 1.0                  *
*                      by AT&T Knowledge Ventures                      *
*                                                                      *
*                A copy of the License is available at                 *
*            http://www.opensource.org/licenses/cpl1.0.txt             *
*         (with md5 checksum 059e8cd6165cb4c31e351f2b69388fd9)         *
*                                                                      *
*              Information and Software Systems Research               *
*                            AT&T Research                             *
*                           Florham Park NJ                            *
*                                                                      *
*                 Glenn Fowler <gsf@research.att.com>                  *
*                                                                      *
***********************************************************************/

/* : : generated by proto : : */

#if !defined(__PROTO__)
#  if defined(__STDC__) || defined(__cplusplus) || defined(_proto) || defined(c_plusplus)
#    if defined(__cplusplus)
#      define __LINKAGE__	"C"
#    else
#      define __LINKAGE__
#    endif
#    define __STDARG__
#    define __PROTO__(x)	x
#    define __OTORP__(x)
#    define __PARAM__(n,o)	n
#    if !defined(__STDC__) && !defined(__cplusplus)
#      if !defined(c_plusplus)
#      	define const
#      endif
#      define signed
#      define void		int
#      define volatile
#      define __V_		char
#    else
#      define __V_		void
#    endif
#  else
#    define __PROTO__(x)	()
#    define __OTORP__(x)	x
#    define __PARAM__(n,o)	o
#    define __LINKAGE__
#    define __V_		char
#    define const
#    define signed
#    define void		int
#    define volatile
#  endif
#  define __MANGLE__	__LINKAGE__
#  if defined(__cplusplus) || defined(c_plusplus)
#    define __VARARG__	...
#  else
#    define __VARARG__
#  endif
#  if defined(__STDARG__)
#    define __VA_START__(p,a)	va_start(p,a)
#  else
#    define __VA_START__(p,a)	va_start(p)
#  endif
#  if !defined(__INLINE__)
#    if defined(__cplusplus)
#      define __INLINE__	extern __MANGLE__ inline
#    else
#      if defined(_WIN32) && !defined(__GNUC__)
#      	define __INLINE__	__inline
#      endif
#    endif
#  endif
#endif
#if !defined(__LINKAGE__)
#define __LINKAGE__		/* 2004-08-11 transition */
#endif
#line 1 "proto.c"
 

#line 147
# ifndef __STDC__
# ifndef creat
# define creat		_huh_creat
# endif
# if 1
# ifndef access
# define access		_huh_access
# endif
# ifndef ctime
# define ctime		_huh_ctime
# endif
# ifndef mkdir
# define mkdir		_huh_mkdir
# endif
# endif
# endif

# include <sys/types.h>
# include <sys/stat.h>
# include <fcntl.h>
# if 1
# include <stdio.h>
# else
# include <time.h>
# endif

# ifndef __STDC__
# undef	access
# undef	ctime
# undef	creat
# undef	mkdir
# endif

# ifndef O_RDONLY
# define O_RDONLY	0
# endif

# ifndef S_IRUSR
# define S_IRUSR		0400
# endif
# ifndef S_IWUSR
# define S_IWUSR		0200
# endif
# ifndef S_IXUSR
# define S_IXUSR		0100
# endif
# ifndef S_IRGRP
# define S_IRGRP		0040
# endif
# ifndef S_IWGRP
# define S_IWGRP		0020
# endif
# ifndef S_IXGRP
# define S_IXGRP		0010
# endif
# ifndef S_IROTH
# define S_IROTH		0004
# endif
# ifndef S_IWOTH
# define S_IWOTH		0002
# endif
# ifndef S_IXOTH
# define S_IXOTH		0001
# endif

# ifndef __STDC__
# if !_WIN32 && !_WINIX
# define remove(x)	unlink(x)
# define rename(x,y)	((link(x,y)||remove(x))?-1:0)
# endif

# if 1
extern __MANGLE__ int	access __PROTO__((const char*, int));
extern __MANGLE__ int	mkdir __PROTO__((const char*, int));
# endif

# endif

# if 1
extern __MANGLE__ int	utime __PROTO__((const char*, time_t*));
# endif

 




int
replace __PARAM__((const char* newfile, const char* oldfile, int preserve), (newfile, oldfile, preserve)) __OTORP__(const char* newfile; const char* oldfile; int preserve;){
	struct stat	st;
	time_t		ut[2];

	if (stat(oldfile, &st))
	{
		if (preserve)
			return -1;
		st.st_mode = 0;
	}
	if (remove(oldfile) || rename(newfile, oldfile))
		return -1;
	if (st.st_mode &= (S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IWGRP|S_IXGRP|S_IROTH|S_IWOTH|S_IXOTH))
		chmod(oldfile, st.st_mode);
	if (preserve)
	{
		ut[0] = st.st_atime;
		ut[1] = st.st_mtime;
		preserve = utime(oldfile, ut);
	}
	return preserve;
}

# undef	utime
# define utime		______utime

#line 1 "../../lib/libpp/ppproto.c"
 
#line 13
static const char id[] = "\n@(#)$Id: proto (AT&T Research) 2006-06-28 $\000\n";

#line 1 "../../lib/libpp/ppfsm.c"
 
#line 1 "../../lib/libpp/pplib.h"
   
#line 108
struct ppsymbol;
struct ppindex;

typedef char*	(*PPBUILTIN) __PROTO__((char*, const char*, const char*));
typedef void	(*PPCOMMENT) __PROTO__((const char*, const char*, const char*, int));
typedef void	(*PPINCREF) __PROTO__((const char*, const char*, int, int));
typedef void	(*PPLINESYNC) __PROTO__((int, const char*));
typedef void	(*PPMACREF) __PROTO__((struct ppsymbol*, const char*, int, int, unsigned long));
typedef int	(*PPOPTARG) __PROTO__((int, int, const char*));
typedef void	(*PPPRAGMA) __PROTO__((const char*, const char*, const char*, const char*, int));

struct ppinstk				 
{
	char*		nextchr;	 
	struct ppinstk*	next;		 
	struct ppinstk*	prev;		 
	long*		control;	 
	char*		buffer;		 
	char*		file;		 
	char*		prefix;		 
	struct ppsymbol* symbol;	 

	struct ppindex*	index;		 
	int		buflen;		 

	int		line;		 
	int		vendor;		 
	short		fd;		 
	short		hide;		 
	short		flags;		 
	char		type;		 
};









struct pplist				 
{
	char*		value;		 
	struct pplist*	next;		 
};

struct oplist				 
{
	int		op;		 
	char*		value;		 
	struct oplist*	next;		 
};

struct pphide				 
{
	struct ppmacro*	macro;		 
	unsigned long	flags;		 
	int		level;		 
};

struct ppmacstk				 
{
	struct ppmacstk* next;		 
	struct ppmacstk* prev;		 
	int		line;		 
	char*		arg[1];		 
};

struct ppmember				 
{
	struct ppdirs*	archive;	 
	unsigned long	offset;		 
	unsigned long	size;		 
};

struct counter				 
{
	int		candidate;	 
	int		function;	 
	int		macro;		 
	int		pplex;		 
	int		push;		 
	int		terminal;	 
	int		token;		 
};

struct pptuple				 
{
	struct pptuple*	nomatch;	 
	struct pptuple*	match;		 
	char		token[1];	 
};

struct ppfileid				 
{
	unsigned long	st_dev;		 
	unsigned long	st_ino;		 
};

struct pathid				 
{
	char*		path;		 
	struct ppfileid	id;		 
};

#line 1 "../../lib/libpp/pp.h"
 
#line 206
 
#line 217
        
#line 329
struct ppdirs				 
{
	char*		name;		 
	struct ppdirs*	next;		 


	unsigned char c; unsigned char index; unsigned char type; union { char* buffer; char* sp; struct ppdirs* subdir; } info; struct ppfileid id;


};

struct ppkeyword			 
{
	char*		name;		 
	int		value;		 
};

struct ppmacro				 
{
	int		arity;		 
	char*		value;		 


	struct pptuple* tuple; char* formals; int size;


};

struct ppsymbol				 
{
	int hash_header;			 
	unsigned long	flags;		 
	struct ppmacro*	macro;		 
	__V_*		value;		 


	struct pphide* hidden;


};

#line 378
struct ppglobals			 
{
	const char*	version;	 
	char*		lineid;		 
	char*		outfile;	 
	char*		pass;		 
	char*		token;		 
	struct ppsymbol* symbol;	  



	char*		outb;		 
	char*		outbuf;		 
	char*		outp;	    	 
	char*		oute;	    	 
	unsigned long	offset;		 


	struct ppdirs* lcldirs; struct ppdirs* stddirs; int flags; char* symtab;		 



	struct ppcontext* context; long state; long mode; long option; long test; struct { char* sp; long flags; } filedeps; struct ppdirs* firstdir; struct ppdirs* lastdir; int hide; int column; int pending; char* firstfile; char* lastfile; char* ignore; char* probe; char* filtab; char* prdtab; char* date; char* time; char* maps; long ro_state; long ro_mode; long ro_option; struct pathid cdir; struct pathid hostdir; char* ppdefault; struct ppindex* firstindex; struct ppindex* lastindex; struct oplist* firstop; struct oplist* lastop; struct oplist* firsttx; struct oplist* lasttx; unsigned char arg_file; unsigned char arg_mode; unsigned char arg_style; unsigned char c; unsigned char hosted; unsigned char ignoresrc; unsigned char initialized; unsigned char standalone; unsigned char spare_1;		 



	char* checkpoint; int constack; struct ppinstk* in; char* addp; char* args; char* addbuf; char* catbuf; char* hdrbuf; char* hidebuf; char* path; char* tmpbuf; char* valbuf; char* optflags; int lastout; char* include; char* prefix; struct ppmember* member; int hidden; int hiding; int level; struct { int input; int output; } pool; struct { long ro_state; long ro_mode; long ro_option; int on; char* symtab; } reset; int truncate; struct ppmacstk* macp; char* maxmac; char* mactop; char* toknxt; long* control; long* maxcon; struct oplist* chop; struct ppfile* insert; struct ppfile* original; struct ppdirs* found; int vendor; char* dirtab; char* strtab; PPBUILTIN builtin; PPCOMMENT comment; PPINCREF incref; PPLINESYNC linesync; PPLINESYNC olinesync; PPMACREF macref; PPOPTARG optarg; PPPRAGMA pragma; struct counter counter; char funbuf[256];		 


};

 





extern __MANGLE__ struct ppglobals	pp;
extern __MANGLE__ char		_pp_ctype[];

extern __MANGLE__ int		ppargs __PROTO__((char**, int));
extern __MANGLE__ void		ppcpp __PROTO__((void));
extern __MANGLE__ void		ppcomment __PROTO__((char*, char*, char*, int));
extern __MANGLE__ __V_*		ppcontext __PROTO__((__V_*, int));
extern __MANGLE__ void		pperror __PROTO__((int, ...));
extern __MANGLE__ void		ppincref __PROTO__((char*, char*, int, int));
extern __MANGLE__ void		ppinput __PROTO__((char*, char*, int));
extern __MANGLE__ int		pplex __PROTO__((void));
extern __MANGLE__ void		ppline __PROTO__((int, char*));
extern __MANGLE__ void		ppmacref __PROTO__((struct ppsymbol*, char*, int, int, unsigned long));
extern __MANGLE__ void		ppop __PROTO__((int, ...));
extern __MANGLE__ void		pppragma __PROTO__((char*, char*, char*, char*, int));
extern __MANGLE__ int		ppprintf __PROTO__((char*, ...));
extern __MANGLE__ int		ppsync __PROTO__((void));

#line 366 "../../lib/libpp/pplib.h"

#line 1 "../../lib/libpp/ppdef.h"
 
#line 367 "../../lib/libpp/pplib.h"

#line 1 "../../lib/libpp/ppkey.h"
 
#line 16
        
#line 125
extern __MANGLE__ struct ppkeyword	ppkey[];

#line 368 "../../lib/libpp/pplib.h"
  
#line 681
struct ppcontext			 
{
	struct ppdirs* lcldirs; struct ppdirs* stddirs; int flags; char* symtab;
	struct ppcontext* context; long state; long mode; long option; long test; struct { char* sp; long flags; } filedeps; struct ppdirs* firstdir; struct ppdirs* lastdir; int hide; int column; int pending; char* firstfile; char* lastfile; char* ignore; char* probe; char* filtab; char* prdtab; char* date; char* time; char* maps; long ro_state; long ro_mode; long ro_option; struct pathid cdir; struct pathid hostdir; char* ppdefault; struct ppindex* firstindex; struct ppindex* lastindex; struct oplist* firstop; struct oplist* lastop; struct oplist* firsttx; struct oplist* lasttx; unsigned char arg_file; unsigned char arg_mode; unsigned char arg_style; unsigned char c; unsigned char hosted; unsigned char ignoresrc; unsigned char initialized; unsigned char standalone; unsigned char spare_1;
};

struct ppfile 
{
	int hash_header;			 
	struct ppsymbol* guard;		 
	struct ppfile*	bound[4];	 
	int		flags;		 
};



struct ppindex				 
{
	struct ppindex*	next;		 
	struct ppfile*	file;		 
	unsigned long	begin;		 
	unsigned long	end;		 
};



struct ppsymkey				 
{
	struct ppsymbol	sym;		 
	int		lex;		 
};

#line 727
# ifdef __STDC__

# include <stdlib.h>
# include <unistd.h>
# include <time.h>
# include <string.h>

# else

# define size_t		int

extern __MANGLE__ __V_*		realloc __PROTO__((__V_*, size_t));
extern __MANGLE__ __V_*		calloc __PROTO__((size_t, size_t));
extern __MANGLE__ char*		ctime __PROTO__((time_t*));
extern __MANGLE__ void		free __PROTO__((__V_*));

# ifndef O_RDONLY

extern __MANGLE__ int		access __PROTO__((const char*, int));
extern __MANGLE__ int		close __PROTO__((int));
extern __MANGLE__ int		creat __PROTO__((const char*, int));
extern __MANGLE__ void		exit __PROTO__((int));
extern __MANGLE__ int		link __PROTO__((const char*, const char*));
extern __MANGLE__ int		open __PROTO__((const char*, int, ...));
extern __MANGLE__ int		read __PROTO__((int, __V_*, int));
extern __MANGLE__ time_t		time __PROTO__((time_t*));
extern __MANGLE__ int		unlink __PROTO__((const char*));
extern __MANGLE__ int		write __PROTO__((int, const __V_*, int));

# endif

# endif

#line 799
extern __MANGLE__ void		ppassert __PROTO__((int, char*, char*));
extern __MANGLE__ void		ppbuiltin __PROTO__((void));
extern __MANGLE__ int		ppcall __PROTO__((struct ppsymbol*, int));
extern __MANGLE__ int		ppcontrol __PROTO__((void));
extern __MANGLE__ void		ppdump __PROTO__((void));
extern __MANGLE__ char*		ppexpand __PROTO__((char*));
extern __MANGLE__ long		ppexpr __PROTO__((int*));
extern __MANGLE__ void		ppfsm __PROTO__((int, char*));
extern __MANGLE__ char*		ppinstr __PROTO__((struct ppinstk*));
extern __MANGLE__ char*		ppkeyname __PROTO__((int, int));
extern __MANGLE__ char*		pplexstr __PROTO__((int));
extern __MANGLE__ void		ppload __PROTO__((char*));
extern __MANGLE__ void		ppmapinclude __PROTO__((char*, char*));
extern __MANGLE__ char*		ppmodestr __PROTO__((long));
extern __MANGLE__ int		ppmultiple __PROTO__((struct ppfile*, struct ppsymbol*));
extern __MANGLE__ void		ppnest __PROTO__((void));
extern __MANGLE__ int		ppoption __PROTO__((char*));
extern __MANGLE__ char*		ppoptionstr __PROTO__((long));
extern __MANGLE__ void		pppclose __PROTO__((char*));
extern __MANGLE__ int		pppdrop __PROTO__((char*));
extern __MANGLE__ char*		pppopen __PROTO__((char*, int, char*, char*, char*, char*, int));
extern __MANGLE__ int		pppread __PROTO__((char*));
extern __MANGLE__ int		pppredargs __PROTO__((void));
extern __MANGLE__ void		pppush __PROTO__((int, char*, char*, int));
extern __MANGLE__ struct ppsymbol*	pprefmac __PROTO__((char*, int));
extern __MANGLE__ int		ppsearch __PROTO__((char*, int, int));
extern __MANGLE__ char*		ppstatestr __PROTO__((long));
extern __MANGLE__ char*		pptokstr __PROTO__((char*, int));
extern __MANGLE__ void		pptrace __PROTO__((int));

#line 11 "../../lib/libpp/ppfsm.c"

#line 1 "../../lib/libpp/ppfsm.h"
     
#line 185
     
#line 249
extern __MANGLE__ short		_pp_fsmtab[(0+28)+1][255+1];

 



extern __MANGLE__ char		_pp_trigraph[255+1];

extern __MANGLE__ void		_pp_refill __PROTO__((int));

#line 12 "../../lib/libpp/ppfsm.c"

  
#line 67
struct fsminit				 
{
	int		state;		 
	unsigned char	ch[4];		 
	int		nextstate;	 
};

static struct fsminit	fsminit[] =
{
 
	{	0,	{ 023 },		((0+28)+11),			},
	{	0,	{ 002 },		(0),			},
	{	0,	{ 001 },		(0+23),			},
	{	0,	{ '.' },		(0+25),			},
	{	0,	{ 021 },		(0+19),			},
	{	0,	{ 'L' },		(0+20),			},
	{	0,	{ 'd', 'e', 'f', 'i' },	(0+1),			},
	{	0,	{ 'r', 's', 't', 'v' },	(0+1),			},
	{	0,	{ 'w', 'N' },		(0+1),			},
	{	0,	{ '"', '\'' },		((0+28)+3),		},
	{	0,	{ '/' },		(0+12),			},
	{	0,	{ '\n' },		((0+28)+7),			},
	{	0,	{ ' ','\t','\f','\013' },	(0+27),			},

 
	{	(0+1),	{ 023 },		((0+28)+6),		},
	{	(0+1),	{ 021, 001 },	(0+19),			},
	{	(0+1),	{ 'a' },		(0+2),			},
	{	(0+1),	{ 'e' },		(0+3),			},
	{	(0+1),	{ 'f' },		(0+4),			},
	{	(0+1),	{ 'h' },		(0+5),			},
	{	(0+1),	{ 'l' },		(0+6),			},
	{	(0+1),	{ 'n' },		(0+7),			},
	{	(0+1),	{ 'o' },		(0+8),			},
	{	(0+1),	{ 't' },		(0+9),			},
	{	(0+1),	{ 'x' },		(0+10),			},
	{	(0+1),	{ 'y' },		(0+11),			},

 
	{	(0+2),	{ 023 },		(((0+28)+12)),		},
	{	(0+2),	{ 021, 001 },	(0+19),			},
	{	(0+2),	{ '_','s','t','a' },	(0+2),			},
	{	(0+2),	{ 'r' },		(0+2),			},

 
	{	(0+3),	{ 023 },		(((0+28)+12)),		},
	{	(0+3),	{ 021, 001 },	(0+19),			},
	{	(0+3),	{ 't','u','r','n' },	(0+3),			},

 
	{	(0+4),	{ 023 },		(((0+28)+12)),		},
	{	(0+4),	{ 021, 001 },	(0+19),			},

 
	{	(0+5),	{ 023 },		(((0+28)+12)),		},
	{	(0+5),	{ 021, 001 },	(0+19),			},
	{	(0+5),	{ 'i','l','e' },	(0+5),			},

 
	{	(0+6),	{ 023 },		(((0+28)+12)),		},
	{	(0+6),	{ 021, 001 },	(0+19),			},
	{	(0+6),	{ 's','e' },		(0+6),			},

 
	{	(0+7),	{ 023 },		(((0+28)+12)),		},
	{	(0+7),	{ 021, 001 },	(0+19),			},
	{	(0+7),	{ 'l','i','n','e' },	(0+7),			},

 
	{	(0+8),	{ 023 },		(((0+28)+12)),		},
	{	(0+8),	{ 021, 001 },	(0+19),			},
	{	(0+8),	{ 'r','i','d','N' },	(0+8),			},

 
	{	(0+9),	{ 023 },		(((0+28)+12)),		},
	{	(0+9),	{ 021, 001 },	(0+19),			},
	{	(0+9),	{ 'a','t','i','c' },	(0+9),			},

 
	{	(0+10),	{ 023 },		(((0+28)+12)),		},
	{	(0+10),	{ 021, 001 },	(0+19),			},
	{	(0+10),	{ 't','e','r','n' },	(0+10),			},

 
	{	(0+11),	{ 023 },		(((0+28)+12)),		},
	{	(0+11),	{ 021, 001 },	(0+19),			},
	{	(0+11),	{ 'p','e','d','f' },	(0+11),			},

 
	{	(0+12),	{ 023 },		((0+28)+0),			},
	{	(0+12),	{ '*' },		(0+13),			},

	{	(0+12),	{ '/' },		(0+16),			},
 


	{	(0+13),	{ 023 },		(0+13),			},
	{	(0+13),	{ '\n', 002 },	((0+28)+1),		},
	{	(0+13),	{ '/' },		(0+15),			},
	{	(0+13),	{ '*' },		(0+14),			},
	{	(0+13),	{ '#', ';', ')' },	((( (0+13))<<(7+1))|(((0+28)+8))),		},

 
	{	(0+14),	{ 023 },		(0+13),			},
	{	(0+14),	{ '\n', 002 },	((0+28)+1),		},
	{	(0+14),	{ '#', ';', ')' },	((( (0+13))<<(7+1))|(((0+28)+8))),		},
	{	(0+14),	{ '*' },		(0+14),			},
	{	(0+14),	{ '/' },		((0+28)+1),		},

 
	{	(0+15),	{ 023 },		(0+13),			},
	{	(0+15),	{ '*', '\n', 002 },	((0+28)+1),		},
	{	(0+15),	{ '/' },		(0+15),			},

 
	{	(0+16),	{ 023 },		(0+16),			},
	{	(0+16),	{ '\n', 002 },	((0+28)+1),		},
	{	(0+16),	{ '/' },		(0+17),			},
	{	(0+16),	{ '*' },		(0+18),			},

 
	{	(0+17),	{ 023 },		(0+16),			},
	{	(0+17),	{ '*', '\n', 002 },	((0+28)+1),		},
	{	(0+17),	{ '/' },		(0+17),			},

 
	{	(0+18),	{ 023 },		(0+16),			},
	{	(0+18),	{ '\n', 002 },	((0+28)+1),		},
	{	(0+18),	{ '*' },		(0+18),			},
	{	(0+18),	{ '/' },		((0+28)+1),		},

 
	{	(0+19),	{ 023 },		((0+28)+6),		},
	{	(0+19),	{ 021, 001 },	(0+19),			},

 
	{	(0+25),	{ 023 },		((0+28)+0),			},
	{	(0+25),	{ '.' },		(0+26),			},
	{	(0+25),	{ 001 },		(0+23),			},

 
	{	(0+26),	{ 023 },		(((( (0401+1))-0401)<<(7+1))|( ((0+28)+14))),	},
	{	(0+26),	{ '.' },		(((( (0401+29))-0401)<<(7+1))|( ((0+28)+13))),	},

 
	{	(0+20),	{ 023 },		((0+28)+6),		},
	{	(0+20),	{ 021, 001 },	(0+19),			},
	{	(0+20),	{ '"', '\'' },		((( (0+21))<<(7+1))|(((0+28)+8))),		},

 
	{	(0+21),	{ 023 },		(0+21),			},
	{	(0+21),	{ '"', '\'' },		((0+28)+4),		},
	{	(0+21),	{ '\n', 002 },	((0+28)+4),		},
	{	(0+21),	{ '\\' },		(0+22),			},

 
	{	(0+22),	{ 023 },		((0+28)+5),		},
	{	(0+22),	{ '\n', 002 },	((0+28)+4),		},

 
	{	(0+23),	{ 023 },		(((( (0401+1))-0401)<<(7+1))|( ((0+28)+14))),	},
	{	(0+23),	{ 021, 001, '.' },	(0+23),			},
	{	(0+23),	{ 'e', 'E' },		(0+24),			},

 
	{	(0+24),	{ 023 },		(((( (0401+1))-0401)<<(7+1))|( ((0+28)+14))),	},
	{	(0+24),	{ 021, 001, '.' },	(0+23),			},
	{	(0+24),	{ '+', '-' },		(0+23),			},

 
	{	(0+27),	{ 023 },		((0+28)+15),			},
	{	(0+27),	{ ' ', '\t' },		(0+27),			},
	{	(0+27),	{ '\f', '\013' },		((0+28)+10),			},





























































































































































































 
#line 528
	{	(-1),	{ 0 },			0,			}
};

short		_pp_fsmtab[(0+28)+1][255+1];

char		_pp_trigraph[255+1];


static char	spl[] = { '\\', '\r', 0 };
static char	aln[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_$@";




static char*	let = &aln[10];
static char	hex[] = "fedcbaFEDCBA9876543210";
static char*	dec = &hex[12];
static char*	oct = &hex[14];

 




void
ppfsm __PARAM__((int op, register char* s), (op, s)) __OTORP__(int op; register char* s;){
	register int			c;
	register int			n;
	register int			i;
	register short*			rp;
	register struct fsminit*	fp;





	switch (op)
	{





























	case 4:
		for (fp = fsminit;; fp++)
		{
			if ((n = fp->nextstate) >= (0+28)) n = ~n;
			if (fp->state == (-1))
			{













				break;
			}
			rp = _pp_fsmtab[fp->state];
			for (i = 0; i < sizeof(fp->ch) && (c = fp->ch[i]); i++)
			{
				switch (c)
				{
				case 023:
					for (c = 0; c <= 255; c++)
						rp[c] = n;
 

				case 002:
					_pp_fsmtab[(0+28)][fp->state+1] = n < 0 ? ~n : n;
					continue;

				case 021:
					s = let;
					break;

				case 003:
					s = hex;
					break;

				case 001:
					s = dec;
					break;

				case 022:
					s = oct;
					break;

				default:
					rp[c] = n;
					continue;
				}
				while (c = *s++)
					rp[c] = n;
			}
		}

 




		for (i = 0; i < (0+28); i++)
		{
			rp = _pp_fsmtab[i];
			s = spl;
			while (c = *s++)
				if (c != '@' || !(( rp)>=_pp_fsmtab[(0+13)]&&( rp)<=_pp_fsmtab[(0+18)]))
				{
					if (rp[c] >= 0) rp[c] = ~rp[c];
					rp[c] &= ~(1<<7);
				}
			rp[0] = ~((0+28)+2);
			for (c = 0; c <= 255; c++)
				if (rp[c] == i)
					rp[c] = 0;
		}
		_pp_fsmtab[(0+28)][0] = ~((0+28)+2);


















#line 707
		break;










































































































































#line 860
	}
}


















































#line 18 "../../lib/libpp/ppproto.c"

#line 1 "../../../include/ast/hashkey.h"
  
#line 24
                  
 
#line 68
extern __MANGLE__  long	strkey  __PROTO__((const char*));

#line 20 "../../lib/libpp/ppproto.c"

#line 40
struct proto 
{
	int		brace;		 
	int		call;		 
	int		fd;		 
	char*		file;		 
	long		flags;		 
	long		options;	 
	char*		package;	 
	int		line;		 
	int		test;		 

	char*		tp;		 

	int		iz;		 
	char*		ib;		 
	char*		ip;		 

	int		oz;		 
	char*		ob;		 
	char*		op;		 
	char*		ox;		 

	char		cc[3];		 
	char		pushback[4];	 

	char		variadic[256];	    




};

  
#line 162
static char*
number __PARAM__((register char* p, register long n), (p, n)) __OTORP__(register char* p; register long n;){
	register long	d;

	for (d = 1000000; d > 1; d /= 10)
		if (n >= d) *p++ = '0' + (n / d) % 10;
	*p++ = '0' + n % 10;
	return p;
}



static int		errors;

 
#line 193
 



static int
sstrlen __PARAM__((register const char* s), (s)) __OTORP__(register const char* s;){
	register const char*	b;

	for (b = s; *s; s++);
	return s - b;
}

 



static int
sstrncmp __PARAM__((register const char* s, register char* t, register int n), (s, t, n)) __OTORP__(register const char* s; register char* t; register int n;){
	register const char*	e = s + n;

	while (s < e)
	{
		if (*s != *t || !*s)
			return *s - *t;
		s++;
		t++;
	}
	return 0;
}

 



static char*
strcopy __PARAM__((register char* s, register const char* t), (s, t)) __OTORP__(register char* s; register const char* t;){
	while (*s++ = *t++);
	return s - 1;
}



static void
proto_error __PARAM__((char* iob, int level, char* msg, char* arg), (iob, level, msg, arg)) __OTORP__(char* iob; int level; char* msg; char* arg;){
	register char*	p;
	char		buf[1024];

	p = strcopy(buf, "proto: ");
	if (iob)
	{
		register struct proto*	proto = (struct proto*)(iob - sizeof(struct proto));

		if (proto->line)
		{
			if (proto->file)
			{
				*p++ = '"';
				p = strcopy(p, proto->file);
				*p++ = '"';
				*p++ = ',';
				*p++ = ' ';
			}
			p = strcopy(p, "line ");
			p = number(p, proto->line);
		}
		else if (proto->file)
			p = strcopy(p, proto->file);
	}
	else
	{
		p = strcopy(p, msg);
		msg = arg;
		arg = 0;
	}
	if (*(p - 1) != ' ')
	{
		*p++ = ':';
		*p++ = ' ';
	}
	if (level == 1)
		p = strcopy(p, "warning: ");
	p = strcopy(p, msg);
	if (arg)
	{
		*p++ = ' ';
		p = strcopy(p, arg);
	}
	*p++ = '\n';
	write(2, buf, p - buf);
	if (level >= 3)
		exit(level - 2);
	if (level >= 2)
		errors++;
}

 



static char*
memcopy __PARAM__((register char* s, register char* t, int n), (s, t, n)) __OTORP__(register char* s; register char* t; int n;){
	register char*	e = t + n;

	while (t < e) *s++ = *t++;
	return s;
}

#line 1 "../../lib/libast/port/astlicense.c"


 
#line 78
typedef struct Buffer_s
{
	char*		buf;
	char*		nxt;
	char*		end;
	int		siz;
} Buffer_t;

typedef struct Item_s
{
	char*		data;
	int		size;
	int		quote;
} Item_t;

typedef struct Id_s
{
	Item_t		name;
	Item_t		value;
} Id_t;

 





static const Item_t	key[] =
{
	{ "author",sizeof( "author")-1,0},
	{ "class",sizeof( "class")-1,0},
	{ "company",sizeof( "company")-1,0},
	{ "contributor",sizeof( "contributor")-1,0},
	{ "corporation",sizeof( "corporation")-1,0},
	{ "domain",sizeof( "domain")-1,0},
	{ "incorporation",sizeof( "incorporation")-1,0},
	{ "license",sizeof( "license")-1,0},
	{ "location",sizeof( "location")-1,0},
	{ "notice",sizeof( "notice")-1,0},
	{ "organization",sizeof( "organization")-1,0},
	{ "package",sizeof( "package")-1,0},
	{ "parent",sizeof( "parent")-1,0},
	{ "query",sizeof( "query")-1,0},
	{ "since",sizeof( "since")-1,0},
	{ "type",sizeof( "type")-1,0},
	{ "url",sizeof( "url")-1,0},
	{ "urlmd5",sizeof( "urlmd5")-1,0},
	{ "version",sizeof( "version")-1,0},
	{0}
};





static const Item_t	lic[] =
{
	{ "none",sizeof( "none")-1, 0},
	{ "inline",sizeof( "inline")-1, 11},
	{ "test",sizeof( "test")-1, 2},
	{ "verbose",sizeof( "verbose")-1, 3},
	{ "usage",sizeof( "usage")-1, 4},
	{ "open",sizeof( "open")-1, 5},
	{ "cpl",sizeof( "cpl")-1, 5},
	{ "bsd",sizeof( "bsd")-1, 5},
	{ "zlib",sizeof( "zlib")-1, 5},
	{ "mit",sizeof( "mit")-1, 5},
	{ "gpl",sizeof( "gpl")-1, 10},
	{ "special",sizeof( "special")-1, 11},
	{ "nonexclusive",sizeof( "nonexclusive")-1, 11},
	{ "noncommercial",sizeof( "noncommercial")-1, 11},
	{ "proprietary",sizeof( "proprietary")-1, 14},
	{0}
};

typedef struct Notice_s
{
	int		test;
	int		type;
	int		verbose;
	int		ids;
	Item_t		item[(sizeof(key)/sizeof(key[0])-1)];
	Id_t		id[64];
	char		cc[3];
} Notice_t;

 



static int
lookup __PARAM__((register const Item_t* item, const char* name, int size), (item, name, size)) __OTORP__(register const Item_t* item; const char* name; int size;){
	register int	c;
	register int	i;

	c = name[0];
	for (i = 0; item[i].data; i++)
		if (c == item[i].data[0] && size == item[i].size && !sstrncmp( name, item[i].data, size))
			return i;
	return -1;
}

 




static void
copy __PARAM__((register Buffer_t* b, register char* s, int n), (b, s, n)) __OTORP__(register Buffer_t* b; register char* s; int n;){
	if (n < 0)
		n = sstrlen( s);
	while (n--)
		((( b)->nxt<( b)->end)?(*( b)->nxt++=( *s++)):(( *s++),(-1)));
}

 
#line 205
static void
comment __PARAM__((Notice_t* notice, register Buffer_t* b, register char* s, register int n, int u), (notice, b, s, n, u)) __OTORP__(Notice_t* notice; register Buffer_t* b; register char* s; register int n; int u;){
	register int	i;
	register int	m;
	register int	x;
	int		cc;

	cc = notice->cc[1];
	if (!s)
	{
		if (n)
		{
			((( b)->nxt<( b)->end)?(*( b)->nxt++=( notice->cc[n > 0 ? 0 : 1])):(( notice->cc[n > 0 ? 0 : 1]),(-1)));
			for (i = 0; i < 70; i++)
				((( b)->nxt<( b)->end)?(*( b)->nxt++=( cc)):(( cc),(-1)));
			((( b)->nxt<( b)->end)?(*( b)->nxt++=( notice->cc[n > 0 ? 1 : 2])):(( notice->cc[n > 0 ? 1 : 2]),(-1)));
		}
		else
			s = "";
	}
	if (s)
	{
		if (n > 70)
			n = 70;
		((( b)->nxt<( b)->end)?(*( b)->nxt++=( cc)):(( cc),(-1)));
		m = (u < 0) ? 1 : (70 - n) / 2;
		if ((x = 70 - m - n) < 0)
			n--;
		while (m-- > 0)
			((( b)->nxt<( b)->end)?(*( b)->nxt++=( ' ')):(( ' '),(-1)));
		while (n-- > 0)
		{
			i = *s++;
			if (u > 0 && i >= 'a' && i <= 'z')
				i = i - 'a' + 'A';
			((( b)->nxt<( b)->end)?(*( b)->nxt++=( i)):(( i),(-1)));
		}
		while (x-- > 0)
			((( b)->nxt<( b)->end)?(*( b)->nxt++=( ' ')):(( ' '),(-1)));
		((( b)->nxt<( b)->end)?(*( b)->nxt++=( cc)):(( cc),(-1)));
	}
	((( b)->nxt<( b)->end)?(*( b)->nxt++=( '\n')):(( '\n'),(-1)));
}

 



static void
expand __PARAM__((Notice_t* notice, register Buffer_t* b, const Item_t* item), (notice, b, item)) __OTORP__(Notice_t* notice; register Buffer_t* b; const Item_t* item;){
	register char*	t;
	register char*	e;
	register int	q;
	register char*	x;
	register char*	z;
	register int	c;

	if (t = item->data)
	{
		q = item->quote;
		e = t + item->size;
		while (t < e)
		{
			if (*t == '$' && t < (e + 2) && *(t + 1) == '{')
			{
				x = t += 2;
				while (t < e && (c = *t++) != '}')
					if (c == '.')
						x = t;
				if ((c = lookup(key, x, t - x - 1)) >= 0 && (x = notice->item[c].data))
				{
					z = x + notice->item[c].size;
					while (x < z)
						((( b)->nxt<( b)->end)?(*( b)->nxt++=( *x++)):(( *x++),(-1)));
				}
			}
			else if (q > 0 && *t == '\\' && (*(t + 1) == q || *(t + 1) == '\\'))
				t++;
			else
				((( b)->nxt<( b)->end)?(*( b)->nxt++=( *t++)):(( *t++),(-1)));
		}
	}
}

 



static void
copyright __PARAM__((Notice_t* notice, register Buffer_t* b), (notice, b)) __OTORP__(Notice_t* notice; register Buffer_t* b;){
	register char*	x;
	register char*	t;
	time_t		clock;

	copy(b, "Copyright (c) ", -1);
	if (notice->test)
		clock = (time_t)1000212300;
	else
		time(&clock);
	t = ctime(&clock) + 20;
	if ((x = notice->item[14].data) && sstrncmp( x, t, 4))
	{
		expand(notice, b, &notice->item[14]);
		((( b)->nxt<( b)->end)?(*( b)->nxt++=( '-')):(( '-'),(-1)));
	}
	copy(b, t, 4);
	if (notice->item[12].data)
	{
		((( b)->nxt<( b)->end)?(*( b)->nxt++=( ' ')):(( ' '),(-1)));
		expand(notice, b, &notice->item[12]);
	}
	if (notice->item[4].data)
	{
		((( b)->nxt<( b)->end)?(*( b)->nxt++=( ' ')):(( ' '),(-1)));
		expand(notice, b, &notice->item[4]);
		if (notice->item[6].data)
		{
			((( b)->nxt<( b)->end)?(*( b)->nxt++=( ' ')):(( ' '),(-1)));
			expand(notice, b, &notice->item[6]);
		}
	}
	else if (notice->item[2].data)
	{
		((( b)->nxt<( b)->end)?(*( b)->nxt++=( ' ')):(( ' '),(-1)));
		expand(notice, b, &notice->item[2]);
	}
}

 





int
astlicense __PARAM__((char* p, int size, char* file, char* options, int cc1, int cc2, int cc3), (p, size, file, options, cc1, cc2, cc3)) __OTORP__(char* p; int size; char* file; char* options; int cc1; int cc2; int cc3;){
	register char*	s;
	register char*	v;
	register char*	x;
	register int	c;
	int		i;
	int		h;
	int		k;
	int		n;
	int		q;
	int		contributor;
	int		first;
	int		line;
	int		quote;
	char		tmpbuf[(70+4)];
	char		info[8 * 1024];
	Notice_t	notice;
	Item_t		item;
	Buffer_t	buf;
	Buffer_t	tmp;

	buf.end = (buf.buf = buf.nxt = p) + size;
	tmp.end = (tmp.buf = tmp.nxt = tmpbuf) + sizeof(tmpbuf);
	if (file && *file)
	{
		if ((i = open(file, O_RDONLY)) < 0)
		{
			copy(&buf, file, -1);
			copy(&buf, ": cannot open", -1);
			((( &buf)->nxt<( &buf)->end)?(*( &buf)->nxt++=( 0)):(( 0),(-1)));
			return -1;
		}
		n = read(i, info, sizeof(info) - 1);
		close(i);
		if (n < 0)
		{
			copy(&buf, file, -1);
			copy(&buf, ": cannot read", -1);
			((( &buf)->nxt<( &buf)->end)?(*( &buf)->nxt++=( 0)):(( 0),(-1)));
			return -1;
		}
		s = info;
		s[n] = 0;
	}
	else if (!options)
		return 0;
	else
	{
		s = options;
		options = 0;
	}
	notice.test = 0;
	notice.type = 0;
	notice.verbose = 0;
	notice.ids = 0;
	notice.cc[0] = cc1;
	notice.cc[1] = cc2;
	notice.cc[2] = cc3;
	for (i = 0; i < (sizeof(key)/sizeof(key[0])-1); i++)
		notice.item[i].data = 0;
	notice.item[15] = notice.item[1] = lic[notice.type];
	notice.item[15].quote = notice.item[1].quote = 0;
	contributor = i = k = 0;
	line = 0;
	for (;;)
	{
		for (first = 1; c = *s; first = 0)
		{
			while (c == ' ' || c == '\t' || c == '\n' && ++line || c == '\r' || c == ',' || c == ';' || c == ')')
				c = *++s;
			if (!c)
				break;
			if (c == '#')
			{
				while (*++s && *s != '\n');
				if (*s)
					s++;
				line++;
				continue;
			}
			if (c == '\n')
			{
				s++;
				line++;
				continue;
			}
			if (c == '[')
				c = *++s;
			x = s;
			n = 0;
			while (c && c != '=' && c != ']' && c != ')' && c != ',' && c != ' ' && c != '\t' && c != '\n' && c != '\r')
				c = *++s;
			n = s - x;
			h = lookup(key, x, n);
			if (c == ']')
				c = *++s;
			if (c == '=' || first)
			{
				if (c == '=')
				{
					q = ((c = *++s) == '"' || c == '\'') ? *s++ : 0;
					if (c == '(')
					{
						s++;
						if (h == 7)
							contributor = 0;
						else if (h == 3)
							contributor = 1;
						else
						{
							q = 1;
							i = 0;
							for (;;)
							{
								switch (*s++)
								{
								case 0:
									s--;
									break;
								case '(':
									if (!i)
										q++;
									continue;
								case ')':
									if (!i && !--q)
										break;
									continue;
								case '"':
								case '\'':
									if (!i)
										i = *(s - 1);
									else if (i == *(s - 1))
										i = 0;
									continue;
								case '\\':
									if (*s == i && i == '"')
										i++;
									continue;
								case '\n':
									line++;
									continue;
								default:
									continue;
								}
								break;
							}
						}
						continue;
					}
					quote = 0;
					v = s;
					while ((c = *s) && (q == '"' && (c == '\\' && (*(s + 1) == '"' || *(s + 1) == '\\') && s++ && (quote = q)) || q && c != q || !q && c != ' ' && c != '\t' && c != '\n' && c != '\r' && c != ',' && c != ';'))
					{
						if (c == '\n')
							line++;
						s++;
					}
				}
				else
				{
					h = 15;
					v = x;
				}
				if (c == '\n')
					line++;
				if (contributor)
				{
					for (i = 0; i < notice.ids; i++)
						if (n == notice.id[i].name.size && !sstrncmp( x, notice.id[i].name.data, n))
							break;
					if (i < 64)
					{
						notice.id[i].name.data = x;
						notice.id[i].name.size = n;
						notice.id[i].name.quote = 0;
						notice.id[i].value.data = v;
						notice.id[i].value.size = s - v;
						notice.id[i].value.quote = quote;
						if (notice.ids <= i)
							notice.ids = i + 1;
					}
				}
				else if (h == 13)
				{
					if ((s - v) == 3 && v[0] == 'a' && v[1] == 'l' && v[2] == 'l')
					{
						for (i = 0; i < (sizeof(key)/sizeof(key[0])-1); i++)
							if (notice.item[i].size)
							{
								expand(&notice, &buf, &key[i]);
								((( &buf)->nxt<( &buf)->end)?(*( &buf)->nxt++=( '=')):(( '='),(-1)));
								for (h = 0;; h++)
									if (h >= notice.item[i].size)
									{
										h = 0;
										break;
									}
									else if (notice.item[i].data[h] == ' ' || notice.item[i].data[h] == '\t')
										break;
								if (h)
									((( &buf)->nxt<( &buf)->end)?(*( &buf)->nxt++=( '\'')):(( '\''),(-1)));
								expand(&notice, &buf, &notice.item[i]);
								if (h)
									((( &buf)->nxt<( &buf)->end)?(*( &buf)->nxt++=( '\'')):(( '\''),(-1)));
								((( &buf)->nxt<( &buf)->end)?(*( &buf)->nxt++=( '\n')):(( '\n'),(-1)));
							}
					}
					else
					{
						if ((h = lookup(key, v, s - v)) < 0)
						{
							item.data = v;
							item.size = s - v;
							item.quote = 0;
							expand(&notice, &buf, &item);
						}
						else
							expand(&notice, &buf, &notice.item[h]);
						((( &buf)->nxt<( &buf)->end)?(*( &buf)->nxt++=( '\n')):(( '\n'),(-1)));
					}
					return (*(( &buf)->nxt>=( &buf)->end?(( &buf)->nxt=( &buf)->end-1):( &buf)->nxt)=0,( &buf)->nxt-( &buf)->buf);
				}
				else
				{
					if (h == 15)
						switch (c = lookup(lic, v, s - v))
						{
						case 0:
							return 0;
						case 2:
							notice.test = 1;
							h = -1;
							break;
						case 3:
							notice.verbose = 1;
							h = -1;
							break;
						case 4:
							notice.type = c;
							h = -1;
							break;
						case -1:
							c = 11;
 
						default:
							notice.type = c;
							notice.item[1].data = lic[lic[c].quote].data;
							notice.item[1].size = lic[lic[c].quote].size;
							break;
						}
					if (h >= 0)
					{
						notice.item[h].data = (notice.item[h].size = s - v) ? v : (char*)0;
						notice.item[h].quote = quote;
						k = 1;
					}
				}
			}
			else
			{
				if (file)
				{
					copy(&buf, "\"", -1);
					copy(&buf, file, -1);
					copy(&buf, "\", line ", -1);
					x = &tmpbuf[sizeof(tmpbuf)];
					*--x = 0;
					line++;
					do *--x = ("0123456789")[line % 10]; while (line /= 10);
					copy(&buf, x, -1);
					copy(&buf, ": ", -1);
				}
				copy(&buf, "option error: assignment expected", -1);
				((( &buf)->nxt<( &buf)->end)?(*( &buf)->nxt++=( 0)):(( 0),(-1)));
				return -1;
			}
			if (*s)
				s++;
		}
		if (!options || !*(s = options))
			break;
		options = 0;
	}
	if (!k)
		return 0;
	if (notice.type == 1 && (!notice.verbose || !notice.item[9].data))
		return 0;
	if (notice.type != 4)
	{
		if (!notice.type)
			notice.type = 11;
		comment(&notice, &buf, ((char*)0), 1, 0);
		comment(&notice, &buf, ((char*)0), 0, 0);
		if (notice.item[11].data)
		{
			copy(&tmp, "This software is part of the ", -1);
			expand(&notice, &tmp, &notice.item[11]);
			copy(&tmp, " package", -1);
			comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
		}
		if (notice.type >= 5)
		{
			copyright(&notice, &tmp);
			comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
			if (notice.type >= 11)
				comment( &notice, &buf, "All Rights Reserved",sizeof( "All Rights Reserved")-1, 0);
		}
		if (notice.type == 6)
		{
			copy(&tmp, notice.item[11].data ? "and": "This software", -1);
			copy(&tmp, " is licensed under the", -1);
			comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
			copy(&tmp, "Common Public License", -1);
			if (notice.item[18].data)
			{
				copy(&tmp, ", Version ", -1);
				expand(&notice, &tmp, &notice.item[18]);
			}
			comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
			if (notice.item[4].data || notice.item[2].data)
			{
				copy(&tmp, "by ", -1);
				if (notice.item[12].data)
				{
					expand(&notice, &tmp, &notice.item[12]);
					copy(&tmp, " ", -1);
				}
				if (notice.item[4].data)
				{
					expand(&notice, &tmp, &notice.item[4]);
					if (notice.item[6].data)
					{
						copy(&tmp, " ", -1);
						expand(&notice, &tmp, &notice.item[6]);
					}
				}
				else if (notice.item[2].data)
					expand(&notice, &tmp, &notice.item[2]);
				comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
			}
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, "A copy of the License is available at",sizeof( "A copy of the License is available at")-1, 0);
			if (notice.item[16].data)
			{
				expand(&notice, &tmp, &notice.item[16]);
				comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
				if (notice.item[17].data)
				{
					copy(&tmp, "(with md5 checksum ", -1);
					expand(&notice, &tmp, &notice.item[17]);
					copy(&tmp, ")", -1);
					comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
				}
			}
			else
				comment( &notice, &buf, "http://www.opensource.org/licenses/cpl",sizeof( "http://www.opensource.org/licenses/cpl")-1, 0);
			comment(&notice, &buf, ((char*)0), 0, 0);
		}
		else if (notice.type == 5)
		{
			copy(&tmp, notice.item[11].data ? "and it": "This software", -1);
			copy(&tmp, " may only be used by you under license from", -1);
			comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
			if (notice.item[i = 4].data)
			{
				if (notice.item[12].data)
				{
					expand(&notice, &tmp, &notice.item[i = 12]);
					copy(&tmp, " ", -1);
				}
				expand(&notice, &tmp, &notice.item[4]);
				comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
			}
			else if (notice.item[i = 2].data)
			{
				if (notice.item[12].data)
				{
					expand(&notice, &tmp, &notice.item[i = 12]);
					copy(&tmp, " ", -1);
				}
				expand(&notice, &tmp, &notice.item[2]);
				comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
			}
			else
				i = -1;
			if (notice.item[16].data)
			{
				comment( &notice, &buf, "A copy of the Source Code Agreement is available",sizeof( "A copy of the Source Code Agreement is available")-1, 0);
				copy(&tmp, "at the ", -1);
				if (i >= 0)
					expand(&notice, &tmp, &notice.item[i]);
				copy(&tmp, " Internet web site URL", -1);
				comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
				comment(&notice, &buf, ((char*)0), 0, 0);
				expand(&notice, &tmp, &notice.item[16]);
				comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
				if (notice.item[17].data)
				{
					copy(&tmp, "(with an md5 checksum of ", -1);
					expand(&notice, &tmp, &notice.item[17]);
					copy(&tmp, ")", -1);
					comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
				}
				comment(&notice, &buf, ((char*)0), 0, 0);
			}
			comment( &notice, &buf, "If you have copied or used this software without agreeing",sizeof( "If you have copied or used this software without agreeing")-1, 0);
			comment( &notice, &buf, "to the terms of the license you are infringing on",sizeof( "to the terms of the license you are infringing on")-1, 0);
			comment( &notice, &buf, "the license and copyright and are violating",sizeof( "the license and copyright and are violating")-1, 0);
			if (i >= 0)
				expand(&notice, &tmp, &notice.item[i]);
			copy(&tmp, "'s", -1);
			if (n >= (70-32))
				comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
			else
				((( &tmp)->nxt<( &tmp)->end)?(*( &tmp)->nxt++=( ' ')):(( ' '),(-1)));
			copy(&tmp, "intellectual property rights.", -1);
			comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
			comment(&notice, &buf, ((char*)0), 0, 0);
		}
		else if (notice.type == 10)
		{
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, "This is free software; you can redistribute it and/or",sizeof( "This is free software; you can redistribute it and/or")-1, 0);
			comment( &notice, &buf, "modify it under the terms of the GNU General Public License",sizeof( "modify it under the terms of the GNU General Public License")-1, 0);
			comment( &notice, &buf, "as published by the Free Software Foundation;",sizeof( "as published by the Free Software Foundation;")-1, 0);
			comment( &notice, &buf, "either version 2, or (at your option) any later version.",sizeof( "either version 2, or (at your option) any later version.")-1, 0);
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, "This software is distributed in the hope that it",sizeof( "This software is distributed in the hope that it")-1, 0);
			comment( &notice, &buf, "will be useful, but WITHOUT ANY WARRANTY;",sizeof( "will be useful, but WITHOUT ANY WARRANTY;")-1, 0);
			comment( &notice, &buf, "without even the implied warranty of MERCHANTABILITY",sizeof( "without even the implied warranty of MERCHANTABILITY")-1, 0);
			comment( &notice, &buf, "or FITNESS FOR A PARTICULAR PURPOSE.",sizeof( "or FITNESS FOR A PARTICULAR PURPOSE.")-1, 0);
			comment( &notice, &buf, "See the GNU General Public License for more details.",sizeof( "See the GNU General Public License for more details.")-1, 0);
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, "You should have received a copy of the",sizeof( "You should have received a copy of the")-1, 0);
			comment( &notice, &buf, "GNU General Public License",sizeof( "GNU General Public License")-1, 0);
			comment( &notice, &buf, "along with this software (see the file COPYING.)",sizeof( "along with this software (see the file COPYING.)")-1, 0);
			comment( &notice, &buf, "If not, a copy is available at",sizeof( "If not, a copy is available at")-1, 0);
			comment( &notice, &buf, "http://www.gnu.org/copyleft/gpl.html",sizeof( "http://www.gnu.org/copyleft/gpl.html")-1, 0);
			comment(&notice, &buf, ((char*)0), 0, 0);
		}
		else if (notice.type == 7)
		{
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, "Redistribution and use in source and binary forms, with or",sizeof( "Redistribution and use in source and binary forms, with or")-1, -1);
			comment( &notice, &buf, "without modification, are permitted provided that the following",sizeof( "without modification, are permitted provided that the following")-1, -1);
			comment( &notice, &buf, "conditions are met:",sizeof( "conditions are met:")-1, -1);
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, "   1. Redistributions of source code must retain the above",sizeof( "   1. Redistributions of source code must retain the above")-1, -1);
			comment( &notice, &buf, "      copyright notice, this list of conditions and the",sizeof( "      copyright notice, this list of conditions and the")-1, -1);
			comment( &notice, &buf, "      following disclaimer.",sizeof( "      following disclaimer.")-1, -1);
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, "   2. Redistributions in binary form must reproduce the above",sizeof( "   2. Redistributions in binary form must reproduce the above")-1, -1);
			comment( &notice, &buf, "      copyright notice, this list of conditions and the",sizeof( "      copyright notice, this list of conditions and the")-1, -1);
			comment( &notice, &buf, "      following disclaimer in the documentation and/or other",sizeof( "      following disclaimer in the documentation and/or other")-1, -1);
			comment( &notice, &buf, "      materials provided with the distribution.",sizeof( "      materials provided with the distribution.")-1, -1);
			comment(&notice, &buf, ((char*)0), 0, 0);
			copy(&tmp, "   3. Neither the name of ", -1);
			if (notice.item[i = 12].data || notice.item[i = 4].data || notice.item[i = 2].data)
				expand(&notice, &tmp, &notice.item[i]);
			else
				copy(&tmp, "the copyright holder", -1);
			copy(&tmp, " nor the", -1);
			comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), -1);
			comment( &notice, &buf, "      names of its contributors may be used to endorse or",sizeof( "      names of its contributors may be used to endorse or")-1, -1);
			comment( &notice, &buf, "      promote products derived from this software without",sizeof( "      promote products derived from this software without")-1, -1);
			comment( &notice, &buf, "      specific prior written permission.",sizeof( "      specific prior written permission.")-1, -1);
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND",sizeof( "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND")-1, -1);
			comment( &notice, &buf, "CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES,",sizeof( "CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES,")-1, -1);
			comment( &notice, &buf, "INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF",sizeof( "INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF")-1, -1);
			comment( &notice, &buf, "MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE",sizeof( "MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE")-1, -1);
			comment( &notice, &buf, "DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS",sizeof( "DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS")-1, -1);
			comment( &notice, &buf, "BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,",sizeof( "BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,")-1, -1);
			comment( &notice, &buf, "EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED",sizeof( "EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED")-1, -1);
			comment( &notice, &buf, "TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,",sizeof( "TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,")-1, -1);
			comment( &notice, &buf, "DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON",sizeof( "DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON")-1, -1);
			comment( &notice, &buf, "ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,",sizeof( "ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,")-1, -1);
			comment( &notice, &buf, "OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY",sizeof( "OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY")-1, -1);
			comment( &notice, &buf, "OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE",sizeof( "OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE")-1, -1);
			comment( &notice, &buf, "POSSIBILITY OF SUCH DAMAGE.",sizeof( "POSSIBILITY OF SUCH DAMAGE.")-1, -1);
			comment(&notice, &buf, ((char*)0), 0, 0);
		}
		else if (notice.type == 8)
		{
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, "This software is provided 'as-is', without any express or implied",sizeof( "This software is provided 'as-is', without any express or implied")-1, -1);
			comment( &notice, &buf, "warranty. In no event will the authors be held liable for any",sizeof( "warranty. In no event will the authors be held liable for any")-1, -1);
			comment( &notice, &buf, "damages arising from the use of this software.",sizeof( "damages arising from the use of this software.")-1, -1);
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, "Permission is granted to anyone to use this software for any",sizeof( "Permission is granted to anyone to use this software for any")-1, -1);
			comment( &notice, &buf, "purpose, including commercial applications, and to alter it and",sizeof( "purpose, including commercial applications, and to alter it and")-1, -1);
			comment( &notice, &buf, "redistribute it freely, subject to the following restrictions:",sizeof( "redistribute it freely, subject to the following restrictions:")-1, -1);
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, " 1. The origin of this software must not be misrepresented;",sizeof( " 1. The origin of this software must not be misrepresented;")-1, -1);
			comment( &notice, &buf, "    you must not claim that you wrote the original software. If",sizeof( "    you must not claim that you wrote the original software. If")-1, -1);
			comment( &notice, &buf, "    you use this software in a product, an acknowledgment in the",sizeof( "    you use this software in a product, an acknowledgment in the")-1, -1);
			comment( &notice, &buf, "    product documentation would be appreciated but is not",sizeof( "    product documentation would be appreciated but is not")-1, -1);
			comment( &notice, &buf, "    required.",sizeof( "    required.")-1, -1);
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, " 2. Altered source versions must be plainly marked as such,",sizeof( " 2. Altered source versions must be plainly marked as such,")-1, -1);
			comment( &notice, &buf, "    and must not be misrepresented as being the original",sizeof( "    and must not be misrepresented as being the original")-1, -1);
			comment( &notice, &buf, "    software.",sizeof( "    software.")-1, -1);
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, " 3. This notice may not be removed or altered from any source",sizeof( " 3. This notice may not be removed or altered from any source")-1, -1);
			comment( &notice, &buf, "    distribution.",sizeof( "    distribution.")-1, -1);
			comment(&notice, &buf, ((char*)0), 0, 0);
		}
		else if (notice.type == 9)
		{
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, "Permission is hereby granted, free of charge, to any person",sizeof( "Permission is hereby granted, free of charge, to any person")-1, 0);
			comment( &notice, &buf, "obtaining a copy of this software and associated",sizeof( "obtaining a copy of this software and associated")-1, 0);
			comment( &notice, &buf, "documentation files (the \"Software\"), to deal in the",sizeof( "documentation files (the \"Software\"), to deal in the")-1, 0);
			comment( &notice, &buf, "Software without restriction, including without limitation",sizeof( "Software without restriction, including without limitation")-1, 0);
			comment( &notice, &buf, "the rights to use, copy, modify, merge, publish, distribute,",sizeof( "the rights to use, copy, modify, merge, publish, distribute,")-1, 0);
			comment( &notice, &buf, "sublicense, and/or sell copies of the Software, and to",sizeof( "sublicense, and/or sell copies of the Software, and to")-1, 0);
			comment( &notice, &buf, "permit persons to whom the Software is furnished to do so,",sizeof( "permit persons to whom the Software is furnished to do so,")-1, 0);
			comment( &notice, &buf, "subject to the following conditions:",sizeof( "subject to the following conditions:")-1, 0);
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, "The above copyright notice and this permission notice shall",sizeof( "The above copyright notice and this permission notice shall")-1, 0);
			comment( &notice, &buf, "be included in all copies or substantial portions of the",sizeof( "be included in all copies or substantial portions of the")-1, 0);
			comment( &notice, &buf, "Software.",sizeof( "Software.")-1, 0);
			comment(&notice, &buf, ((char*)0), 0, 0);
			comment( &notice, &buf, "THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY",sizeof( "THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY")-1, 0);
			comment( &notice, &buf, "KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE",sizeof( "KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE")-1, 0);
			comment( &notice, &buf, "WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR",sizeof( "WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR")-1, 0);
			comment( &notice, &buf, "PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS",sizeof( "PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS")-1, 0);
			comment( &notice, &buf, "OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR",sizeof( "OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR")-1, 0);
			comment( &notice, &buf, "OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR",sizeof( "OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR")-1, 0);
			comment( &notice, &buf, "OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE",sizeof( "OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE")-1, 0);
			comment( &notice, &buf, "SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.",sizeof( "SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.")-1, 0);
			comment(&notice, &buf, ((char*)0), 0, 0);
		}
		else
		{
			if (notice.type == 14)
			{
				if (notice.item[i = 12].data || notice.item[i = 4].data || notice.item[i = 2].data)
				{
					expand(&notice, &tmp, &notice.item[i]);
					copy(&tmp, " - ", -1);
				}
				else
					i = -1;
				copy(&tmp, "Proprietary", -1);
				comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 1);
				comment(&notice, &buf, ((char*)0), 0, 0);
				if (notice.item[16].data)
				{
					copy(&tmp, "This is proprietary source code", -1);
					if (i >= 0)
						copy(&tmp, " licensed by", -1);
					comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 1);
					if (notice.item[12].data)
					{
						expand(&notice, &tmp, &notice.item[12]);
						copy(&tmp, " ", -1);
					}
					if (notice.item[4].data)
					{
						expand(&notice, &tmp, &notice.item[4]);
						comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 1);
					}
					else if (notice.item[2].data)
					{
						expand(&notice, &tmp, &notice.item[2]);
						comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 1);
					}
				}
				else
				{
					copy(&tmp, "This is unpublished proprietary source code", -1);
					if (i >= 0)
						copy(&tmp, " of", -1);
					comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 1);
					if (notice.item[i = 12].data || notice.item[i = 4].data)
						expand(&notice, &tmp, &notice.item[i]);
					if (notice.item[2].data)
					{
						if ((( &tmp)->nxt-( &tmp)->buf))
							((( &tmp)->nxt<( &tmp)->end)?(*( &tmp)->nxt++=( ' ')):(( ' '),(-1)));
						expand(&notice, &tmp, &notice.item[2]);
					}
					if ((( &tmp)->nxt-( &tmp)->buf))
						comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 1);
					comment( &notice, &buf, "and is not to be disclosed or used except in",sizeof( "and is not to be disclosed or used except in")-1, 1);
					comment( &notice, &buf, "accordance with applicable agreements",sizeof( "accordance with applicable agreements")-1, 1);
				}
				comment(&notice, &buf, ((char*)0), 0, 0);
			}
			else if (notice.type == 12)
			{
				comment( &notice, &buf, "For nonexclusive individual use",sizeof( "For nonexclusive individual use")-1, 1);
				comment(&notice, &buf, ((char*)0), 0, 0);
			}
			else if (notice.type == 13)
			{
				comment( &notice, &buf, "For noncommercial use",sizeof( "For noncommercial use")-1, 1);
				comment(&notice, &buf, ((char*)0), 0, 0);
			}
			if (notice.type >= 14 && !notice.item[16].data)
			{
				comment( &notice, &buf, "Unpublished & Not for Publication",sizeof( "Unpublished & Not for Publication")-1, 0);
				comment(&notice, &buf, ((char*)0), 0, 0);
			}
			if (notice.item[16].data)
			{
				copy(&tmp, "This software is licensed", -1);
				if (notice.item[4].data || notice.item[2].data)
				{
					copy(&tmp, " by", -1);
					if ((notice.item[12].size + (notice.item[4].data ? (notice.item[4].size + notice.item[6].size) : notice.item[2].size)) >= ((70-32) - 6))
						comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
					else
						((( &tmp)->nxt<( &tmp)->end)?(*( &tmp)->nxt++=( ' ')):(( ' '),(-1)));
					if (notice.item[12].data)
					{
						expand(&notice, &tmp, &notice.item[12]);
						copy(&tmp, " ", -1);
					}
					if (notice.item[4].data)
					{
						expand(&notice, &tmp, &notice.item[4]);
						if (notice.item[6].data)
						{
							copy(&tmp, " ", -1);
							expand(&notice, &tmp, &notice.item[6]);
						}
					}
					else if (notice.item[2].data)
						expand(&notice, &tmp, &notice.item[2]);
				}
				comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
				comment( &notice, &buf, "under the terms and conditions of the license in",sizeof( "under the terms and conditions of the license in")-1, 0);
				expand(&notice, &tmp, &notice.item[16]);
				comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
				if (notice.item[17].data)
				{
					copy(&tmp, "(with an md5 checksum of ", -1);
					expand(&notice, &tmp, &notice.item[17]);
					copy(&tmp, ")", -1);
					comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
				}
				comment(&notice, &buf, ((char*)0), 0, 0);
			}
			else if (notice.type == 14)
			{
				comment( &notice, &buf, "The copyright notice above does not evidence any",sizeof( "The copyright notice above does not evidence any")-1, 0);
				comment( &notice, &buf, "actual or intended publication of such source code",sizeof( "actual or intended publication of such source code")-1, 0);
				comment(&notice, &buf, ((char*)0), 0, 0);
			}
		}
		if (v = notice.item[9].data)
		{
			x = v + notice.item[9].size;
			if (*v == '\n')
				v++;
			item.quote = notice.item[9].quote;
			do
			{
				for (item.data = v; v < x && *v != '\n'; v++);
				if ((item.size = v - item.data) && *item.data == '\t')
				{
					item.data++;
					item.size--;
					h = 0;
				}
				else
					h = -1;
				expand(&notice, &tmp, &item);
				comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), h);
			} while (v++ < x);
			if (item.size)
				comment(&notice, &buf, ((char*)0), 0, 0);
		}
		if (notice.item[10].data)
		{
			expand(&notice, &tmp, &notice.item[10]);
			comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
			if (notice.item[i = 12].data || notice.item[i = 4].data)
				expand(&notice, &tmp, &notice.item[i]);
			if (notice.item[2].data)
			{
				if ((( &tmp)->nxt-( &tmp)->buf))
					((( &tmp)->nxt<( &tmp)->end)?(*( &tmp)->nxt++=( ' ')):(( ' '),(-1)));
				expand(&notice, &tmp, &notice.item[2]);
			}
			if ((( &tmp)->nxt-( &tmp)->buf))
				comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
			if (notice.item[8].data)
			{
				expand(&notice, &tmp, &notice.item[8]);
				comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
			}
			comment(&notice, &buf, ((char*)0), 0, 0);
		}
	}
	if (v = notice.item[0].data)
	{
		x = v + notice.item[0].size;
		q = (x - v) == 1 && (*v == '*' || *v == '-');
		k = q && notice.type != 4 ? -1 : 0;
		for (;;)
		{
			if (!q)
			{
				while (v < x && (*v == ' ' || *v == '\t' || *v == '\r' || *v == '\n' || *v == ',' || *v == '+'))
					v++;
				if (v >= x)
					break;
				item.data = v;
				while (v < x && *v != ',' && *v != '+' && *v++ != '>');
				item.size = v - item.data;
				item.quote = notice.item[0].quote;
			}
			h = 0;
			for (i = 0; i < notice.ids; i++)
				if (q || item.size == notice.id[i].name.size && !sstrncmp( item.data, notice.id[i].name.data, item.size))
				{
					h = 1;
					if (notice.type == 4)
					{
						copy(&buf, "[-author?", -1);
						expand(&notice, &buf, &notice.id[i].value);
						((( &buf)->nxt<( &buf)->end)?(*( &buf)->nxt++=( ']')):(( ']'),(-1)));
					}
					else
					{
						if (k < 0)
						{
							comment( &notice, &buf, "CONTRIBUTORS",sizeof( "CONTRIBUTORS")-1, 0);
							comment(&notice, &buf, ((char*)0), 0, 0);
						}
						k = 1;
						expand(&notice, &tmp, &notice.id[i].value);
						comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
					}
					if (!q)
						break;
				}
			if (q)
				break;
			if (!h)
			{
				if (notice.type == 4)
				{
					copy(&buf, "[-author?", -1);
					expand(&notice, &buf, &item);
					((( &buf)->nxt<( &buf)->end)?(*( &buf)->nxt++=( ']')):(( ']'),(-1)));
				}
				else
				{
					if (k < 0)
					{
						comment( &notice, &buf, "CONTRIBUTORS",sizeof( "CONTRIBUTORS")-1, 0);
						comment(&notice, &buf, ((char*)0), 0, 0);
					}
					k = 1;
					expand(&notice, &tmp, &item);
					comment(&notice, &buf, (( &tmp)->buf), (( &tmp)->siz=( &tmp)->nxt-( &tmp)->buf,( &tmp)->nxt=( &tmp)->buf,( &tmp)->siz), 0);
				}
			}
		}
		if (k > 0)
			comment(&notice, &buf, ((char*)0), 0, 0);
	}
	if (notice.type == 4)
	{
		copy(&buf, "[-copyright?", -1);
		copyright(&notice, &buf);
		((( &buf)->nxt<( &buf)->end)?(*( &buf)->nxt++=( ']')):(( ']'),(-1)));
		if (notice.item[16].data)
		{
			copy(&buf, "[-license?", -1);
			expand(&notice, &buf, &notice.item[16]);
			((( &buf)->nxt<( &buf)->end)?(*( &buf)->nxt++=( ']')):(( ']'),(-1)));
		}
		((( &buf)->nxt<( &buf)->end)?(*( &buf)->nxt++=( '\n')):(( '\n'),(-1)));
	}
	else
		comment(&notice, &buf, ((char*)0), -1, 0);
	return (*(( &buf)->nxt>=( &buf)->end?(( &buf)->nxt=( &buf)->end-1):( &buf)->nxt)=0,( &buf)->nxt-( &buf)->buf);
}
#line 305 "../../lib/libpp/ppproto.c"
 
#line 317
static char*
linesync __PARAM__((register struct proto* proto, register char* p, register long n), (proto, p, n)) __OTORP__(register struct proto* proto; register char* p; register long n;){

	if (proto->flags & (1L<<13))

	{

		p = strcopy(p, "\n#line ");



		p = number(p, n);
		*p++ = '\n';
	}
	return p;
}

 




static char*
init __PARAM__((struct proto* proto, char* op, int flags), (proto, op, flags)) __OTORP__(struct proto* proto; char* op; int flags;){
	register char*	s;

	if (flags & (1L<<10))
	{
		op = strcopy(op, "\
\n\
#if !defined(__PROTO__)\n\
#  if defined(__STDC__) || defined(__cplusplus) || defined(_proto) || defined(c_plusplus)\n\
#    if defined(__cplusplus)\n\
#      define __LINKAGE__	\"C\"\n\
#    else\n\
#      define __LINKAGE__\n\
#    endif\n\
#    define __STDARG__\n\
#    define __PROTO__(x)	x\n\
#    define __OTORP__(x)\n\
#    define __PARAM__(n,o)	n\n\
#    if !defined(__STDC__) && !defined(__cplusplus)\n\
#      if !defined(c_plusplus)\n\
#      	define const\n\
#      endif\n\
#      define signed\n\
#      define void		int\n\
#      define volatile\n\
#      define __V_		char\n\
#    else\n\
#      define __V_		void\n\
#    endif\n\
#  else\n\
#    define __PROTO__(x)	()\n\
#    define __OTORP__(x)	x\n\
#    define __PARAM__(n,o)	o\n\
#    define __LINKAGE__\n\
#    define __V_		char\n\
#    define const\n\
#    define signed\n\
#    define void		int\n\
#    define volatile\n\
#  endif\n\
#  define __MANGLE__	__LINKAGE__\n\
#  if defined(__cplusplus) || defined(c_plusplus)\n\
#    define __VARARG__	...\n\
#  else\n\
#    define __VARARG__\n\
#  endif\n\
#  if defined(__STDARG__)\n\
#    define __VA_START__(p,a)	va_start(p,a)\n\
#  else\n\
#    define __VA_START__(p,a)	va_start(p)\n\
#  endif\n\
#  if !defined(__INLINE__)\n\
#    if defined(__cplusplus)\n\
#      define __INLINE__	extern __MANGLE__ inline\n\
#    else\n\
#      if defined(_WIN32) && !defined(__GNUC__)\n\
#      	define __INLINE__	__inline\n\
#      endif\n\
#    endif\n\
#  endif\n\
#endif\n\
#if !defined(__LINKAGE__)\n\
#define __LINKAGE__		/* 2004-08-11 transition */\n\
#endif\n\
");
	}
	else
		op = strcopy(op, "\
\n\
#if !defined(__PROTO__)\n\
#include <prototyped.h>\n\
#endif\n\
#if !defined(__LINKAGE__)\n\
#define __LINKAGE__		/* 2004-08-11 transition */\n\
#endif\n\
");
	if (proto->package)
	{
		s = "\
#ifndef	__MANGLE_%_DATA__\n\
#  ifdef _BLD_%\n\
#    ifdef __EXPORT__\n\
#      define	__MANGLE_%_DATA__	__MANGLE__ __EXPORT__\n\
#    else\n\
#      define	__MANGLE_%_DATA__	__MANGLE__\n\
#    endif\n\
#    define	__MANGLE_%_FUNC__	__MANGLE__\n\
#  else\n\
#    ifdef __IMPORT__\n\
#      define	__MANGLE_%_DATA__	__MANGLE__ __IMPORT__\n\
#    else\n\
#      define	__MANGLE_%_DATA__	__MANGLE__\n\
#    endif\n\
#    define	__MANGLE_%_FUNC__	__MANGLE__\n\
#  endif\n\
#endif\n\
";
		for (;;)
		{
			switch (*op++ = *s++)
			{
			case 0:
				op--;
				break;
			case '%':
				op = strcopy(op - 1, proto->package);
				continue;
			default:
				continue;
			}
			break;
		}
	}
	return op;
}

 
#line 391
static char*
nns __PARAM__((register char* s), (s)) __OTORP__(register char* s;){
	while (*s == ' ' || *s == '\t' || *s == '\n')
		s++;
	return s;
}

 
#line 408
static int
directive __PARAM__((register char* s, int dir), (s, dir)) __OTORP__(register char* s; int dir;){
	switch (*(s = nns(s)))
	{
	case 'e':
	case 'i':
		dir <<= 2;
		switch (*++s)
		{
		case 'f':
			dir |= 01;
			break;
		case 'l':
			dir |= 02;
			break;
		case 'n':
			dir |= 03;
			break;
		}
		break;
	}
	return dir;
}

 





static int
lex __PARAM__((register struct proto* proto, register long flags), (proto, flags)) __OTORP__(register struct proto* proto; register long flags;){
	register char*		ip;
	register char*		op;
	register int		c;
	register int		state;
	register short*		rp;
	char*			m;
	char*			e;
	char*			t;
	char*			bp;
	char*			v;
	char*			im;
	char*			ko;
	char*			aom;
	int			n;
	int			line;
	int			quot;
	int			brack;
	int			sub;
	int			x;
	int			vc;

	char*			ie = 0;
	char*			om = 0;
	char*			aim = 0;
	char*			aie = 0;
	char*			func = 0;
	int			call = 0;
	int			dir = 0;
	int			group = 0;
	int			last = 0;
	int			paren = 0;

	char*			qe = 0;
	int			qn = 0;
	int			args = 0;


	do{(ip=proto->ip);(op=proto->op);call=proto->call;}while(0);

	if (flags & (1L<<5)) (ko=op);

 fsm_start:
	proto->tp = ip;
	state = 0;
	bp = ip;
	do
	{
		rp = _pp_fsmtab[state];
 fsm_get:
		while (!(state = rp[c = (*(unsigned char*)ip++)]));
 fsm_next:
		;
	} while (state > 0);
	if ((n = ip - bp - 1) > 0)
	{
		ip = bp;
		do switch( n) { default : memcopy( op, ip, n); op += n; ip += n; break; case 7 : * op++ = * ip++; case 6 : * op++ = * ip++; case 5 : * op++ = * ip++; case 4 : * op++ = * ip++; case 3 : * op++ = * ip++; case 2 : * op++ = * ip++; case 1 : * op++ = * ip++; case 0 : break; } while (0);
		ip++;
	}
	state = ~state;
 fsm_terminal:
	switch ((( state)&((1<<(7+1))-1)))
	{
	case ((0+28)+11):
		if (op > proto->ob && *(op - 1) == '=' && (op == proto->ob + 1 || *(op - 2) != '=')) switch (c)
		{
		case '+':
		case '-':
		case '*':
		case '&':
			(*op++=( ' '));
			break;
		}
		(*op++=( c));
		break;

	case ((0+28)+0):
		(ip--);
		c = (*(op-1));
		break;

	case ((0+28)+1):
		switch (c)
		{
		case '\n':
			if ((( rp)>=_pp_fsmtab[(0+16)]&&( rp)<=_pp_fsmtab[(0+18)])) goto fsm_newline;
			(*op++=( c));
			proto->line++;
			rp = _pp_fsmtab[(0+13)];
			break;
		case '/':

			if ((flags & ((1L<<5)|(1L<<15))) == (1L<<5)) (op=ko);
			else

			(*op++=( c));
			if ((( rp)>=_pp_fsmtab[(0+16)]&&( rp)<=_pp_fsmtab[(0+18)]))
			{
				rp = _pp_fsmtab[(0+16)];
				break;
			}
			goto fsm_start;
		case (255+1):
			break;
		default:

			if ((flags & ((1L<<5)|(1L<<15))) == (1L<<5)) (op=ko);
			else

			(*op++=( c));
			rp = _pp_fsmtab[(( rp)>=_pp_fsmtab[(0+16)]&&( rp)<=_pp_fsmtab[(0+18)]) ? (0+16) : (0+14)];
			break;
		}
		bp = ip;
		goto fsm_get;

	case ((0+28)+2):
		if (c)
		{
			if (state = _pp_fsmtab[(0+28)][((( rp)-_pp_fsmtab[0])/(255+1))+1])
				goto fsm_terminal;
			do{(proto->ip=ip);(proto->op=op);proto->flags&=~((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->flags|=flags&((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->call=call;}while(0);
			return 0;
		}
		(ip--);
 fsm_eob:
		if ((flags & ((1L<<1)|((1L<<16))|(1L<<21))) == ((1L<<16)) && (proto->flags & (1L<<16)))
		{

			if (!(flags & (1L<<5)))  

			flags |= (1L<<24);
			c = ip - proto->ib;
			if (!(flags & (1L<<15)))
				im = proto->tp;
			if (ip > proto->ib)
			{
				n = ip - im;
				if (ip - n < proto->ib)
					proto->flags |= (1L<<4);
				memcopy(proto->ib - n, ip - n, n);
				ip = proto->ib;
			}
			proto->tp -= c;
			if (flags & (1L<<15))
			{
				im -= c;
				ie -= c;
			}
			if (aim)
				aim -= c;
			if (aie)
				aie -= c;
			if ((n = read(proto->fd, ip, proto->iz)) > 0)
			{
				if ((proto->options & (1L<<0)) && n < proto->iz)
				{
					proto->flags &= ~(1L<<16);
					close(proto->fd);
				}
				*(ip + n) = 0;
				if (state & (1<<7))
					goto fsm_splice;
				bp = ip;
				goto fsm_get;
			}
			*ip = 0;
			proto->flags &= ~(1L<<16);
			close(proto->fd);
		}
		if (state & (1<<7))
			goto fsm_splice;
 
		if (!(flags & (1L<<21)) && (state = rp[c = (255+1)]))
		{
			bp = ip;
			goto fsm_next;
		}
		do{(proto->ip=ip);(proto->op=op);proto->flags&=~((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->flags|=flags&((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->call=call;}while(0);
		return 0;

	case ((0+28)+3):
		quot = c;

		if (c == '"' && qe)
		{
			for (n = 0, t = qe + 1; t < op && (*t == ' ' || *t == '\t' || *t == '\n' && ++n || *t >= 'A' && *t <= 'Z' || *t == '_'); t++);
			if (t == op)
			{
				op = qe;
				qe = 0;
				qn = n;
			}
			else (*op++=( c));
		}
		else

		(*op++=( c));
		rp = _pp_fsmtab[(0+21)];
		bp = ip;
		goto fsm_get;

	case ((0+28)+4):
		if (c == quot)
		{

			if (!(flags & (1L<<3)))
				qe = (c == '"') ? op : (char*)0;

			(*op++=( c));

			while (qn > 0)
			{
				qn--;
				(*op++=( '\n'));
			}

		}
		else if (c != '\n' && c != (255+1))
		{
			(*op++=( c));
			bp = ip;
			goto fsm_get;
		}
		else
		{

			while (qn > 0)
			{
				qn--;
				(*op++=( '\n'));
			}

			(ip--);
		}
		c = (0401+1);
		break;

	case ((0+28)+5):

		if (flags & (1L<<0)) (*op++=( c));
		else

		switch (c)
		{
		case 'a':
			n = (('A'==0301)?0057:0007);
			goto fsm_oct;
		case 'E':
			n = (('A'==0301)?0047:0033);
			goto fsm_oct;
		case 'v':
			n = 0013;
			goto fsm_oct;
		case 'x':
			do{(proto->ip=ip);(proto->op=op);proto->flags&=~((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->flags|=flags&((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->call=call;}while(0);
			lex(proto, (flags & ((1L<<16))) | (1L<<21));
			for (n = x = 0; (c = (*(unsigned char*)ip++)), x < 3; x++) switch (c)
			{
			case '0': case '1': case '2': case '3':
			case '4': case '5': case '6': case '7':
			case '8': case '9':
				n = (n << 4) + c - '0';
				break;
			case 'a': case 'b': case 'c': case 'd':
			case 'e': case 'f':
				n = (n << 4) + c - 'a' + 10;
				break;
			case 'A': case 'B': case 'C': case 'D':
			case 'E': case 'F':
				n = (n << 4) + c - 'A' + 10;
				break;
			default:
				goto fsm_hex;
			}
 fsm_hex:
			(ip--);
 fsm_oct:
			(*op++=( ((n >> 6) & 07) + '0'));
			(*op++=( ((n >> 3) & 07) + '0'));
			(*op++=( (n & 07) + '0'));
			break;
		default:
			(*op++=( c));
			break;
		}
		rp = _pp_fsmtab[(0+21)];
		bp = ip;
		goto fsm_get;

	case ((0+28)+6):
		(ip--);

		if ((flags & (1L<<5)) && *proto->tp == 's' && !sstrncmp( proto->tp, "static", 6))
		{
			c = ((0500+4)+9);
			break;
		}

		if (*proto->tp == '_' && !sstrncmp( proto->tp, "__STDPP__directive", 6)) c = '#';
		else c = (0401+0);

		break;

	case ((0+28)+7):
 fsm_newline:
		proto->line++;

		if (flags & (1L<<5))
		{
			if (op != proto->ob && (*(op-1)) != ' ' && (*(op-1)) != '\n')
				(*op++=( ' '));
		}
		else

		(*op++=( c));
		if (flags & (1L<<3))
		{

			if (flags & (1L<<0))
			{
				if (flags & (1L<<5)) (op=ko);
				if (flags & (1L<<12))
				{
					*(ip - 1) = 0;
					op = strcopy(om, "/* ");
					op = strcopy(op, im);
					op = strcopy(op, " */\n");
				}
				flags &= ~((1L<<2)|(1L<<3)|(1L<<7)|(1L<<8)|(1L<<12)|(1L<<15)|(1L<<22)|(1L<<26));
			}
			else

			{
				if ((flags & ((1L<<2)|(1L<<22))) == ((1L<<2)|(1L<<22)))
				{
					*(ip - 1) = 0;
					op = strcopy(om, "#if defined(__STDC__) || defined(__STDPP__)\n");
					op = strcopy(op, im);
					op = strcopy(op, "\n#else\n");
					bp = ip;
					ip = im;
					*op++ = *ip++;
					while (*op = *ip++)
						if (*op++ == '#' && *ip != '(')
						{
							op--;
							while (*--op == ' ' || *op == '\t');
							if (*ip == '#')
							{
								op = strcopy(op + 1, "/**/");
								while (*++ip == ' ' || *ip == '\t');
							}
							else
							{
								if (*op != '"') *++op = '"';
								op++;
								while (*ip == ' ' || *ip == '\t') ip++;
								while ((c = *ip) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') *op++ = *ip++;
								while (*ip == ' ' || *ip == '\t') ip++;
								if (*ip == '"') ip++;
								else *op++ = '"';
							}
						}
					ip = bp;
					op = strcopy(op, "\n#endif\n");
					op = linesync(proto, op, proto->line);
				}
				flags &= ~((1L<<2)|(1L<<3)|(1L<<7)|(1L<<8)|(1L<<15)|(1L<<17)|(1L<<22)|(1L<<23)|(1L<<25)|(1L<<26));
			}
			call = 0;
			group = 0;
			paren = 0;
			last = '\n';
		}
		if (paren == 0 && (flags & ((1L<<15)|(1L<<21)|(1L<<23)|(1L<<24))) == (1L<<24))
		{

			if (flags & (1L<<5)) (op=ko);

			do{(proto->ip=ip);(proto->op=op);proto->flags&=~((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->flags|=flags&((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->call=call;}while(0);
			return 0;
		}
		goto fsm_start;

	case ((0+28)+8):
		(*op++=( c));
		rp = _pp_fsmtab[((( state)>>(7+1))&((1<<7)-1))];
		bp = ip;
		goto fsm_get;

	case ((0+28)+13):
		(*op++=( c));
		c = (((( state)>>(7+1))&((1<<7)-1))+0401);
		break;

	case ((0+28)+14):
		(ip--);
		c = (((( state)>>(7+1))&((1<<7)-1))+0401);
		break;

	case (((0+28)+12)):
		(ip--);
		c = (0401+0);
		if (!(flags & (1L<<1))) switch (((((long)( *proto->tp))<<16)|(((long)( *(ip - 1)))<<8)|((long)( ip - proto->tp))))
		{
		case ((((long)( 'N'))<<16)|(((long)( 'N'))<<8)|((long)( 3))):
			if (proto->tp[1] == 'o')
				c = ((0500+4)+6);
			break;
		case ((((long)( 'd'))<<16)|(((long)( 'o'))<<8)|((long)( 2))):
			c = ((0500+4)+6);
			break;
		case ((((long)( 'e'))<<16)|(((long)( 'e'))<<8)|((long)( 4))):
			if (!(flags & (1L<<21)) && (flags & ((1L<<3)|(1L<<25))) != (1L<<3) && !sstrncmp( proto->tp, "else", 4))
			{
				c = ((0500+4)+8);
				goto fsm_id;
			}
			break;
		case ((((long)( 'e'))<<16)|(((long)( 'n'))<<8)|((long)( 6))):
			if (!sstrncmp( proto->tp, "extern", 6))
				c = ((0500+4)+9);
			break;
		case ((((long)( 'f'))<<16)|(((long)( 'r'))<<8)|((long)( 3))):
			if (!(flags & (1L<<21)) && !sstrncmp( proto->tp, "for", 3))
			{
				c = ((0500+4)+11);
				goto fsm_id;
			}
			break;
		case ((((long)( 'i'))<<16)|(((long)( 'f'))<<8)|((long)( 2))):
			c = ((0500+4)+13);
			break;
		case ((((long)( 'i'))<<16)|(((long)( 'e'))<<8)|((long)( 6))):
			if (!sstrncmp( proto->tp, "inline", 6) && !(flags & ((1L<<15)|(1L<<23)|(1L<<25)|(1L<<26))) && proto->brace == 0 && paren == 0 && group == 0 && (last == ';' || last == '}' || last == '\n' || last == 0))
			{
				flags |= (1L<<23);
				do{(proto->ip=ip);(proto->op=op);proto->flags&=~((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->flags|=flags&((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->call=call;}while(0);
				line = proto->line;
				op = strcopy(op - 6, "__INLINE__");
				do{(proto->ip=ip);(proto->op=op);proto->flags&=~((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->flags|=flags&((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->call=call;}while(0);
			}
			break;
		case ((((long)( 'r'))<<16)|(((long)( 'n'))<<8)|((long)( 6))):
			if (!(flags & (1L<<21)) && !sstrncmp( proto->tp, "return", 6))
			{
				c = ((0500+4)+17);
				goto fsm_id;
			}
			break;
		case ((((long)( 's'))<<16)|(((long)( 'c'))<<8)|((long)( 6))):
			if ((proto->options & (1L<<6)) && !sstrncmp( proto->tp, "static", 6))
			{
				proto->ox = op - 6;
				flags |= (1L<<6);
			}
			break;
		case ((((long)( 't'))<<16)|(((long)( 'f'))<<8)|((long)( 7))):
			if (!(flags & (1L<<21)) && !sstrncmp( proto->tp, "typedef", 7))
			{
				flags |= (1L<<26);
				c = ((0500+4)+9);
			}
			break;
		case ((((long)( 'v'))<<16)|(((long)( 't'))<<8)|((long)( 8))):
			if (*ip == '(' && !sstrncmp( proto->tp, "va_start", 8)) c = (0500+1);
			break;
		case ((((long)( 'v'))<<16)|(((long)( 'd'))<<8)|((long)( 4))):
			if (!sstrncmp( proto->tp, "void", 4))
			{
				if (flags & ((1L<<0)|(1L<<19)|(1L<<10)|(1L<<11))) c = ((0500+4)+30);
				else
				{
					do{(proto->ip=ip);(proto->op=op);proto->flags&=~((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->flags|=flags&((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->call=call;}while(0);
					line = proto->line;
					if (lex(proto, (flags & ((1L<<16))) | (1L<<21)) == '*')
					{
						memcopy(op - 4, "__V_", 4);
						memcopy(ip - 4, "__V_", 4);
					}
					else c = ((0500+4)+30);
					proto->line = line;
					do{(proto->ip=ip);(proto->op=op);proto->flags&=~((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->flags|=flags&((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->call=call;}while(0);
					bp = ip;
				}
			}
			break;
		case ((((long)( 'w'))<<16)|(((long)( 'e'))<<8)|((long)( 5))):
			if (!(flags & (1L<<21)) && !sstrncmp( proto->tp, "while", 5))
			{
				c = ((0500+4)+26);
				goto fsm_id;
			}
			break;
		}

		if ((flags & (1L<<0)) && c != ((0500+4)+9))
			c = (0401+0);

		break;

	case ((0+28)+10):
		goto fsm_start;

	case ((0+28)+15):
		(ip--);

		if ((flags & ((1L<<5)|(1L<<15))) == (1L<<5))
		{
			while (op > proto->ob && (*(op - 1) == ' ' || *(op - 1) == '\t'))
				op--;
			if (op > proto->ob && *(op - 1) != '\n') *op++ = ' ';
		}

		goto fsm_start;

	default:
		if (state & (1<<7))
		{
			if (c == '\\')
			{
				if (!(n = (*(unsigned char*)ip++)))
				{
					goto fsm_eob;
 fsm_splice:
					c = '\\';
					n = (*(unsigned char*)ip++);
				}
				if (n == '\n')
				{
					proto->line++;
					(*op++=( '\\'));
					(*op++=( '\n'));
					bp = ip;
					goto fsm_get;
				}
				(ip--);
			}
			state &= ~(1<<7);
			if (state >= (0+28))
				goto fsm_terminal;
			rp = _pp_fsmtab[state];
		}
		(*op++=( c));
		bp = ip;
		goto fsm_get;
	}
	if (!(flags & ((1L<<10)|(1L<<11)|(1L<<21))))
	{
		if (!(flags & (1L<<3))) switch (c)
		{
		case '(':

			if (!(flags & (1L<<0)) || proto->brace == 0)

			{
				if (paren++ == 0)
				{

					if (!(flags & (1L<<0)) || group <= 1)

					{

						args = 0;

						if (group++ == 0) group++;
						else if (flags & (1L<<8)) call++;
						flags |= (1L<<15);
						im = ip - 1;
						om = op - 1;
					}
					sub = 0;
				}
				else if (paren == 2 && !aim)
				{
					sub++;
					if (last == '(')
					{
						flags &= ~(1L<<15);
						om = 0;
					}
					else if (flags & (1L<<8))
					{
						aim = ip - 1;
						aom = op - 1;
					}
					else if ((flags & ((1L<<15)|(1L<<25))) == (1L<<15))
					{
						for (m = ip - 2; m > im && (*m == ' ' || *m == '\t'); m--);
						if (m != im && sub == 1)
						{
							m = im + (*nns(ip) == '*');
						}
						if (m == im)
						{
							flags &= ~(1L<<15);
							om = 0;
						}
					}
					else if ((flags & (1L<<15)) && sub == 1 && *nns(ip) != '*')
					{
						flags &= ~(1L<<15);
						om = 0;
					}
				}
				flags &= ~(1L<<25);
			}
			break;
		case ')':

			if (!(flags & (1L<<0)) || proto->brace == 0)

			if (--paren == 0)
			{

				if (flags & (1L<<0))
				{
					if (group != 2)
					{
						c = (0401+0);
						break;
					}
					group++;
				}

				ie = ip;
			}
			else if (paren == 1 && (flags & (1L<<8)) && !aie)
				aie = ip;
			break;
		case '*':
			if (last == '(' && group == 2)
			{
				group--;
				if (paren == 1)
				{
					flags |= (1L<<8);
					aim = aie = 0;
				}
			}
			break;
		case '#':
			dir = directive(ip, dir);
			if (proto->brace == 0 && paren == 0 && last != '=' && (flags & ((1L<<0)|(1L<<1)|(1L<<3)|(1L<<15)|(1L<<19)|(1L<<23)|(1L<<25))) == ((1L<<15)|(1L<<25)) && ((dir & 03) != 03 || ((dir>>2) & 03) != 01))
				flags |= (1L<<3);
			else if (!(flags & ((1L<<1)|(1L<<3))))
			{
				flags |= (1L<<3);
				if (!(flags & (1L<<19)))
				{
					bp = ip;
					while (*ip == ' ' || *ip == '\t') ip++;
					if (*ip == 'l' && *++ip == 'i' && *++ip == 'n' && *++ip == 'e')
					{
						if (*++ip == ' ' || *ip == '\t')
						{
							proto->line = 0;
							while (*++ip >= '0' && *ip <= '9')
								proto->line = proto->line * 10 + *ip - '0';
							proto->line--;
						}
					}

					else if ((flags & ((1L<<0)|(1L<<5))) == (1L<<0))
					{
						n = 0;
						t = ip + 6;
						while (ip < t && *ip >= 'a' && *ip <= 'z')
							n = ((( n)<<5)+(( *ip++)-('a'-1)));
						switch (n)
						{
						case ((( ((( ((( (( 'e')-('a'-1)))<<5)+(( 'l')-('a'-1))))<<5)+(( 's')-('a'-1))))<<5)+(( 'e')-('a'-1))):
						case ((( ((( ((( ((( (( 'e')-('a'-1)))<<5)+(( 'n')-('a'-1))))<<5)+(( 'd')-('a'-1))))<<5)+(( 'i')-('a'-1))))<<5)+(( 'f')-('a'-1))):
							while (*ip == ' ' || *ip == '\t') ip++;
							if (*ip != '\n' && *ip != '/' && *(ip + 1) != '*')
							{
								flags |= (1L<<12)|(1L<<15);
								im = ip;
								om = op + (ip - bp);
							}
							break;
						case ((( ((( ((( (( 'e')-('a'-1)))<<5)+(( 'l')-('a'-1))))<<5)+(( 'i')-('a'-1))))<<5)+(( 'f')-('a'-1))):
						case ((( ((( ((( ((( (( 'e')-('a'-1)))<<5)+(( 'r')-('a'-1))))<<5)+(( 'r')-('a'-1))))<<5)+(( 'o')-('a'-1))))<<5)+(( 'r')-('a'-1))):
						case ((( (( 'i')-('a'-1)))<<5)+(( 'f')-('a'-1))):
						case ((( ((( ((( ((( (( 'i')-('a'-1)))<<5)+(( 'f')-('a'-1))))<<5)+(( 'd')-('a'-1))))<<5)+(( 'e')-('a'-1))))<<5)+(( 'f')-('a'-1))):
						case ((( ((( ((( ((( ((( (( 'i')-('a'-1)))<<5)+(( 'f')-('a'-1))))<<5)+(( 'n')-('a'-1))))<<5)+(( 'd')-('a'-1))))<<5)+(( 'e')-('a'-1))))<<5)+(( 'f')-('a'-1))):
						case ((( ((( ((( ((( (( 'u')-('a'-1)))<<5)+(( 'n')-('a'-1))))<<5)+(( 'd')-('a'-1))))<<5)+(( 'e')-('a'-1))))<<5)+(( 'f')-('a'-1))):
							break;
						case ((( ((( ((( ((( ((( (( 'i')-('a'-1)))<<5)+(( 'n')-('a'-1))))<<5)+(( 'c')-('a'-1))))<<5)+(( 'l')-('a'-1))))<<5)+(( 'u')-('a'-1))))<<5)+(( 'd')-('a'-1))):
							if (*ip == 'e') ip++;
 
						case ((( ((( ((( ((( ((( (( 'd')-('a'-1)))<<5)+(( 'e')-('a'-1))))<<5)+(( 'f')-('a'-1))))<<5)+(( 'i')-('a'-1))))<<5)+(( 'n')-('a'-1))))<<5)+(( 'e')-('a'-1))):
						case ((( ((( ((( ((( ((( (( 'p')-('a'-1)))<<5)+(( 'r')-('a'-1))))<<5)+(( 'a')-('a'-1))))<<5)+(( 'g')-('a'-1))))<<5)+(( 'm')-('a'-1))))<<5)+(( 'a')-('a'-1))):
							if (*ip < 'a' || *ip > 'z') break;
 
						default:
							flags |= (1L<<12)|(1L<<15);
							im = bp - 1;
							om = op - 1;
							break;
						}
					}
					else

					{
						if (*ip == 'i' && *++ip == 'n' && *++ip == 'c' && *++ip == 'l' && *++ip == 'u' && *++ip == 'd' && *++ip == 'e')
						{
							while (*++ip == ' ' || *ip == '\t');
							if (*ip++ == '<' && *ip++ == 's' && *ip++ == 't' && *ip++ == 'd' && *ip++ == 'a' && *ip++ == 'r' && *ip++ == 'g' && *ip++ == '.' && *ip++ == 'h' && *ip++ == '>')
							{
								op = strcopy(op, "\
if !defined(va_start)\n\
#if defined(__STDARG__)\n\
#include <stdarg.h>\n\
#else\n\
#include <varargs.h>\n\
#endif\n\
#endif\n\
");
								op = linesync(proto, op, proto->line);
								break;
							}
						}
						else if (*ip == 'd' && *++ip == 'e' && *++ ip == 'f' && *++ip == 'i' && *++ip == 'n' && *++ip == 'e' && (*++ip == ' ' || *ip == '\t'))
						{
							while (*++ip == ' ' || *ip == '\t');
							if (*ip == 'e' && *++ip == 'x' && *++ ip == 't' && *++ip == 'e' && *++ip == 'r' && *++ip == 'n' && (*++ip == ' ' || *ip == '\t'))
							{
								t = ip;
								while (*++t == ' ' || *t == '\t');
								if (*t == 'e' && *++t == 'x' && *++ t == 't' && *++t == 'e' && *++t == 'r' && *++t == 'n' && (*++t == ' ' || *t == '\t' || *t == '\n' || *t == '\r'))
									ip = t;
								t = ip;
								while (*++t == ' ' || *t == '\t');
								if (*t == '_' && *(t + 1) == '_')
								{
									op = strcopy(op, "undef __MANGLE__\n");
									op = linesync(proto, op, proto->line);
									op = strcopy(op, "#define __MANGLE__ __LINKAGE__");
									break;
								}
							}
							flags |= (1L<<2)|(1L<<15);
							im = bp - 1;
							om = op - 1;
						}
						else if (*ip == 'u' && *++ip == 'n' && *++ ip == 'd' && *++ip == 'e' && *++ip == 'f' && (*++ip == ' ' || *ip == '\t'))
						{
							while (*++ip == ' ' || *ip == '\t');
							if (*ip == 'e' && *++ip == 'x' && *++ ip == 't' && *++ip == 'e' && *++ip == 'r' && *++ip == 'n' && (*++ip == ' ' || *ip == '\t' || *ip == '\n' || *ip == '\r'))
							{
								op = strcopy(op, "undef __MANGLE__\n");
								op = linesync(proto, op, proto->line);
								op = strcopy(op, "#define __MANGLE__ __LINKAGE__");
								break;
							}
							flags |= (1L<<2)|(1L<<15);
							im = bp - 1;
							om = op - 1;
						}
					}
					ip = bp;
				}
				break;
			}
			else
				break;
 
		case '{':
			if (proto->brace++ == 0 && paren == 0)
			{
				if (last == '=') flags |= (1L<<9);

				else if (flags & (1L<<0))
				{
					if ((flags & ((1L<<15)|(1L<<17)|(1L<<23))) == (1L<<15))
					{
						if (args)
						{
							v = number(op, args < 0 ? -args : args);
							v = strcopy(v, " argument actual/formal mismatch");
							*v++ = ' ';
							v = memcopy(v, im, ie - im);
							*v = 0;
							proto_error((char*)proto + sizeof(struct proto), 2, op, ((char*)0));
						}
						ip--;
 
	v = ie;
	while (ie < ip)
		if (*ie++ == '/' && *ie == '*')
		{
			e = ie - 1;
			while (++ie < ip)
			{
				if (*ie == '*')
				{
					while (ie < ip && *ie == '*') ie++;
					if (ie < ip && *ie == '/')
					{
						while (++ie < ip && (*ie == ' ' || *ie == '\t'));
						while (e > v && (*(e - 1) == ' ' || *(e - 1) == '\t')) e--;
						if (e > v && *e != '\n') *e++ = ' ';
						t = ie;
						while (--e >= v)
							*--t = *e;
						v = t;
						break;
					}
				}
			}
		}
	ie = v;
 
						op = om++;
						if (flags & (1L<<5))
						{
							v = op;
							while (v > ko && *--v != ' ');
							if (*v != ' ')
							{
								om = (v = (op += 4)) + 1;
								while (v >= ko + 4)
								{
									*v = *(v - 4);
									v--;
								}
								memcopy(ko, "int ", 4);
							}
							if (*v == ' ')
							{
								while (*(v + 1) == '*')
									*v++ = '*';
								*v = '\t';
								if ((v - ko) <= 8)
								{
									om = (e = ++op) + 1;
									while (e > v)
									{
										*e = *(e - 1);
										e--;
									}
								}
							}
							om = (v = (op += 7)) + 1;
							while (v >= ko + 7)
							{
								*v = *(v - 7);
								v--;
							}
							memcopy(ko, "extern ", 7);
						}
						(*op++=( '('));
						t = op;
						e = 0;
 
	while (ie < ip)
	{
		if ((c = *ie) == ' ' || c == '\t' || c == '\n')
		{
			while ((c = *++ie) == ' ' || c == '\t' || c == '\n');
			if (ie >= ip) break;
			if (c != '*' && op > om) (*op++=( ' '));
		}
		if ((n = ((c = *ie) == ',')) || c == ';')
		{
			if (flags & (1L<<5))
			{
				m = op;
				while (op > om && ((c = *(op - 1)) == '(' || c == ')' || c == '[' || c == ']'))
					op--;
				v = op;
				while (op > om && (c = *(op - 1)) != ' ' && c != '*')
					op--;
				while (*(op - 1) == ' ')
					op--;
				if (!e)
				{
					e = op;
					while (e > om && *(e - 1) == '*')
						e--;
				}




				if (op <= om)
					op = strcopy(op, "int");
				else if (*(op - 1) == ',')
					op = strcopy(op, " int");

				while (v < m)
					(*op++=( *v++));
			}
			(*op++=( ','));
			if (n)
			{
				if (x = !e) e = op - 1;
				(*op++=( ' '));
				m = t;
				while (m < e)
					(*op++=( *m++));
				if (x)
				{
					m = e;
					while (*--e != ' ');
					while (*(e - 1) == '*') e--;
					op -= m - e;
				}
			}
			while ((c = *++ie) == ' ' || c == '\t' || c == '\n');
			if (ie >= ip) (op--);
			else (*op++=( ' '));
			if (!n)
			{
				t = op;
				e = 0;
			}
		}
		else if (*ie == '*')
		{
			if (op > om && (c = *(op - 1)) == ' ') op--;
			while (*ie == '*') (*op++=( *ie++));
			while (*ie == ' ' || *ie == '\t' || *ie == '\n') ie++;
			if (c != '(') (*op++=( ' '));
		}
		else if (*ie == '(')
		{
			if (op > om && *(op - 1) == ' ') op--;
			(*op++=( *ie++));
			while (*ie == ' ' || *ie == '\t' || *ie == '\n') ie++;
		}
		else if (*ie == ')')
		{
			if (op > om && *(op - 1) == '(')
				proto_error((char*)proto + sizeof(struct proto), 1, "function pointer argument prototype omitted", ((char*)0));
			(*op++=( *ie++));
			while (*ie == ' ' || *ie == '\t' || *ie == '\n') ie++;
		}
		else if ((flags & (1L<<5)) && (op == om || *(op - 1) == ' ') && *ie == 'r' && !sstrncmp( ie, "register", 8) && (*(ie + 8) == ' ' || *(ie + 8) == '\t' || *(ie + 8) == '\n'))
		{
			ie += 8;
			if (op > om) (op--);
		}
		else (*op++=( *ie++));
	}
 
						if (op <= om) op = strcopy(op, "void");
						(*op++=( ')'));
						if (flags & (1L<<5))
						{
							(*op++=( ';'));
							(*op++=( '\n'));
							(proto->op=op);
							(ko=op);
						}
						else
						{
							(*op++=( '\n'));
							(*op++=( *ip));
						}
						ip++;
						flags &= ~((1L<<15)|(1L<<23));
					}
				}

				else if ((flags & ((1L<<15)|(1L<<19)|(1L<<23)|(1L<<25))) == ((1L<<15)|(1L<<25)))
				{
					line = proto->line;
					op = strcopy(om, " __PARAM__(");
					op = memcopy(op, im, ie - im);
					(*op++=( ','));
					(*op++=( ' '));
					(*op++=( '('));
					flags &= ~((1L<<15)|(1L<<23));
					if (flags & (1L<<27))
					{
						if ((vc = ie - im + 1) > sizeof(proto->variadic)) vc = sizeof(proto->variadic);
						memcopy(proto->variadic, im, vc);
						op = strcopy(op, "va_alist)) __OTORP__(va_dcl)\n{");
					}
					else
					{
						flags |= (1L<<23);
						proto->ip = im;
						proto->op = op;
						group = 0;
						brack = 0;
						for (;;)
						{
							switch (lex(proto, (flags & ((1L<<16))) | (1L<<21)))
							{
							case '[':
								brack++;
								continue;
							case ']':
								brack--;
								continue;
							case '(':
								if (paren++) group++;
								continue;
							case ')':
								if (--paren == 0)
								{
									group = 0;
									if (flags & (1L<<15))
									{
										flags &= ~((1L<<15)|(1L<<23));
										op = memcopy(op, m, e - m);
									}
									break;
								}
								continue;
							case ',':
								if (paren == 1)
								{
									group = 0;
									if (flags & (1L<<15))
									{
										flags &= ~((1L<<15)|(1L<<23));
										op = memcopy(op, m, e - m);
									}
									(*op++=( ','));
									(*op++=( ' '));
									proto->op = op;
								}
								continue;
							case (0401+0):
								if (group <= 1 && !brack)
								{
									flags |= (1L<<15);
									m = proto->tp;
									e = proto->ip;
								}
								continue;
							default:
								continue;
							}
							break;
						}
						(*op++=( ')'));
						(*op++=( ')'));
					}
					if (!(flags & (1L<<23)))
					{
						flags |= (1L<<23);
						proto->op = strcopy(op, " __OTORP__(");
						proto->ip = im + 1;
						n = *(ie - 1);
						*(ie - 1) = ';';
						c = *ie;
						*ie = 0;
						lex(proto, (flags & ((1L<<16))) | (1L<<1));
						*(ie - 1) = n;
						*ie = c;
						proto->ip = ie;
						op = proto->op;
						(*op++=( ')'));
					}
					if (flags & (1L<<6)) memcopy( proto->ox, "extern", 6);
					op = linesync(proto, op, proto->line = line);
					if (flags & (1L<<3))
					{
						proto->brace = 0;
						(*op++=( '\n'));
						(*op++=( '#'));
					}
					else if (!(flags & (1L<<27))) (*op++=( '{'));
				}
			}
			flags &= ~((1L<<7)|(1L<<8)|(1L<<15)|(1L<<17)|(1L<<23));
			call = 0;
			group = 0;
			break;
		case '}':
			flags &= ~((1L<<7)|(1L<<8)|(1L<<15)|(1L<<17)|(1L<<23)|(1L<<25));
			if (--proto->brace == 0)
			{
				flags &= ~((1L<<9)|(1L<<27)|(1L<<28));

				if (flags & (1L<<5)) (op=ko);

			}
			call = 0;
			group = 0;
			paren = 0;
			break;
		case '=':
			if (last == '?') flags |= (1L<<3);
			else if (paren == 0 && (flags & ((1L<<9)|(1L<<15)|(1L<<23))) == (1L<<15)) goto fsm_statement;
			goto fsm_other;
		case ',':

			if (flags & (1L<<0))
			{
				if (paren == 1) args++;
				else
				{
					args--;
					flags &= ~(1L<<15);
				}
				break;
			}

			if (paren == 0 && (flags & (1L<<1))) *(op - 1) = c = ';';
 
		case ';':
 fsm_statement:
			if (flags & (1L<<9))  ;

			else if (flags & (1L<<0))
			{
				if (paren == 0)
				{
					if ((flags & (1L<<15)) && last == ')')
						flags &= ~(1L<<15);
					if (!(flags & (1L<<15)))
					{
						call = 0;
						group = 0;
						flags &= ~(1L<<23);
						if (flags & (1L<<5)) (op=ko);
						if (flags & (1L<<24))
						{
							do{(proto->ip=ip);(proto->op=op);proto->flags&=~((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->flags|=flags&((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->call=call;}while(0);
							return 0;
						}
					}
					else
					{
						args--;
						if ((flags & ((1L<<5)|(1L<<23))) == ((1L<<5)|(1L<<23)))
							(op=ko);
					}
				}
			}

			else if (paren == 0)
			{
				if ((flags & ((1L<<15)|(1L<<17)|(1L<<23))) == (1L<<15) && call > 1)
				{
					if ((flags & (1L<<14)) && func)
					{
						func[0] = 'F';
						func[1] = 'U';
						func[2] = 'N';
						func[3] = 'C';
						func = 0;
					}
					if ((flags & ((1L<<1)|(1L<<8))) == (1L<<8) && aim && aie < im)
					{
						while (aie < ip && (*aie == ' ' || *aie == '\t' || *aie == '\n')) aie++;
						v = aim;
						while (v < aie)
							if (*v++ == ')') break;
						while (v < aie && (*v == ' ' || *v == '\t' || *v == '\n')) v++;
						if (v == aie || !(flags & (1L<<20)))
						{
							if (flags & (1L<<20)) n = 3;
							else if (v == aie && *v == '(') n = 10;
							else n = 11;
							ko = op;
							om += n;
							v = op += n;
							while (v >= ko + n)
							{
								*v = *(v - n);
								v--;
							}
							if (flags & (1L<<20)) memcopy(aom, "(...))", 6);
							else if (n == 10) memcopy(aom, "(__VARARG__))", 13);
							else
							{
								ko = strcopy(aom, " __PROTO__(");
								ko = memcopy(ko, aim, aie - aim);
								*ko = ')';
								if (++ko >= om)
								{
									*ko++ = ')';
									om = ko;
								}
							}
						}
					}
					else if (flags & (1L<<26))
					{
						op = om;
						while (*--op == ' ' || *op == '\t' || *op == '\n');
						if (*op != ')')
						{
							op = om += 14;
							*--op = ')';
							while ((x = *(op - 14)) >= 'A' && x <= 'Z' || x >= 'a' && x <= 'z' || x >= '0' && x <= '9' || x == '_')
								*--op = x;
							memcopy(op - 13, "(__OTORP__(*)", 13);
						}
					}
					if (flags & (1L<<17))
						;
					else if (flags & (1L<<20))
					{
						op = om;
						if (!(flags & (1L<<25))) op = strcopy(op, "(...)");
						else op = memcopy(op, im, ie - im);
						(*op++=( c));
					}
					else
					{
						if (flags & (1L<<1)) op = strcopy(om, "()");
						else if (!(flags & (1L<<25))) op = strcopy(om, "(__VARARG__)");
						else
						{
							op = strcopy(om, " __PROTO__(");
							op = memcopy(op, im, ie - im);
							(*op++=( ')'));
						}
						if (flags & (1L<<6)) memcopy( proto->ox, "extern", 6);
						(*op++=( c));
					}
					flags &= ~((1L<<15)|(1L<<27)|(1L<<28));
					if (c == ',' && !(flags & (1L<<8)))
					{
						call = 1;
						group = 0;
						break;
					}
				}
				else if (flags & ((1L<<17)|(1L<<23))) call = 0;
				if (c == ';')
				{
					flags &= ~((1L<<6)|(1L<<14)|(1L<<25)|(1L<<26));
					call = 0;
					if (flags & (1L<<24))
					{
						do{(proto->ip=ip);(proto->op=op);proto->flags&=~((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->flags|=flags&((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->call=call;}while(0);
						return 0;
					}
				}
				else call = call > 1 && c == ',';
				group = 0;
				flags &= ~((1L<<7)|(1L<<8)|(1L<<15)|(1L<<17)|(1L<<23));
			}
			else if (paren == 1 && group == 1 && !(flags & ((1L<<7)|(1L<<14)))) flags |= (1L<<25)|(1L<<17);
			break;
		case ((0500+4)+6):
		case ((0500+4)+13):
			flags |= (1L<<25)|(1L<<23);
			break;
		case ((0500+4)+9):

			if (flags & (1L<<0))
			{
				if (proto->brace == 0)
					flags |= (1L<<23);
			}
			else

			if (paren == 0 && !(flags & (1L<<26)))
			{
				flags |= (1L<<14);
				if (!(flags & (1L<<19)) || proto->package)
				{
					op = strcopy(op, " __MANGLE__");
					if (proto->package)
					{
						op = strcopy(op - 1, proto->package);
						func = op + 1;
						op = strcopy(op, "_DATA__");
					}
				}
				else
					func = 0;
			}
			break;
		case (0401+29):
			if (paren == 0 && (flags & ((1L<<1)|(1L<<27))) == (1L<<1))
			{
				op -= 3;
				do{(proto->ip=ip);(proto->op=op);proto->flags&=~((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->flags|=flags&((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->call=call;}while(0);
				return c;
			}
			if (paren == 1 && !(flags & (1L<<23)))
				flags |= (1L<<27);
			flags |= (1L<<25);
			break;
		case ((0500+4)+30):
			goto fsm_id;
		case (0500+1):
			if ((flags & ((1L<<19)|(1L<<27))) == (1L<<27))
			{
				flags &= ~(1L<<15);
				line = proto->line;
				op = strcopy(op - 8, "__VA_START__");
				do{(proto->ip=ip);(proto->op=op);proto->flags&=~((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->flags|=flags&((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->call=call;}while(0);
				for (;;)
				{
					switch (lex(proto, (flags & ((1L<<16))) | (1L<<21)))
					{
					case 0:
					case ';':
						break;
					case (0401+0):
						if (!(flags & (1L<<15)))
						{
							flags |= (1L<<15);
							m = proto->tp;
							e = proto->ip;
						}
						continue;
					default:
						continue;
					}
					break;
				}
				do{(ip=proto->ip);(op=proto->op);call=proto->call;}while(0);
				if (flags & (1L<<15))
				{
					v = m;
					n = e - m;
				}
				else
				{
					v = "ap";
					n = 2;
				}
				op = strcopy(op, " __OTORP__(");
				proto->ip = proto->variadic;
				proto->op = op;
				flags &= ~(1L<<15);
				group = 0;
				bp = proto->ip + 1;
				if (*bp == 'r' && !sstrncmp( bp, "register", 8) && (*(bp + 8) == ' ' || *(bp + 8) == '\t')) bp += 9;
				for (;;)
				{
					switch (lex(proto, (flags & ((1L<<16))) | (1L<<21)))
					{
					case '(':
						if (paren++) group++;
						continue;
					case ')':
						if (--paren == 0)
						{
							if (flags & (1L<<15))
							{
								flags &= ~(1L<<15);
								if (!(flags & (1L<<28)))
								{
									op = memcopy(op, m, e - m);
									op = strcopy(op, " = ");
								}
								op = strcopy(op, "va_arg(");
								op = memcopy(op, v, n);
								(*op++=( ','));
								(*op++=( ' '));
								if (m > bp) op = memcopy(op, bp, m - bp);
								else op = strcopy(op, "int ");
								if (group > 1) op = strcopy(op, ")()");
								else op = memcopy(op, e, proto->ip - e - 1);
								(*op++=( ')'));
								(*op++=( ';'));
							}
							group = 0;
							break;
						}
						continue;
					case ',':
						if (paren == 1)
						{
							if (flags & (1L<<15))
							{
								flags &= ~(1L<<15);
								if (!(flags & (1L<<28)))
								{
									op = memcopy(op, m, e - m);
									op = strcopy(op, " = ");
								}
								op = strcopy(op, "va_arg(");
								op = memcopy(op, v, n);
								(*op++=( ','));
								(*op++=( ' '));
								if (m > bp) op = memcopy(op, bp, m - bp);
								else op = strcopy(op, "int ");
								if (group > 1) op = strcopy(op, ")()");
								else op = memcopy(op, e, proto->ip - e - 1);
								(*op++=( ')'));
								(*op++=( ';'));
								bp = proto->ip + 1;
								if (*bp == 'r' && !sstrncmp( bp, "register", 8) && (*(bp + 8) == ' ' || *(bp + 8) == '\t')) bp += 9;
							}
							group = 0;
							proto->op = op;
						}
						continue;
					case (0401+0):
						if (group <= 1)
						{
							flags |= (1L<<15);
							m = proto->tp;
							e = proto->ip;
						}
						continue;
					default:
						continue;
					}
					break;
				}
				op = strcopy(op, ")");
				flags |= (1L<<28);
				proto->line = line;
				call = 0;
				break;
			}
 
		case (0401+0):
 fsm_id:

			if (flags & (1L<<0))
			{
				if (!args && paren == 1) args++;
				break;
			}

			if (paren == 0)
			{
				if (last == ')')
				{
					if (proto->brace == 0 && !(flags & (1L<<1))) flags |= (1L<<23);
					call = !call;
				}
				else if ((flags & (1L<<23)) || c == (0401+0) || c == ((0500+4)+30)) call++;
				else flags |= (1L<<23);
				if (last == (0401+0)) flags |= (1L<<7);
			}
			c = (0401+0);
			flags |= (1L<<25);
			break;
		case (0401+1):
			if (*proto->tp >= '0' && *proto->tp <= '9')
			{
				n = 0;
				for (;; op--)
				{
					switch (*(op - 1))
					{
					case 'f':
					case 'F':
						t = op;
						while ((c = *--t) >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z');
						if (*t == '.')
							op--;
						n = 0;
						break;
					case 'l':
					case 'L':
						if (!(n & 01))
						{
							n |= 01;
							t = op;
							while ((c = *--t) >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z');
							if (*t == '.')
							{
								n = 0;
								op--;
								break;
							}
						}
						continue;
					case 'u':
					case 'U':
						n |= 02;
						continue;
					}
					break;
				}
				if (n & 01)
					*op++ = 'L';
				if (n & 02)
				{
					m = op;
					t = op = m + 10;
					while ((c = *--m) >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')
						*--t = c;
					c = *t;
					strcopy(m + 1, "(unsigned)");
					*t = c;
					break;
				}
			}
			goto fsm_other;

		case '[':
			if ((flags & (1L<<0)) && paren == 0 && group <= 2) flags |= (1L<<23);
 

		default:
 fsm_other:

			if (flags & (1L<<0)) break;

			flags |= (1L<<25);
			if (paren == 0) flags |= (1L<<17);
			break;
		}
		else if (c == '#' && *ip != '(') flags |= (1L<<22);
		last = c;

		if ((flags & ((1L<<5)|(1L<<15))) == ((1L<<5)|(1L<<15)) && ((flags & ((1L<<3)|(1L<<23))) || proto->brace || c != '(' && c != ')' && c != '*' && c != (0401+0)))
			(op=proto->op);
		else

		(proto->op=op);
		goto fsm_start;
	}
	else if (flags & ((1L<<10)|(1L<<11)))
	{

		if ((flags & (1L<<29)) && c == '%' && *ip == '{') t = 0;
		else

		{
			if (c == '#') for (t = ip; *t == ' ' || *t == '\t'; t++);
			else t = "";
			if (*t++ == 'i' && *t++ == 'f' && *t++ == 'n' && *t++ == 'd' && *t++ == 'e' && *t++ == 'f')
			{




					t = 0;
			}
		}
		if (t)
		{
			ip = bp;
			op = proto->op;
		}
		else while (*ip != '\n') *op++ = *ip++;
		op = init(proto, op, flags);
		op = linesync(proto, op, proto->line);
		flags &= ~((1L<<10)|(1L<<11));
		proto->flags &= ~((1L<<10)|(1L<<11));
		goto fsm_start;
	}
	do{(proto->ip=ip);(proto->op=op);proto->flags&=~((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->flags|=flags&((1L<<5)|(1L<<9)|(1L<<17)|(1L<<27)|(1L<<28));proto->call=call;}while(0);
	return c;
}

 



void
pppclose __PARAM__((char* iob), (iob)) __OTORP__(char* iob;){
	register struct proto*	proto = (struct proto*)(iob - sizeof(struct proto));

	if (proto->flags & (1L<<16)) close(proto->fd);
	free((char*)proto);  
}

 
#line 2007
char*
pppopen __PARAM__((char* file, int fd, char* notice, char* options, char* package, char* comment, int flags), (file, fd, notice, options, package, comment, flags)) __OTORP__(char* file; int fd; char* notice; char* options; char* package; char* comment; int flags;){
	register struct proto*	proto;
	register char*		iob;
	register long		n;
	register char*		s;
	int			pragma;
	char*			b;

	int			comlen;
	char			com[80];

	int			m = 0;

	static int		retain;

 




	if (flags & (1<<0)) flags &= ~(1<<5);

	if (flags & (1<<11)) flags &= ~retain;
	else retain &= (1<<6);
	if (file && (fd = open(file, O_RDONLY)) < 0) return 0;






















	{
 



		n = (8*1024);
		if (!(proto = (( 0)?( struct proto*)realloc((char*)( 0),sizeof( struct proto)*( 1)+( 5 * n + 2)):( struct proto*)calloc(1,sizeof( struct proto)*( 1)+( 5 * n + 2)))))
			return 0;
		proto->iz = n;
		proto->oz = 3 * n;
		proto->flags |= (1L<<16);
	}
	proto->fd = fd;
	proto->package = package;
	iob = (char*)proto + sizeof(struct proto);
	proto->op = proto->ob = iob;
	proto->ip = proto->ib = iob + proto->oz + n;
	if (m) proto->options |= (1L<<0);
	if (!comment)
		comment = "/*";
	if (!(proto->cc[0] = comment[0]))
		notice = options = 0;
	else if (comment[1])
	{
		proto->cc[1] = comment[1];
		proto->cc[2] = comment[2] ? comment[2] : comment[0];
	}
	else
		proto->cc[1] = proto->cc[2] = comment[0];

 



	n = read(fd, proto->ip, proto->iz);
	if (!(proto->flags & (1L<<16)))
		close(fd);
	if (n < 0)
	{
		pppclose(iob);
		return 0;
	}
	*(proto->ip + n) = 0;

 
#line 2112
	if (!notice && !options || (comlen = astlicense(com, sizeof(com), ((char*)0), "type=check", proto->cc[0], proto->cc[1], proto->cc[2])) <= 0)
		*com = 0;

	pragma = -1;
	s = proto->ip;
	m = 64;
	while (m-- > 0 && *s)
	{
		while (*s == ' ' || *s == '\t') s++;
		if (*s == '#')
		{
			b = s++;
			while (*s == ' ' || *s == '\t') s++;
			if (!sstrncmp( s, "pragma", sizeof("pragma") - 1) && (*(s += sizeof("pragma") - 1) == ' ' || *s == '\t'))
			{
				while (*s == ' ' || *s == '\t') s++;
				if (*s == 'n' && *(s + 1) == 'o')
				{
					s += 2;
					pragma = -2;
				}
				if (!sstrncmp( s, "prototyped", sizeof("prototyped") - 1) && (*(s += sizeof("prototyped") - 1) == ' ' || *s == '\t' || *s == '\n' || *s == '\r'))
					while (*s)
					{
						if ((*(s - 1) == ' ' || *(s - 1) == '\t') && *s == *"noticed"&& !sstrncmp( s, "noticed", sizeof("noticed") - 1))
							notice = options = 0;
						if (*s++ == '\n')
						{
							pragma += 2;

							if (!(flags & (1<<1)) || (flags & (1<<8)))

							for (s--; b < s; *b++ = ' ');
							goto magic;
						}
					}
				pragma = -1;
			}
		}
		else if (*s == '/' && !sstrncmp( s, "/* : : generated by proto : : */\n", sizeof("/* : : generated by proto : : */\n") - 1))
		{
			pragma = 0;
			break;
		}

		else if (*s == '%' && *(s + 1) == '{')
			proto->flags |= (1L<<29);
		if (notice || options)
		{
			if (*s == *com && !sstrncmp( s, com, comlen))
				notice = options = 0;
			else
				while (*s)
				{
					if (*s == *"Copyright"&& !sstrncmp( s, "Copyright", sizeof("Copyright") - 1))
					{
						s += sizeof("Copyright") - 1;
						while (*s == ' ' || *s == '\t')
							s++;
						if (*s == '(' && (*(s + 1) == 'c' || *(s + 1) == 'C') && *(s + 2) == ')' || *s >= '0' && *s <= '9' && *(s + 1) >= '0' && *(s + 1) <= '9')
						{
							notice = options = 0;
							break;
						}
					}
					else if (*s++ == '\n')
					{
						s--;
						break;
					}
				}
		}

		while (*s && *s++ != '\n');
	}
 magic:
	if (flags & (1<<10)) proto->flags |= (1L<<20);
	if (flags & (1<<12)) proto->test = 1;
	if (flags & (1<<2)) proto->options |= (1L<<6);

	if (flags & (1<<0)) pragma = -pragma;
	if (flags & (1<<1)) pragma = 0;
	if (flags & (1<<7)) proto->flags |= (1L<<13);
	if (!(proto->flags & (1L<<29)) && file && (m = sstrlen( file)) > 2 && file[--m] == 'y' && file[--m] == '.')
		proto->flags |= (1L<<29);

	if (pragma <= 0)
	{
		if (flags & (1<<10))
		{
			flags &= ~((1<<4)|(1<<5));
			proto->flags |= (1L<<19);
		}
		else if (!(flags & ((1<<3)|(1<<9))))
		{
			pppclose(iob);
			return 0;
		}
		else if ((flags & ((1<<3)|(1<<9))) == (1<<9) || !pragma)
		{
			proto->flags |= (1L<<18);
			if (proto->flags & (1L<<16))
				proto->oz += proto->iz;
			proto->iz = n;
			if (notice || options)
			{
				if (proto->cc[0] == '#' && proto->ip[0] == '#' && proto->ip[1] == '!')
				{
					s = proto->ip;
					while (*s && *s++ != '\n');
					m = s - proto->ip;
					proto->op = memcopy(proto->op, proto->ip, m);
					proto->ip = s;
					proto->iz = n -= m;
				}

				if (proto->cc[0])
				{
					if ((comlen = astlicense(proto->op, proto->oz, notice, options, proto->cc[0], proto->cc[1], proto->cc[2])) < 0)
						proto_error((char*)proto + sizeof(struct proto), 1, proto->op, ((char*)0));
					else
						proto->op += comlen;
				}
				if (!(flags & (1<<0)) && !(proto->flags & (1L<<29)))

				proto->op = linesync(proto, proto->op, 1);
				proto->iz += proto->op - proto->ob;
			}
			memcopy(proto->op, proto->ip, n);
			return iob;
		}
	}

	if (!(retain & (1<<6)))
	{
		retain |= (1<<6);
		ppfsm(4, ((char*)0));
	}

	proto->line = 1;

	if (notice || options || (flags & ((1<<4)|(1<<5))))
	{

		if (notice || options)
		{
			if ((comlen = astlicense(proto->op, proto->oz, notice, options, proto->cc[0], proto->cc[1], proto->cc[2])) < 0)
				proto_error((char*)proto + sizeof(struct proto), 1, proto->op, ((char*)0));
			else
				proto->op += comlen;
		}

		if (flags & (1<<5))
		{
			proto->flags |= (1L<<11);
			if (flags & (1<<11))
				retain |= (1<<5);
		}
		else if (flags & (1<<4))
		{
			if (flags & (1<<11)) retain |= (1<<4);

			if (flags & (1<<0))
			{
				*proto->op++ = '#';
				proto->op = strcopy(proto->op, "pragma");
				*proto->op++ = ' ';
				proto->op = strcopy(proto->op, "prototyped");
				*proto->op++ = '\n';
			}
			else

			proto->flags |= (1L<<10);
		}

		if (!(flags & (1<<0)))
		{
			if (proto->flags & (1L<<29))
			{
				proto->op = strcopy(proto->op, "\n%{\n"+ !notice);
				proto->op = strcopy(proto->op, "/* : : generated by proto : : */\n");
				proto->op = strcopy(proto->op, "%}\n");
			}
			else
			{
				if (n || notice || options)
					*proto->op++ = '\n';
				proto->op = strcopy(proto->op, "/* : : generated by proto : : */\n");
				if (n)
					proto->op = linesync(proto, proto->op, proto->line);
				else if (proto->flags & ((1L<<10)|(1L<<11)))
					proto->op = init(proto, proto->op, proto->flags);
			}
		}

	}


	proto->file = file;
	if (flags & (1<<0))
	{
		proto->flags |= (1L<<0);
		if (!(flags & (1<<4))) proto->flags |= (1L<<5);
	}

	return iob;
}

 




int
pppread __PARAM__((char* iob), (iob)) __OTORP__(char* iob;){
	register struct proto*	proto = (struct proto*)(iob - sizeof(struct proto));
	register int		n;

	if (proto->flags & (1L<<18))
	{
		if (proto->iz)
		{
			n = proto->iz;
			proto->iz = 0;
		}
		else if (!(proto->flags & (1L<<16))) n = 0;
		else if ((n = read(proto->fd, proto->ob, proto->oz)) <= 0 || (proto->options & (1L<<0)) && n < proto->oz)
		{
			proto->flags &= ~(1L<<16);
			close(proto->fd);
		}
	}
	else
	{
		if (proto->op == proto->ob)
		{
			if (proto->flags & (1L<<4)) return -1;

			if (proto->flags & (1L<<29))
			{
				register char*	ip = proto->ip;
				register char*	op = proto->ob;
				register char*	ep = proto->ob + proto->oz - 2;

				if (!*ip)
				{
					ip = proto->ip = proto->ib;
					if (!(proto->flags & (1L<<16))) n = 0;
					else if ((n = read(proto->fd, ip, proto->iz)) <= 0 || (proto->options & (1L<<0)) && n < proto->iz)
					{
						if (n < 0) n = 0;
						proto->flags &= ~(1L<<16);
						close(proto->fd);
					}
					ip[n] = 0;
				}
				if (proto->flags & (1L<<30))
				{
					proto->flags &= ~(1L<<30);
					if (*ip == '%')
					{
						*op++ = *ip++;
						if (proto->flags & (1L<<31)) proto->flags &= ~(1L<<29);
						else proto->flags |= (1L<<31);
					}
				}
				if (proto->flags & (1L<<29))
					while (op < ep && (n = *op++ = *ip))
					{
						ip++;
						if (n == '%')
						{
							if (*ip == '%' && (ip == proto->ip + 1 || *(ip - 2) == '\n'))
							{
								*op++ = *ip++;
								if (proto->flags & (1L<<31)) proto->flags &= ~(1L<<29);
								else proto->flags |= (1L<<31);
								break;
							}
							if (!*ip)
							{
								*op++ = '%';
								proto->flags |= (1L<<30);
								break;
							}
						}
						else if (n == '\n') proto->line++;
					}
				proto->op = memcopy(proto->ob, proto->ip, ip - proto->ip);
				proto->ip = ip;
			}
			else

			lex(proto, proto->flags);
			if ((proto->flags & ((1L<<4)|(1L<<16))) == (1L<<4))
				proto->op = strcopy(proto->op, "/* NOTE: some constructs may not have been converted */\n");
		}
		n = proto->op - proto->ob;
		proto->op = proto->ob;
	}
	return n;
}












#line 265 "proto.c"





static int
proto __PARAM__((char* file, char* license, char* options, char* package, char* copy, char* comment, int flags), (file, license, options, package, copy, comment, flags)) __OTORP__(char* file; char* license; char* options; char* package; char* copy; char* comment; int flags;){
	char*		b;
	char*		e;
	int		n;
	int		x;
	int		fd;
	char		buf[1024];

	if (file && access(file, 4))
		proto_error(((char*)0), 2, file, "not found");
	else if (b = pppopen(file, 0, license, options, package, comment, flags))
	{
		if (!file)
			fd = 1;
		else if (flags & ((1<<13)<<1))
		{
			e = file + sstrlen( file) - 1;
			x = *e;
			*e = '_';
			if ((fd = creat(file, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH)) < 0)
			{
				proto_error(b, 2, file, "cannot create temporary file");
				pppclose(b);
				return flags | ((1<<13)<<0);
			}
			*e = x;
		}
		else if (copy)
		{
			if (((n = sstrlen( copy)) + sstrlen( file) + 2) > sizeof(buf))
			{
				proto_error(b, 2, copy, "copy path too long");
				pppclose(b);
				return flags | ((1<<13)<<0);
			}
			strcopy( buf, copy);
			e = buf + n;
			if (*file != '/')
				*e++ = '/';
			strcopy( e, file);
			if ((fd = creat(buf, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH)) < 0)
			{
				for (e = buf; *e == '/'; e++);
				do
				{
					if (*e == '/')
					{
						*e = 0;
						if (access(buf, 0) && mkdir(buf, S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH))
						{
							proto_error(b, 2, buf, "cannot create copy directory");
							pppclose(b);
							return flags | ((1<<13)<<0);
						}
						*e = '/';
					}
				} while (*e++);
				if ((fd = creat(buf, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH)) < 0)
				{
					proto_error(b, 2, buf, "cannot create copy file");
					pppclose(b);
					return flags | ((1<<13)<<0);
				}
			}
			file = buf;
		}
		else
			fd = 1;
		if (file && (flags & ((1<<13)<<2)))
			proto_error(b, 0, "convert to", file);
		while ((n = pppread(b)) > 0)
			if (write(fd, b, n) != n)
			{
				proto_error(b, 2, "write error", ((char*)0));
				flags |= ((1<<13)<<0);
				break;
			}
		if (fd > 1)
			close(fd);
		if (file && (flags & ((1<<13)<<1)))
		{
			*e = '_';
			strcopy( b, file);
			*e = x;
			if (replace(b, file, !(flags & (1<<0))))
				proto_error(b, 2, "cannot rename to", file);
		}
		pppclose(b);
	}
	return flags;
}





typedef struct Sufcom_s
{
	char		suffix[4];
	char		comment[4];
} Sufcom_t;

static const Sufcom_t	sufcom[] =
{
	"c",		"/*",
	"cpp",		"/*",
	"cxx",		"/*",
	"c++",		"/*",
	"C",		"/*",
	"CPP",		"/*",
	"CXX",		"/*",
	"C++",		"/*",
	"f",		"C",
	"F",		"C",
	"h",		"/*",
	"hpp",		"/*",
	"hxx",		"/*",
	"H",		"/*",
	"HPP",		"/*",
	"HXX",		"/*",
	"ksh",		"#",
	"KSH",		"#",
	"l",		"/*",
	"L",		"/*",
	"p",		"(*)",
	"pas",		"(*)",
	"P",		"(*)",
	"PAS",		"(*)",
	"pl",		"#",
	"PL",		"#",
	"pl1",		"/*",
	"pli",		"/*",
	"PL1",		"/*",
	"PLI",		"/*",
	"sh",		"#",
	"SH",		"#",
	"sml",		"(*)",
	"SML",		"(*)",
	"y",		"/*",
	"Y",		"/*",
};

 



static char*
type __PARAM__((register char* file, char* comment), (file, comment)) __OTORP__(register char* file; char* comment;){
	register char*	suffix;
	register int	i;

	if (file && (!comment || !*comment))
	{
		suffix = 0;
		while (*file)
			if (*file++ == '.')
				suffix = file;
		if (suffix && sstrlen( suffix) <= 3)
			for (i = 0; i < sizeof(sufcom) / sizeof(sufcom[0]); i++)
				if (!strcmp(suffix, sufcom[i].suffix))
					return (char*)sufcom[i].comment;
	}
	return comment;
}

int
main __PARAM__((int argc, char** argv), (argc, argv)) __OTORP__(int argc; char** argv;){
	char*		b;
	char*		file;
	int		fd;
	int		n;
	char*		op;
	char*		oe;
	char*		comment = 0;
	char*		copy = 0;
	char*		list = 0;
	char*		license = 0;
	char*		options = 0;
	char*		package = 0;
	int		flags = (1<<4);
	char		buf[1024];
	char		opt[4 * 1024];

	;

	while ((file = *++argv) && *file == '-' && *(file + 1))
	{
		for (;;)
		{
			switch (*++file)
			{
			case 0:
				break;
			case 'c':
				if (!*(comment = ++file))
					comment = *++argv;
				break;
			case 'd':
				flags |= (1<<1);
				continue;
			case 'e':
				if (!*(package = ++file) && !(package = *++argv))
				{
					file = "??";
					continue;
				}
				break;
			case 'f':
				flags |= (1<<3);
				continue;
			case 'h':
				flags &= ~(1<<4);
				continue;
			case 'i':
				flags |= (1<<0);
				continue;
			case 'l':
				if (!*(license = ++file) && !(license = *++argv))
				{
					file = "??";
					continue;
				}
				break;
			case 'n':
				flags |= (1<<7);
				continue;
			case 'o':
				if (!*(b = ++file) && !(b = *++argv))
				{
					file = "??";
					continue;
				}
				if (!options)
				{
					options = op = opt;
					oe = op + sizeof(opt) - 1;
				}
				n = sstrlen( b);
				if ((n + 1) >= (oe - op))
					proto_error(((char*)0), 3, b, "too many options");
				else
				{
					*op++ = '\n';
					memcopy( op, b, n + 1);
					op += n;
				}
				break;
			case 'p':
				flags |= (1<<9);
				continue;
			case 'r':
				flags |= ((1<<13)<<1);
				continue;
			case 's':
				flags |= (1<<5);
				continue;
			case 't':
				flags |= (1<<12);
				continue;
			case 'v':
				flags |= ((1<<13)<<2);
				continue;
			case 'x':
				flags |= (1<<2);
				continue;
			case 'z':
				flags |= (1<<1)|(1<<8);
				continue;
			case 'C':
				if (!*(copy = ++file) && !(copy = *++argv))
				{
					file = "??";
					continue;
				}
				break;
			case 'L':
				if (!*(list = ++file) && !(list = *++argv))
				{
					file = "??";
					continue;
				}
				break;
			case 'P':
			case '+':
				flags |= (1<<10);
				continue;
			case 'S':
				comment = "#";
				continue;
			default:
				proto_error(((char*)0), 2, file, "unknown option");
 
			case '?':
				b = "Usage: proto [-dfhinprstvzP+S] [-C directory] [-e package] [-l file]\n             [-o \"name='value' ...\"] [-L file] file ...\n";
				write(2, b, sstrlen( b));
				return 2;
			}
			break;
		}
	}





























































































	if (list)
	{
		if (*list == '-' && !*(list + 1))
			fd = 0;
		else if ((fd = open(list, O_RDONLY)) < 0)
			proto_error(((char*)0), 3, list, "not found");
		do
		{
			for (b = buf; (n = read(fd, b, 1)) > 0 && *b != '\n' && b < &buf[sizeof(buf) - 1]; b++);
			if (b > buf)
			{
				*b = 0;
				flags = proto(buf, license, options, package, copy, type(buf, comment), flags);
			}
		} while (n > 0);
		if (fd > 0)
			close(fd);
	}
	if (file)
		do flags = proto(file, license, options, package, copy, type(file, comment), flags); while (file = *++argv);
	else if (!list)
		flags = proto(file, license, options, package, copy, type(file, comment), flags);
	return errors ? 1 : (flags & ((1<<13)<<0)) ? 2 : 0;
}
