/*
	configuration.cpp - Configuration
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "configuration.h"
#include "mmainwindow.h"

#include <qspinbox.h>
#include <qtabwidget.h>

#include <kapplication.h>
#include <kconfig.h>

void Config::read()
{
	KConfig *conf = kapp->config();

	// main window
	conf->setGroup("MainWindow");
	mainWindow->getTabs()->setCurrentPage(conf->readNumEntry("CurrentTab", 0));

	// general
	conf->setGroup("Time");
	timeRemember = conf->readBoolEntry("Remember", DEFAULT_TIME_REMEMBER);

	// automation
	conf->setGroup("Automation");
	cdTrayClose = conf->readBoolEntry("CDTrayClose", DEFAULT_CD_TRAY_CLOSE);
	cdTrayCloseCommand = conf->readEntry("CDTrayCloseCommand", DEFAULT_CD_TRAY_CLOSE_COMMAND);

	// confirmations
	conf->setGroup("Notification Messages");
	confirmAction = conf->readEntry("ShutDown", "").isEmpty();
	conf->setGroup("Popup Messages");
	popupMessages = conf->readBoolEntry("Enabled", DEFAULT_POPUP_MESSAGES);
	popupTimeout = conf->readNumEntry("Timeout", DEFAULT_POPUP_TIMEOUT);
	if (popupTimeout < 2)
		popupTimeout = DEFAULT_POPUP_TIMEOUT;
	conf->setGroup("Warning Message");
	warningMessageEnabled =
		conf->readBoolEntry("Enabled", DEFAULT_WARNING_MESSAGE_ENABLED);
	warningMessageDelay =
		conf->readNumEntry("Delay", DEFAULT_WARNING_MESSAGE_DELAY);
	if (warningMessageDelay < 0 || warningMessageDelay > 60)
		warningMessageDelay = DEFAULT_WARNING_MESSAGE_DELAY;
	conf->setGroup("Custom Message");
	customMessageEnabled = conf->readBoolEntry("Enabled", DEFAULT_CUSTOM_MESSAGE_ENABLED);
	customMessageCommand = conf->readEntry("Command", DEFAULT_CUSTOM_MESSAGE_COMMAND);

	// scheduler
	conf->setGroup("Scheduler");
	schedEnabled = conf->readBoolEntry("Enabled", DEFAULT_SCHED_ENABLED);

	// statistics
	conf->setGroup("Statistics");
	statsLongFormat = conf->readBoolEntry("LongFormat", DEFAULT_STATS_LONG_FORMAT);
	statsToggleFromField = conf->readBoolEntry("ToggleFromField", DEFAULT_STATS_TOGGLE_FROM_FIELD);

	// main window time options
	int i;
	conf->setGroup("Time");
	if (timeRemember)
	{
		i = conf->readNumEntry("DelayType", MMainWindow::DelayType_Now);
		if (
			i >= MMainWindow::DelayType_Now &&
			i <= MMainWindow::DelayType_DateTime
		)
			mainWindow->setDelayType((MMainWindow::DelayType)i);
		else
			mainWindow->setDelayType(MMainWindow::DelayType_Now);

		i = conf->readNumEntry("Delay", 0);
		mainWindow->delay()->setValue(i);
		i = conf->readNumEntry("DelayMisc", MMainWindow::DelayMisc_Seconds);
		if (
			i >= MMainWindow::DelayMisc_Seconds &&
			i <= MMainWindow::DelayMisc_Hours
		)
			mainWindow->setDelayMisc((MMainWindow::DelayMisc)i);
		else
			mainWindow->setDelayMisc(MMainWindow::DelayMisc_Seconds);

		if (mainWindow->getDelayType() == MMainWindow::DelayType_TimeFromNow)
		{
			QDateTime defTime(QDate::currentDate(), QTime(0, 0, 0));
			QDateTime confTime = conf->readDateTimeEntry("DelayTime", &defTime);
			mainWindow->setTime(confTime.time());
		}
		else if (mainWindow->getDelayType() == MMainWindow::DelayType_DateTime)
		{
			mainWindow->setTime(QTime::currentTime());
		}
	}
	else
	{
		mainWindow->setDelayType(MMainWindow::DelayType_Now);
		mainWindow->setDelayMisc(MMainWindow::DelayMisc_Seconds);
	}
}

void Config::write()
{
	KConfig *conf = kapp->config();

	// main window
	conf->setGroup("MainWindow");
	conf->writeEntry("CurrentTab", mainWindow->getTabs()->currentPageIndex());

	// general
	conf->setGroup("Time");
	conf->writeEntry("Remember", timeRemember);

	// automation
	conf->setGroup("Automation");
	conf->writeEntry("CDTrayClose", cdTrayClose);
	conf->writeEntry("CDTrayCloseCommand", cdTrayCloseCommand);

	// confirmations
	conf->setGroup("Popup Messages");
	conf->writeEntry("Enabled", popupMessages);
	conf->writeEntry("Timeout", popupTimeout);
	conf->setGroup("Warning Message");
	conf->writeEntry("Enabled", warningMessageEnabled);
	conf->writeEntry("Delay", warningMessageDelay);
	conf->setGroup("Custom Message");
	conf->writeEntry("Enabled", customMessageEnabled);
	conf->writeEntry("Command", customMessageCommand);

	// scheduler
	conf->setGroup("Scheduler");
	conf->writeEntry("Enabled", schedEnabled);

	// statistics
	conf->setGroup("Statistics");
	conf->writeEntry("LongFormat", statsLongFormat);
	conf->writeEntry("ToggleFromField", statsToggleFromField);

	// main window time options
	conf->setGroup("Time");
	if (timeRemember)
	{
		conf->writeEntry("Delay", mainWindow->delay()->value());
		conf->writeEntry("DelayMisc", mainWindow->getCurrentDelayMisc());
		if (mainWindow->getDelayType() == MMainWindow::DelayType_TimeFromNow)
		{
			conf->writeEntry("DelayTime", QDateTime(QDate::currentDate(),
				mainWindow->getTime()));
		}
		conf->writeEntry("DelayType", mainWindow->getCurrentDelayType());
	}

	conf->sync(); // save all changes to disk now!
}
