/*
	mmessagedialog.cpp - message dialog
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "mmessagedialog.h"
#include "msystemtray.h"

#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlcdnumber.h>
#include <qtimer.h>
#include <qtooltip.h>

#include <klocale.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>
#include <kwin.h>

/* constructor */

MMessageDialog::MMessageDialog(const bool modal, const int delay,
	const MMainWindow::What actionToExecute, const QString &text,
	QWidget *parent, const char *name)
	: KDialog(parent, name, modal),
	_dialogDelay(delay * 60),
	_lastTime(-1),
	_action(actionToExecute)
{
	QColor black(0, 0, 0);
	QColor yellow(255, 255, 0);

	setCaption(i18n("Message"));
	setPaletteBackgroundColor(yellow);
	setPaletteForegroundColor(black);

	// init widgets

	// main layout
	QVBoxLayout *mainLayout = new QVBoxLayout(this, 2);

	// message text
	QLabel *t_message = new QLabel(this, "MTip::t_message");
	t_message->setPaletteBackgroundColor(yellow);
	t_message->setPaletteForegroundColor(black);
	t_message->setAlignment(AlignCenter);
	t_message->setFrameShape(QFrame::StyledPanel);
	t_message->setFrameShadow(QFrame::Plain);
	t_message->setLineWidth(4);
	t_message->setMargin(20);
	t_message->setText(text);
	mainLayout->addWidget(t_message);

	// -
	mainLayout->addStretch();

	// bottom layout
	QHBox *bottomBox = new QHBox(this);
	bottomBox->setSpacing(4);

	// seconds
	l_seconds = new QLCDNumber(bottomBox, "QLCDNumber::l_seconds");
	l_seconds->display(_dialogDelay);
	l_seconds->setSegmentStyle(QLCDNumber::Flat);
	QToolTip::add(l_seconds, i18n("Remaining time"));

	// continue button
	KPushButton *b_continue = new KPushButton(
		mainWindow->getActionIcon(_action),
		mainWindow->getActionName(_action),
		bottomBox, "KPushButton::b_continue"
	);
	b_continue->setPaletteBackgroundColor(yellow);
	b_continue->setPaletteForegroundColor(black);
	connect(
		b_continue, SIGNAL(clicked()),
		this, SLOT(accept()));

	// cancel button
	KPushButton *b_cancel = new KPushButton(KStdGuiItem::cancel(), bottomBox,
		"KPushButton::b_cancel");
	b_cancel->setDefault(TRUE);
	b_cancel->setPaletteBackgroundColor(yellow);
	b_cancel->setPaletteForegroundColor(black);
	connect(
		b_cancel, SIGNAL(clicked()),
		this, SLOT(reject()));

	mainLayout->addWidget(bottomBox);

	// init timer
	_timer = new QTimer(this);
	connect(
		_timer, SIGNAL(timeout()),
		this, SLOT(timerSlot()));
	_timer->start(500);

	resize(320, 200);

	// make sure it is visible
	// code from KAlarm
	WId id = winId();
	unsigned long state = NET::StaysOnTop | NET::Sticky;
	KWin::setState(id, state);
	KWin::setOnAllDesktops(id, TRUE);
}

/* destructor */

MMessageDialog::~MMessageDialog()
{
}

/* public */

void MMessageDialog::cancelAction()
{
	reject();
}

/* protected slots */

void MMessageDialog::done(int r)
{
	_timer->stop();

	mainWindow->tray()->hidePopupMessages();

	// application scheduler ..
	if (
		!mainWindow->actionCancelled() &&
		!isModal() &&
		(r == QDialog::Accepted)
	)
	{
		// don't stop timer, because it may be still used in the
		// main window's loop
		mainWindow->execAction(_action, FALSE);
	}

	KDialog::done(r);
}

/* private slots */

void MMessageDialog::timerSlot()
{
	QTime t = QTime::currentTime();

	if (t.second() == _lastTime)
		return;

	l_seconds->display(_dialogDelay);

	// action cancelled?
	if (mainWindow->actionCancelled())
	{
		cancelAction();

		return;
	}

	// timeout?
	if (_dialogDelay == 0)
	{
		accept();

		return;
	}

	mainWindow->notifyUser(_dialogDelay);

	_lastTime = t.second();
	_dialogDelay--;
}
