/*
	mschedulertab.h - scheduler tab
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MSCHEDULERTAB_H__
#define __MSCHEDULERTAB_H__

#include <qwidget.h>

class QLabel;
class QListView;

class KPushButton;

/** @short Scheduler tab. */
class MSchedulerTab: public QWidget
{
	Q_OBJECT
public:
	/**
	 * Constructor.
	 * @param parent A parent widget
	 * @param name A widget name
	 */
	MSchedulerTab(QWidget *parent = 0, const char *name = 0);

	/** Destructor. */
	virtual ~MSchedulerTab();

	/** Initializes some widgets. */
	void initOnDemand();

	/** Updates list and all its widgets. */
	void update();
private:
	bool
		_initDone,
		_listUpdate;
	KPushButton
		*b_remove,
		*b_removeAll;
	QLabel *l_registeredTasks;
	QListView *_list;
	inline bool listUpdate() const { return _listUpdate; }
	inline void setListUpdate(const bool yes) { _listUpdate = yes; }
private slots:
	/** Removes all tasks. */
	void removeAllSlot();

	/** Removes the selected task. */
	void removeSlot();
};

#endif // __MSCHEDULERTAB_H__
