/*
	msettingsdialog.h - settings dialog
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MSETTINGSDIALOG_H__
#define __MSETTINGSDIALOG_H__

#include "mmainwindow.h"

#include <kdialogbase.h>
#include <knotifydialog.h>

class QCheckBox;
class QListView;

class KIntNumInput;
class KPushButton;

/** @short Settings dialog. */
class MSettingsDialog: public KDialogBase
{
	Q_OBJECT
public:
	/**
	 * Constructor. Creates a new modal settings dialog.
	 * @param parent A parent widget
	 * @param name A widget name
	 */
	MSettingsDialog(QWidget *parent = 0, const char *name = 0);

	/** Destructor. */
	virtual ~MSettingsDialog();
private:
	// general
	QCheckBox *c_timeRemember;
	QCheckBox *c_schedulerEnabled;
	KPushButton
		*b_lockScreenSettings,
		*b_logoutSettings;
	// notify
	KNotify::KNotifyWidget *_notifyWidget; // based on k3b
	// automation
	QCheckBox *c_autoLock;
	QCheckBox *c_cdTrayClose;
	KLineEdit *in_cdTrayCloseCommand;
	// messages
	QCheckBox *c_confirmAction;
	KPushButton *b_enableAllMessages;
	QCheckBox *c_popupMessages;
	KIntNumInput *in_popupTimeout;
	QCheckBox *c_warningMessageEnabled;
	KIntNumInput *in_warningMessageDelay;
	QCheckBox *c_customMessageEnabled;
	KLineEdit *in_customMessageCommand;
	// actions
	QListView *_actions;
	QListViewItem
		*_lockScreenItem,
		*_logoutItem,
		*_rebootItem,
		*_shutDownItem;
	// stats
	QCheckBox
		*c_statsLongFormat,
		*c_statsToggleFromField;

	QFrame
		*_actionsPage,
		*_autoPage,
		*_generalPage,
		*_messagesPage,
		*_notifyPage,
		*_statsPage;

	QFrame *addPage(const QString &itemName, const QString &iconName);

	/**
	 * Returns @c TRUE if page is disabled by the administrator (Kiosk).
	 * @param key A configuration entry (in kshutdownrc file)
	 * @param page A dialog page
	 * @param pageLayout A dialog page layout
	 */
	bool disabledByAdmin(const QString &key, QFrame *page = 0,
		QBoxLayout *pageLayout = 0) const;

	void initActionsPage();
	void initAutoPage();
	void initGeneralPage();
	void initMessagesPage();
	void initNotifyPage();
	void initStatsPage();

	/**
	 * Changes the action method.
	 * @param configEntry A configuration entry (in kshutdownrc file)
	 * @param method A new method
	 * @param command A new command
	 */
	void setActionMethod(const QString &configEntry,
		const MMainWindow::Method method, const QString &command) const;

	void setConfigChanged(const bool value);

	/** Sets warning message option to @p on, and its delay to @p delay. */
	void setWarningMessage(const bool on, const int delay);

	void updateActions();
	void updateItem(QListViewItem *item);
private slots:
	void configChangeSlot();
	void customMessageTestSlot();
	void editActionSlot();
	void enableAllMessagesSlot();
	void enableLockSettingsButtonSlot();
	void enableLogoutSettingsButtonSlot();
	void lockSettingsSlot();
	void logoutSettingsSlot();
	void modifyExtrasSlot();
	void okClickedSlot();
	void popupMessagesTestSlot();
	void seeAlsoClickedSlot();
	void updateWarningMessageSlot();
	void warningMessageTestSlot();
protected slots:
	/** Sets default values in a current page. */
	virtual void slotDefault();
};

#endif // __MSETTINGSDIALOG_H__
