/*
	msettingsdialog.h - A settings dialog
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MSETTINGSDIALOG_H__
#define __MSETTINGSDIALOG_H__

#include "actions.h"

#include <kdialogbase.h>

class QCheckBox;
class QHButtonGroup;

class KConfigDialogManager;
class KListView;
class KListViewItem;
class KPushButton;

/** @short A settings dialog. */
class MSettingsDialog: public KDialogBase
{
	Q_OBJECT
public:
	/**
	 * Constructor. Creates a new modal settings dialog.
	 * @param parent A parent widget
	 */
	MSettingsDialog(QWidget *parent);

	/**
	 * Destructor.
	 */
	virtual ~MSettingsDialog();
private:
	static int _lastPage;
	KConfigDialogManager *_configDialogManager;
	KListView *_actions;
	KListViewItem
		*_lockScreenItem,
		*_logoutItem,
		*_rebootItem,
		*_shutDownItem;
	KPushButton *b_enableAllMessages;
	QCheckBox *c_autoLock;
	QFrame
		*_actionsPage,
		*_advancedPage,
		*_generalPage,
		*_messagesPage;
	QHButtonGroup *gb_systemTray;

	QFrame *addPage(const QString &itemName, const QString &iconName);

	/**
	 * Returns @c true if page has been disabled by the administrator (Kiosk mode).
	 * @param key A configuration entry (in the @c kshutdownrc file)
	 * @param page A dialog page
	 * @param pageLayout A dialog page layout
	 */
	bool disabledByAdmin(const QString &key, QFrame *page = 0, QBoxLayout *pageLayout = 0) const;

	void initActionsPage();
	void initAdvancedPage();
	void initGeneralPage();
	void initMessagesPage();
	Action::Type itemToActionType(const KListViewItem *item) const;
	void updateActions();
	void updateItem(KListViewItem *item);
private slots:
	void slotCheckSystemConfig();
	void slotConfigChanged();
	void slotCustomMessageTest();
	void slotEditAction();
	void slotEnableAllMessages();
	void slotKDESettings();
	void slotOKClicked();
	void slotShutDownProblem();
	void slotTrayMessageProblem();
	void slotWarningMessageTest();
protected slots:
	/**
	 * Sets default values in a current page.
	 */
	virtual void slotDefault();
};

#endif // __MSETTINGSDIALOG_H__
