/*****************************************************************

Copyright (c) 2001 Carsten Pfeiffer <pfeiffer@kde.org>
              2001 Matthias Elter   <elter@kde.org>
              2001 Martijn Klingens <mklingens@yahoo.com>

              KShutDown Branch:
              2005 Stephen Ellwood
              2005 Konrad Twardowski <kdtonline@poczta.onet.pl>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

// TODO: 2.0: update handbook

#include <sys/types.h>

#include "lockout.h"

#include <qlayout.h>
#include <qtoolbutton.h>
#include <qtooltip.h>

#include <dcopclient.h>
#include <kaction.h>
#include <kapplication.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpopupmenu.h>
#include <kprocess.h>
#include <krun.h>

// plugin

#if !KDE_IS_VERSION(3,3,2)
#undef KDE_EXPORT
#define KDE_EXPORT
#endif

extern "C"
{
	KDE_EXPORT KPanelApplet *init(QWidget *parent, const QString& configFile)
	{
		// share i18n with KShutDown
		KGlobal::locale()->insertCatalogue("kshutdown");

		return new Lockout(configFile, parent);
	}
}

// public

Lockout::Lockout(const QString& configFile, QWidget *parent)
	: KPanelApplet(
		configFile,
		KPanelApplet::Normal,
		0, // no standard actions
		parent,
		"kshutdownlockout"
	)
{
	setBackgroundOrigin(AncestorOrigin);
	setFrameStyle(Panel | Sunken);

	initActions();

	KPopupMenu *pm_actions = new KPopupMenu(this);
	pm_actions->insertTitle(SmallIcon("messagebox_warning"), i18n("No Delay"));
	_shutDownAction->plug(pm_actions);
	_rebootAction->plug(pm_actions);
	_lockScreenAction->plug(pm_actions);
	_logoutAction->plug(pm_actions);
	//pm_actions->insertSeparator();
	//!!!_cancelAction->plug(pm_actions);
	pm_actions->insertSeparator();
	_configureKShutDownAction->plug(pm_actions);

	QVBoxLayout *layout = new QVBoxLayout(this);
	QToolButton *button = new QToolButton(this);
	button->setAutoRaise(true);
	button->setBackgroundMode(X11ParentRelative);
	button->setPixmap(SmallIcon("kshutdown"));
	button->setPopupDelay(100);
	button->setMinimumSize(button->pixmap()->size());
	button->setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding));
	connect(button, SIGNAL(clicked()), this, SLOT(slotShowKShutDown()));

	button->setPopup(pm_actions);
	layout->addWidget(button);

/*	// read configuration
	KConfig *config = this->config();
	config->setGroup("kshutdownlockout");
	_transparent = config->readBoolEntry("Transparent", true);
*/
	if (!kapp->dcopClient()->isAttached())
		kapp->dcopClient()->attach();
	connect(kapp, SIGNAL(iconChanged(int)), SLOT(slotIconChanged()));

	QToolTip::add(
		this,
		"<qt>" \
		"<b>KShutDown</b><br><br>" +
		i18n("Click for KShutDown main window<br>Click and hold for menu") +
		"</qt>"
	);
}

Lockout::~Lockout()
{
	KGlobal::locale()->removeCatalogue("kshutdown");
}

int Lockout::heightForWidth(int/* width*/) const
{
	return sizeHint().height();
}

int Lockout::widthForHeight(int/* height*/) const
{
	return sizeHint().width();
}

// private

void Lockout::callKShutDown(const QCString &function) {
	DCOPClient *client = kapp->dcopClient();
	if (!client->isApplicationRegistered("kshutdown")) {
		// run KShutDown
		KProcess *p = new KProcess();
		if (!p) {
			KMessageBox::error(0, i18n("Could not run KShutDown!"));

			return;
		}
		*p << "kshutdown";
		*p << "--init";
		if (!p->start(KProcess::Block))
			KMessageBox::error(0, i18n("Could not run KShutDown!"));
		delete p;
	}
	client->send("kshutdown", "KShutdownIface", function, "");
}

void Lockout::initActions() {
	KActionCollection *ac_shutDown = new KActionCollection(this, this);

	_lockScreenAction = new KAction(
		i18n("Lock Screen"), "lock", KShortcut(),
		this, SLOT(slotLockScreen()),
		ac_shutDown, "kshutdown_lockscreen"
	);//!!!authorize

	_logoutAction = new KAction(
		i18n("End Current Session"), "undo", KShortcut(),
		this, SLOT(slotLogout()),
		ac_shutDown, "kshutdown_logout"
	);

	_rebootAction = new KAction(
		i18n("Restart Computer"), "reload", KShortcut(),
		this, SLOT(slotReboot()),
		ac_shutDown, "kshutdown_reboot"
	);

	_shutDownAction = new KAction(
		i18n("Turn Off Computer"), "exit", KShortcut(),
		this, SLOT(slotShutDown()),
		ac_shutDown, "kshutdown_shutdown"
	);

	// standard actions

	_cancelAction = new KAction(
		i18n("C&ancel"), "cancel", KShortcut(Key_Escape),
		this, SLOT(slotCancel()),
		ac_shutDown, "kshutdown_cancelaction"
	);

	_configureKShutDownAction = new KAction(
		i18n("&Configure KShutDown..."), "configure", KShortcut(),
		this, SLOT(slotConfigureKShutDown()),
		ac_shutDown, "options_configure"
	);
}

void Lockout::runCommand(const QString &command) {
	pid_t pid = KRun::run(command, KURL::List());
	if (!pid)
		KMessageBox::error(0, i18n("Could not run KShutDown!"));
}

// private slots

void Lockout::slotCancel() {
	callKShutDown("cancel()");
}

void Lockout::slotConfigureKShutDown() {
	callKShutDown("configure()");
}

void Lockout::slotIconChanged() {
// FIXME: 2.0: update action icons
	setIcon(SmallIcon("kshutdown"));
}

void Lockout::slotLockScreen() {
	callKShutDown("lockScreen()");
}

void Lockout::slotLogout() {
	runCommand("kshutdown --init --confirm --logout");
}

void Lockout::slotReboot() {
	runCommand("kshutdown --init --confirm --reboot");
}

void Lockout::slotShowKShutDown() {
	callKShutDown("makeVisible()");
}

void Lockout::slotShutDown() {
	runCommand("kshutdown --init --confirm --shutdown");
}
