/***************************************************************************
 *   Copyright (C) 2004-2005 by Giovanni Venturi                           *
 *   gventuri73@tiscali.it                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <linux/if_ether.h>

#include <qstringlist.h>

//#include <kdebug.h>

#include "../packetstructures.h"
#include "../packet.h"
#include "../protocols/ip-protocol.h"
#include "../protocols/arp-protocol.h"
#include "frameprotocolmanager.h"

FrameProtocolManager::FrameProtocolManager(ptrPacketType packet, unsigned short proto)
{
  m_packet = (Packet *) packet;
  m_proto = proto;
}


QStringList FrameProtocolManager::headerLines() const
{
  IpProtocol ip(m_packet);
  ArpProtocol arp(m_packet);
  QStringList list;

  if (m_packet)
  {
    switch (m_proto)
    {
      case ETH_P_IP:
        // IP protocol
        list = ip.headerLines();
        break;
      case ETH_P_ARP:
        // ARP protocol
        list = arp.headerLines();
        break;
    }
  }

  return list;
}


QString FrameProtocolManager::getProtocol() const
{
  QString proto;

  if (m_packet)
  {
    switch (m_proto)
    {
      case ETH_P_IP:
        // IP protocol
        proto = "IP";
        break;
      case ETH_P_ARP:
        // ARP protocol
        proto = "ARP";
        break;
      default:
        proto = "";
    }
  }

  return proto;
}


u_int8_t FrameProtocolManager::getSubProtocol() const
{
  IpProtocol ip(m_packet);
  u_int8_t subproto;

  if (m_packet)
  {
    switch (m_proto)
    {
      case ETH_P_IP:
        // IP protocol
        subproto = ip.protocol();
        break;
      case ETH_P_ARP:
        // ARP protocol
        subproto = 0;
        break;
    }
  }

  return subproto;
}


QString FrameProtocolManager::strSubProtocol() const
{
  IpProtocol ip(m_packet);
  ArpProtocol arp(m_packet);
  QString subproto;

  if (m_packet)
  {
    switch (m_proto)
    {
      case ETH_P_IP:
        // IP protocol
        subproto = ip.strProtocol();
        break;
      case ETH_P_ARP:
        // ARP protocol
        subproto = arp.strProtocol();
        break;
    }
  }

  return subproto;
}
