/***************************************************************************
 *   Copyright (C) 2004-2005 by Giovanni Venturi                           *
 *   gventuri73@tiscali.it                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef _KSNIFFER_H_
#define _KSNIFFER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>
#include <kio/job.h>

#include "sniffer.h"
#include "captureoptions.h"
//#include "ksnifferiface.h"

class KToggleAction;
class KRecentFilesAction;
class KURL;
class KSnifferMainWidget;
class KSystemTray;

class KTempFile;

/**
 * This class serves as the main window for KSniffer. It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Giovanni Venturi <gventuri73@tiscali.it>
 */

class KSniffer : public KMainWindow//, virtual public KSnifferIface
{
Q_OBJECT
public:
  /**
   * Default Constructor
   */
  KSniffer();

  /**
   * Default Destructor
   */
  virtual ~KSniffer();

  KSnifferMainWidget* getMainView() { return m_mainWidgetUI; }
  KSystemTray* getSysTray() { return m_sysTray; }

  /**
   * Use this method to load whatever file/URL you have
   */
  void load(const KURL& url);

protected:
  KSnifferMainWidget* m_mainWidgetUI;
  KSystemTray* m_sysTray;
  /**
   * Overridden virtuals for Qt drag 'n drop (XDND)
   */
  virtual void dragEnterEvent(QDragEnterEvent *event);
  virtual void dropEvent(QDropEvent *event);

protected:
  /**
   * This function is called when it is time for the app to save its
   * properties for session management purposes.
   */
  void saveProperties(KConfig *);

  /**
   * This function is called when this app is restored.  The KConfig
   * object points to the session management config file that was saved
   * with @ref saveProperties
   */
  void readProperties(KConfig *);
  void readSettings();
  void writeSettings();

  /**
   * This function is called when you close main view.
   * It reimplements the virtual bool queryClose from KMainWindow
   * to leave open the application in the system tray.
   * It's a virtual protected function.
  */
  bool queryClose();

private slots:
  void slotNewCapture();
  void slotOpen( const KURL& urlParam = "");
  void slotSave();
  void slotSaveAs();
  void slotPrint();
  void slotStop();
  void slotQuit();
  void optionsShowToolbar();
  void optionsShowStatusbar();
  void optionsConfigureKeys();
  void optionsConfigureToolbars();
  void optionsPreferences();
  void applyNewToolbarConfig();

  void changeStatusbar(const QString& text);
  void changeCaption(const QString& text);

  //void copyingoldJobFinished(KIO::Job *job);
  void copyingJobFinished(KIO::Job *job);

private:
  void setupAccel();
  void setupActions();

private:
  KToggleAction *m_toolbarAction;
  KToggleAction *m_statusbarAction;

  KAction *m_actNew;                    // the action to start new network packet-capture
  KAction *m_actOpen;                   // the action to open a file
  KAction *m_actSave;                   // the action to save a file with all network captured packets
  KAction *m_actSaveAs;                 // the action to "save as" a file with all network captured packets
  KAction *m_actPrint;                  // the action to print captured packets
  KAction *m_actStop;                   // the action to stop network packet-capture
  KRecentFilesAction *m_actOpenRecent;  // the action to open recent URL
  bool m_doingCapture;                  // is true if it's sniffing

  Sniffer *m_sniffer;
  CaptureOptions *m_options;

  // we need a PacketManager to store packets and manage them for the View
  PacketManager *m_packets;

  /**
   * Constant action to known if KSniffer has to be closed in some particular action
   */
  enum {QUIT_APPL = 10, DO_NOTHING = 20};

  // the action after Job
  int m_action;

  QString m_strFilename;    // the filename to save
  KURL m_strSavedFilename;  // the filename saved
  bool m_needToSave;        // true if data needs to be saved before quit
  KTempFile *m_tmpFile;     // temporary file needed when loading a not local file
};

#endif // _KSNIFFER_H_
