/***************************************************************************
 *   Copyright (C) 2004-2005 by Giovanni Venturi                           *
 *   gventuri73@tiscali.it                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include "ksniffer.h"
#include "version.h"

#include <kuniqueapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include <kmessagebox.h>
#include <unistd.h>
#include <sys/types.h>

static const char description[] =
  I18N_NOOP("A KDE application for sniffing your computer network");

static const char version[] = APPVER;

static KCmdLineOptions options[] =
{
  //{ "+[URL]", I18N_NOOP( "Document to open" ), 0 },
  KCmdLineLastOption
};

int main(int argc, char **argv)
{
  KAboutData about("ksniffer", I18N_NOOP("KSniffer"), version, description,
                   KAboutData::License_GPL, "(C) 2004-2005 Giovanni Venturi");
  //about.addAuthor( "Giovanni Venturi", 0, "gventuri73@tiscali.it" );
  about.addAuthor( "Giovanni Venturi", I18N_NOOP("Original Author, Core Developer and Current Maintainer"), "gventuri73@tiscali.it" );
  about.addCredit("Pino Toscano", I18N_NOOP("Testing, supporting, good patches and ideas"), "toscano.pino@tiscali.it");
  about.addCredit("Luigi Toscano", I18N_NOOP("Testing, supporting, the code to stop capture in safe way"), "luigi.toscano@tiscali.it");
  about.addCredit("Alexander Neundorf", I18N_NOOP("The code for detecting network devices"), "neundorf@kde.org");

  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions(options);
  KUniqueApplication app;

  // libpcap library to sniff network needs root privileges
  if (getuid())
  {
    KMessageBox::sorry(0L, i18n("You need root privileges to run this application."));
      return -1;
  }

  // register ourselves as a dcop client
  app.dcopClient()->registerAs(app.name(), false);

  KSniffer *mainWidget = 0;

  // see if we are starting with session management
  if (app.isRestored())
  {
    RESTORE(KSniffer);
  }
  else
  {
    // no session... just start up normally
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    if (args->count() == 0)
    {
      mainWidget = new KSniffer();
      app.setMainWidget( mainWidget );
      mainWidget->show();
      args->clear();
    }
    else
    {
      int i = 0;
      for (; i < args->count(); i++)
      {
        KSniffer *mainWidget = new KSniffer();
        mainWidget->show();
        mainWidget->load(args->url(i));
      }
    }
    args->clear();
  }

  return app.exec();
}
