/***************************************************************************
 *   Copyright (C) 2004-2005 by Giovanni Venturi                           *
 *   gventuri73@tiscali.it                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef ICMPPROTOCOL_H
#define ICMPPROTOCOL_H

class Packet;
class QStringList;

#include <netinet/in.h>

class IcmpProtocol
{
  public:
    IcmpProtocol(Packet *packet);

    u_int8_t type() const;
    QString strType() const;
    u_int8_t code() const;
    u_int16_t checksum() const;
    u_int16_t id() const;
    u_int16_t sequence() const;
    QStringList headerLines() const;

  private:
    Packet *m_packet;
};

#endif
