/***************************************************************************
 *   Copyright (C) 2004-2005 by Giovanni Venturi                           *
 *   gventuri73@tiscali.it                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <netinet/in.h>

#include <qstringlist.h>

#include <klocale.h>

#include "udp-protocol.h"
#include "../packet.h"
#include "../packetstructures.h"

UdpProtocol::UdpProtocol(Packet *packet)
{
  m_packet = packet;
}


u_int16_t UdpProtocol::sourcePort() const
{
  struct UdpHdr *udp = (struct UdpHdr *) m_packet;

  return ntohs(udp->uh_sport);
}


u_int16_t UdpProtocol::destinationPort() const
{
  struct UdpHdr *udp = (struct UdpHdr *) m_packet;

  return ntohs(udp->uh_dport);
}


u_int16_t UdpProtocol::length() const
{
  struct UdpHdr *udp = (struct UdpHdr *) m_packet;

  return ntohs(udp->uh_ulen);
}


u_int16_t UdpProtocol::checksum() const
{
  struct UdpHdr *udp = (struct UdpHdr *) m_packet;

  return ntohs(udp->uh_sum);
}


QStringList UdpProtocol::headerLines() const
{
  QStringList list;

  list << i18n("UDP protocol field", "Source port: %1").arg( sourcePort() );
  list << i18n("UDP protocol field", "Destination port: %1").arg( destinationPort() );
  list << i18n("UDP protocol field", "Length: %1").arg( length() );
  list << i18n("UDP protocol field", "Checksum: 0x%1").arg( checksum(), 0, 16 );

  return list;
}
