/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <arpa/inet.h>
#include <sys/types.h>
#include <net/ethernet.h>

#include <qstring.h>
#include <qstringlist.h>

#include <klocale.h>
#include <kdebug.h>

#include "../packet.h"
#include "../packetstructures.h"
#include "ethernet2.h"

Ethernet2Frame::Ethernet2Frame(Packet *packet)
{
  m_packet = packet;
}


QString Ethernet2Frame::sourceAddress() const
{
  if (m_packet)
  {
    struct ether_header *eth = (struct ether_header *) m_packet->getPacket();

    return QString("%1:%2:%3:%4:%5:%6").arg(eth->ether_shost[0], 0, 16).arg(eth->ether_shost[1], 0, 16)
        .arg(eth->ether_shost[2], 0, 16).arg(eth->ether_shost[3], 0, 16).arg(eth->ether_shost[4], 0, 16)
        .arg(eth->ether_shost[5], 0, 16);
  }
  else
    return QString::null;
}


QString Ethernet2Frame::destinationAddress() const
{
  if (m_packet)
  {
    struct ether_header *eth = (struct ether_header *) m_packet->getPacket();

    return QString("%1:%2:%3:%4:%5:%6").arg(eth->ether_dhost[0], 0, 16).arg(eth->ether_dhost[1], 0, 16)
        .arg(eth->ether_dhost[2], 0, 16).arg(eth->ether_dhost[3], 0, 16).arg(eth->ether_dhost[4], 0, 16)
        .arg(eth->ether_dhost[5], 0, 16);
  }
  else
    return QString::null;
}


QStringList Ethernet2Frame::headerLines() const
{
  QStringList list;

  if (m_packet)
  {
    struct ether_header *eth = (struct ether_header *) m_packet->getPacket();
    list << i18n("Ethernet2 Frame Field", "MAC Source Address: %1:%2:%3:%4:%5:%6").arg(eth->ether_shost[0], 0, 16).arg(eth->ether_shost[1], 0, 16)
        .arg(eth->ether_shost[2], 0, 16).arg(eth->ether_shost[3], 0, 16).arg(eth->ether_shost[4], 0, 16)
        .arg(eth->ether_shost[5], 0, 16);
    list << i18n("Ethernet2 Frame Field", "MAC Destination Address: %1:%2:%3:%4:%5:%6").arg(eth->ether_dhost[0], 0, 16).arg(eth->ether_dhost[1], 0, 16)
        .arg(eth->ether_dhost[2], 0, 16).arg(eth->ether_dhost[3], 0, 16).arg(eth->ether_dhost[4], 0, 16).arg(eth->ether_dhost[5], 0, 16);
    list << i18n("Ethernet2 Frame Field", "Protocol Type: 0x%1").arg(htons(eth->ether_type), 0, 16);
  }

  return list;
}


unsigned short Ethernet2Frame::protocol() const
{
  struct ether_header *eth = (struct ether_header *) m_packet->getPacket();

  return htons(eth->ether_type);
}
