/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   Copyright (C) 2001 by Alexander Neundorf                              *
 *   neundorf@kde.org                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef NETWORKDEVICE_H
#define NETWORKDEVICE_H

#include <qstring.h>
#include <qstringlist.h>
#include <qptrlist.h>

class DeviceData
{
friend class NetworkDevice;

public:
  // setting functions
  void setName(const QString & str) {m_strName = str;};
  void setAddress(const QString & str) {m_strAddress = str;};
  void setNetmask(const QString & str) {m_strNetmask = str;};
  void setState(const QString & str) {m_strState = str;};
  void setType(const QString & str) {m_strType = str;};
  void setHWaddress(const QString & str) {m_strHWaddr = str;};

  // getting functions
  QString getName() const {return m_strName;};
  QString getAddress() const {return m_strAddress;};
  QString getNetmask() const {return m_strNetmask;};
  QString getState() const {return m_strState;};
  QString getType() const {return m_strType;};
  QString getHWaddress() const {return m_strHWaddr;};

private:
  QString m_strName;
  QString m_strAddress;
  QString m_strNetmask;
  QString m_strState;
  QString m_strType;
  QString m_strHWaddr;
};

typedef QPtrList<DeviceData> DeviceList;

/**
 * This class is needed to get all the system network devices information
 *
 * @author Giovanni Venturi
 */
class NetworkDevice
{
public:
  NetworkDevice();
  ~NetworkDevice();

  /**
   * Assign to its private netDeviceList variable the list of the
   * network device available on your system
   */
  void detect();

  /**
   * Using this function you get the list of the available interfaces.
   * This list can be used, for example, to choose an interface, like in the
   * Capture Dialog.
   * @return a QStringList containing the names of the available interfaces
   */
  QStringList interfaceList() const;
  bool null() const { return (!m_hasDevices); };
  DeviceData interfaceData( const QString & strInterface ) const;
  QString address( const DeviceData & data ) const { return data.m_strAddress; };
  QString netmask( const DeviceData & data ) const { return data.m_strNetmask; };

private:
    static QString HWaddr2String( char *hwaddr );

private:
  DeviceList *m_netDeviceList;
  bool m_hasDevices;  // true is there is network device on the system

};

#endif
