/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef CaptureDialog_H
#define CaptureDialog_H

#include <kdialogbase.h>

#include "networkdevice.h"

class QWidget;
class QComboBox;
class QLabel;
class QCheckBox;

/**
 * The class for the Capture Dialog.
 *
 * @author Giovanni Venturi
 */
class CaptureDialog : public KDialogBase
{
  Q_OBJECT

public:
  CaptureDialog(QWidget *parent = 0);
  ~CaptureDialog();

  /**
   * The interface the user selected to sniff. For example this can
   * be eth1, ppp0, etc. A special string is 'any', that means the
   * user wants to sniff all the available interfaces.
   * @return the interface selected by the user
   */
  QString selectedInterface() const { return m_strUsedInterface; };

protected slots:
  /**
   * Execute this to close dialog accepting the selected interface to sniff
   */
  virtual void slotOk();
  virtual void slotDefault();

  /**
   * Redetect network interfaces.
   */
  void slotRedetect();

  /**
   * Display IP address and Netmask for a specified Interface.
   * @param strInterface is the string containing the interface we
   * want to show the details about.
   */
  void setData( const QString & strInterface );

private:
  NetworkDevice m_netDevice;
  QString m_strUsedInterface;

  QComboBox* m_interface;
  QLabel* m_ipaddress;
  QLabel* m_netmask;
  QLabel* m_macAddress;
};

#endif
