/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <qpixmap.h>

#include <kiconloader.h>

#include "ksnifferpassivepopup.h"

KSnifferPassivePopup::KSnifferPassivePopup()
{
}

void KSnifferPassivePopup::message(const QString& caption, const QString& text, QWidget *parent, const char *name, int seconds)
{
  QPixmap icon = BarIcon( "ksniffer" );
  KPassivePopup *popup = new KPassivePopup( parent, "popup" );
  popup->setAutoDelete( true );
  popup->setTimeout( seconds*1000 );
  popup->setView( caption, text, icon);

  popup->show();
  if (parent->isShown() && !parent->isMinimized())
  {
    popup->move( QPoint(parent->x() + (parent->width() - popup->width()) / 2,
      parent->y() + (parent->height() - popup->height()) / 2) );
  }
}
